/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite3.internal.sql.engine.rel.SourceAwareIgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite3.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite3.internal.sql.engine.util.Commons;

public class IgniteValues
extends Values
implements SourceAwareIgniteRel {
    private static final String REL_TYPE_NAME = "Values";
    private final long sourceId;

    public IgniteValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traits) {
        this(-1L, cluster, rowType, tuples, traits);
    }

    private IgniteValues(long sourceId, RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traits) {
        super(cluster, rowType, tuples, traits);
        this.sourceId = sourceId;
    }

    public IgniteValues(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
        Object srcIdObj = input.get("sourceId");
        this.sourceId = srcIdObj != null ? ((Number)srcIdObj).longValue() : -1L;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteValues(cluster, this.getRowType(), (ImmutableList<ImmutableList<RexLiteral>>)this.getTuples(), this.getTraitSet());
    }

    @Override
    public IgniteRel clone(long sourceId) {
        return new IgniteValues(sourceId, this.getCluster(), this.getRowType(), (ImmutableList<ImmutableList<RexLiteral>>)this.getTuples(), this.getTraitSet());
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("sourceId", (Object)this.sourceId, this.sourceId != -1L);
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        return writer.addTuples(Commons.cast(this.tuples));
    }
}

