/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.trait;

import java.util.List;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite3.internal.sql.engine.trait.DistributionFunction;
import org.apache.ignite3.internal.sql.engine.trait.DistributionTrait;
import org.apache.ignite3.internal.sql.engine.trait.DistributionTraitDef;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite3.internal.util.CollectionUtils;

public class IgniteDistributions {
    private static final IgniteDistribution BROADCAST = IgniteDistributions.canonize(new DistributionTrait(DistributionFunction.broadcast()));
    private static final IgniteDistribution SINGLETON = IgniteDistributions.canonize(new DistributionTrait(DistributionFunction.singleton()));
    private static final IgniteDistribution RANDOM = IgniteDistributions.canonize(new DistributionTrait(DistributionFunction.random()));
    private static final IgniteDistribution ANY = IgniteDistributions.canonize(new DistributionTrait(DistributionFunction.any()));

    public static IgniteDistribution any() {
        return ANY;
    }

    public static IgniteDistribution random() {
        return RANDOM;
    }

    public static IgniteDistribution single() {
        return SINGLETON;
    }

    public static IgniteDistribution broadcast() {
        return BROADCAST;
    }

    public static IgniteDistribution affinity(List<Integer> keys, int tableId, int zoneId, String label) {
        assert (!CollectionUtils.nullOrEmpty(keys)) : "Hash-based distribution must have at least one key";
        return IgniteDistributions.canonize(new DistributionTrait(keys, tableId, zoneId, label, DistributionFunction.hash()));
    }

    public static IgniteDistribution hash(List<Integer> keys) {
        return IgniteDistributions.hash(keys, DistributionFunction.hash());
    }

    public static IgniteDistribution hash(List<Integer> keys, DistributionFunction function) {
        assert (!CollectionUtils.nullOrEmpty(keys)) : "Hash-based distribution must have at least one key";
        return IgniteDistributions.canonize(new DistributionTrait(keys, function));
    }

    public static IgniteDistribution identity(int key) {
        return IgniteDistributions.canonize(new DistributionTrait((List<Integer>)ImmutableIntList.of((int[])new int[]{key}), DistributionFunction.identity()));
    }

    public static IgniteDistribution clone(IgniteDistribution trait, List<Integer> keys) {
        assert (!CollectionUtils.nullOrEmpty(keys)) : "Hash-based distribution must have at least one key";
        assert (trait.function().type() == RelDistribution.Type.HASH_DISTRIBUTED);
        DistributionTrait distributionTrait = trait.isTableDistribution() ? new DistributionTrait(keys, trait.tableId(), trait.zoneId(), trait.label(), trait.function()) : new DistributionTrait(keys, trait.function());
        return IgniteDistributions.canonize(distributionTrait);
    }

    private static IgniteDistribution canonize(IgniteDistribution distr) {
        return (IgniteDistribution)DistributionTraitDef.INSTANCE.canonize((RelTrait)distr);
    }
}

