/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.index.hash;

import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite3.internal.pagememory.tree.IgniteTree;
import org.apache.ignite3.internal.storage.pagememory.index.freelist.IndexColumns;
import org.apache.ignite3.internal.storage.pagememory.index.hash.HashIndexRow;
import org.jetbrains.annotations.Nullable;

class RemoveHashIndexRowInvokeClosure
implements IgniteTree.InvokeClosure<HashIndexRow> {
    private final HashIndexRow hashIndexRow;
    private final FreeListImpl freeList;
    private IgniteTree.OperationType operationType = IgniteTree.OperationType.REMOVE;

    public RemoveHashIndexRowInvokeClosure(HashIndexRow hashIndexRow, FreeListImpl freeList) {
        assert (hashIndexRow.indexColumns().link() == 0L);
        this.hashIndexRow = hashIndexRow;
        this.freeList = freeList;
    }

    @Override
    public void call(@Nullable HashIndexRow oldRow) {
        if (oldRow == null) {
            this.operationType = IgniteTree.OperationType.NOOP;
        } else {
            this.hashIndexRow.indexColumns().link(oldRow.indexColumns().link());
        }
    }

    @Override
    @Nullable
    public HashIndexRow newRow() {
        return null;
    }

    @Override
    public IgniteTree.OperationType operationType() {
        return this.operationType;
    }

    public void afterCompletion() throws IgniteInternalCheckedException {
        IndexColumns indexColumns = this.hashIndexRow.indexColumns();
        if (indexColumns.link() != 0L) {
            assert (this.operationType == IgniteTree.OperationType.REMOVE);
            this.freeList.removeDataRowByLink(indexColumns.link());
            indexColumns.link(0L);
        }
    }
}

