/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.UUID;
import java.util.function.Supplier;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.tree.IgniteTree;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.AddWriteResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChain;
import org.jetbrains.annotations.Nullable;

class AddWriteInvokeClosure
implements IgniteTree.InvokeClosure<VersionChain> {
    private final RowId rowId;
    @Nullable
    private final BinaryRow row;
    private final UUID txId;
    private final int commitTableOrZoneId;
    private final int commitPartitionId;
    private final AbstractPageMemoryMvPartitionStorage storage;
    private IgniteTree.OperationType operationType;
    @Nullable
    private VersionChain newRow;
    @Nullable
    private RowVersion toRemove;
    private AddWriteResult addWriteResult;

    AddWriteInvokeClosure(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitTableOrZoneId, int commitPartitionId, AbstractPageMemoryMvPartitionStorage storage) {
        this.rowId = rowId;
        this.row = row;
        this.txId = txId;
        this.commitTableOrZoneId = commitTableOrZoneId;
        this.commitPartitionId = commitPartitionId;
        this.storage = storage;
    }

    @Override
    public void call(@Nullable VersionChain oldRow) throws IgniteInternalCheckedException {
        if (oldRow == null) {
            RowVersion newVersion = this.insertRowVersion(this.row, 0L);
            this.newRow = VersionChain.createUncommitted(this.rowId, this.txId, this.commitTableOrZoneId, this.commitPartitionId, newVersion.link(), 0L);
            this.operationType = IgniteTree.OperationType.PUT;
            this.addWriteResult = AddWriteResult.success(null);
            return;
        }
        if (oldRow.isUncommitted() && !this.txId.equals(oldRow.transactionId())) {
            this.addWriteResult = AddWriteResult.txMismatch(oldRow.transactionId(), AddWriteInvokeClosure.latestCommitTimestamp(this.storage, oldRow, this::addWriteInfo));
            this.operationType = IgniteTree.OperationType.NOOP;
            return;
        }
        RowVersion newVersion = this.insertRowVersion(this.row, oldRow.newestCommittedLink());
        if (oldRow.isUncommitted()) {
            RowVersion currentVersion = this.storage.readRowVersion(oldRow.headLink(), AbstractPageMemoryMvPartitionStorage.ALWAYS_LOAD_VALUE);
            this.addWriteResult = AddWriteResult.success(currentVersion.value());
            this.toRemove = currentVersion;
        } else {
            this.addWriteResult = AddWriteResult.success(null);
        }
        this.newRow = VersionChain.createUncommitted(this.rowId, this.txId, this.commitTableOrZoneId, this.commitPartitionId, newVersion.link(), newVersion.nextLink());
        this.operationType = IgniteTree.OperationType.PUT;
    }

    @Override
    @Nullable
    public VersionChain newRow() {
        assert (this.operationType == IgniteTree.OperationType.PUT == (this.newRow != null)) : this.addWriteInfo() + ", newRow=" + this.newRow + ", op=" + this.operationType;
        return this.newRow;
    }

    @Override
    public IgniteTree.OperationType operationType() {
        assert (this.operationType != null) : this.addWriteInfo();
        return this.operationType;
    }

    private RowVersion insertRowVersion(@Nullable BinaryRow row, long nextPartitionlessLink) {
        RowVersion rowVersion = new RowVersion(this.storage.partitionId, nextPartitionlessLink, row);
        this.storage.insertRowVersion(rowVersion);
        return rowVersion;
    }

    void afterCompletion() {
        if (this.toRemove != null) {
            this.storage.removeRowVersion(this.toRemove);
        }
    }

    @Nullable
    static HybridTimestamp latestCommitTimestamp(AbstractPageMemoryMvPartitionStorage storage, VersionChain chain, Supplier<String> operationInfo) {
        if (!chain.hasCommittedVersions()) {
            return null;
        }
        RowVersion rowVersion = storage.readRowVersion(chain.newestCommittedLink(), AbstractPageMemoryMvPartitionStorage.DONT_LOAD_VALUE);
        assert (rowVersion != null) : operationInfo.get() + ", newestCommittedLink=" + chain.newestCommittedLink();
        return rowVersion.timestamp();
    }

    AddWriteResult addWriteResult() {
        return this.addWriteResult;
    }

    private String addWriteInfo() {
        return this.storage.addWriteInfo(this.rowId, this.row, this.txId, this.commitTableOrZoneId, this.commitPartitionId);
    }
}

