/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.storage.rocksdb.index.RocksDbBinaryTupleComparator;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.sql.ColumnType;
import org.rocksdb.RocksDB;

public class ColumnFamilyUtils {
    private static final String META_CF_NAME = "default";
    private static final String PARTITION_CF_NAME = "cf-part";
    private static final String DATA_CF_NAME = "cf-data";
    private static final String GC_QUEUE_CF_NAME = "cf-gc";
    private static final String HASH_INDEX_CF_NAME = "cf-hash";
    private static final String SORTED_INDEX_CF_PREFIX = "cf-sorted-";
    public static final List<byte[]> DEFAULT_CF_NAMES;
    private static final int NULLABILITY_FLAG = 1;
    private static final int ASC_ORDER_FLAG = 2;
    private static final int NULLS_FIRST_FLAG = 4;

    public static String toStringName(byte[] cfName) {
        return new String(cfName, StandardCharsets.UTF_8);
    }

    public static byte[] sortedIndexCfName(List<StorageSortedIndexDescriptor.StorageSortedIndexColumnDescriptor> columns) {
        ByteBuffer buf = ByteBuffer.allocate(SORTED_INDEX_CF_PREFIX.length() + columns.size() * 2);
        buf.put(SORTED_INDEX_CF_PREFIX.getBytes(StandardCharsets.UTF_8));
        for (StorageSortedIndexDescriptor.StorageSortedIndexColumnDescriptor column : columns) {
            NativeType nativeType = column.type();
            ColumnType type = nativeType.spec();
            buf.put((byte)type.id());
            int flags = 0;
            if (column.nullable()) {
                flags |= 1;
            }
            if (column.asc()) {
                flags |= 2;
            }
            if (column.nullsFirst()) {
                flags |= 4;
            }
            buf.put((byte)flags);
        }
        return buf.array();
    }

    public static RocksDbBinaryTupleComparator comparatorFromCfName(byte[] cfName) {
        int prefixLen = SORTED_INDEX_CF_PREFIX.length();
        ArrayList<StorageSortedIndexDescriptor.StorageSortedIndexColumnDescriptor> columns = new ArrayList<StorageSortedIndexDescriptor.StorageSortedIndexColumnDescriptor>((cfName.length - prefixLen) / 2);
        for (int i = prefixLen; i < cfName.length; i += 2) {
            NativeType nativeType;
            byte typeSpecOrdinal = cfName[i];
            byte nativeTypeFlags = cfName[i + 1];
            ColumnType typeSpec = ColumnType.getById(typeSpecOrdinal);
            assert (typeSpec != null) : IgniteStringFormatter.format("Invalid sorted index CF name. [nameBytes={}]", Arrays.toString(cfName));
            switch (typeSpec) {
                case BOOLEAN: {
                    nativeType = NativeTypes.BOOLEAN;
                    break;
                }
                case INT8: {
                    nativeType = NativeTypes.INT8;
                    break;
                }
                case INT16: {
                    nativeType = NativeTypes.INT16;
                    break;
                }
                case INT32: {
                    nativeType = NativeTypes.INT32;
                    break;
                }
                case INT64: {
                    nativeType = NativeTypes.INT64;
                    break;
                }
                case FLOAT: {
                    nativeType = NativeTypes.FLOAT;
                    break;
                }
                case DOUBLE: {
                    nativeType = NativeTypes.DOUBLE;
                    break;
                }
                case DECIMAL: {
                    nativeType = NativeTypes.decimalOf(-1, 0);
                    break;
                }
                case UUID: {
                    nativeType = NativeTypes.UUID;
                    break;
                }
                case STRING: {
                    nativeType = NativeTypes.stringOf(-1);
                    break;
                }
                case BYTE_ARRAY: {
                    nativeType = NativeTypes.BYTES;
                    break;
                }
                case DATE: {
                    nativeType = NativeTypes.DATE;
                    break;
                }
                case TIME: {
                    nativeType = NativeTypes.time(0);
                    break;
                }
                case DATETIME: {
                    nativeType = NativeTypes.datetime(6);
                    break;
                }
                case TIMESTAMP: {
                    nativeType = NativeTypes.timestamp(6);
                    break;
                }
                default: {
                    throw new AssertionError((Object)IgniteStringFormatter.format("Unexpected native type. [spec={}]", new Object[]{typeSpec}));
                }
            }
            boolean nullable = (nativeTypeFlags & 1) != 0;
            boolean asc = (nativeTypeFlags & 2) != 0;
            boolean nullsFirst = (nativeTypeFlags & 4) != 0;
            columns.add(new StorageSortedIndexDescriptor.StorageSortedIndexColumnDescriptor("<unknown>", nativeType, nullable, asc, nullsFirst));
        }
        return new RocksDbBinaryTupleComparator(columns);
    }

    static {
        RocksDB.loadLibrary();
        DEFAULT_CF_NAMES = List.of(META_CF_NAME.getBytes(StandardCharsets.UTF_8), PARTITION_CF_NAME.getBytes(StandardCharsets.UTF_8), DATA_CF_NAME.getBytes(StandardCharsets.UTF_8), GC_QUEUE_CF_NAME.getBytes(StandardCharsets.UTF_8), HASH_INDEX_CF_NAME.getBytes(StandardCharsets.UTF_8));
    }

    public static enum ColumnFamilyType {
        META,
        PARTITION,
        GC_QUEUE,
        DATA,
        HASH_INDEX,
        SORTED_INDEX,
        UNKNOWN;


        public static ColumnFamilyType fromCfName(String cfName) {
            if (ColumnFamilyUtils.META_CF_NAME.equals(cfName)) {
                return META;
            }
            if (ColumnFamilyUtils.PARTITION_CF_NAME.equals(cfName)) {
                return PARTITION;
            }
            if (ColumnFamilyUtils.GC_QUEUE_CF_NAME.equals(cfName)) {
                return GC_QUEUE;
            }
            if (ColumnFamilyUtils.DATA_CF_NAME.equals(cfName)) {
                return DATA;
            }
            if (ColumnFamilyUtils.HASH_INDEX_CF_NAME.equals(cfName)) {
                return HASH_INDEX;
            }
            if (cfName.startsWith(ColumnFamilyUtils.SORTED_INDEX_CF_PREFIX)) {
                return SORTED_INDEX;
            }
            return UNKNOWN;
        }
    }
}

