/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.schema;

import java.util.concurrent.CompletableFuture;
import java.util.function.LongSupplier;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.schema.SchemaSafeTimeTracker;
import org.apache.ignite3.internal.schema.SchemaSyncService;

public class SchemaSyncServiceImpl
implements SchemaSyncService {
    private final SchemaSafeTimeTracker schemaSafeTimeTracker;
    private final LongSupplier delayDurationMs;

    public SchemaSyncServiceImpl(SchemaSafeTimeTracker schemaSafeTimeTracker, LongSupplier delayDurationMs) {
        this.schemaSafeTimeTracker = schemaSafeTimeTracker;
        this.delayDurationMs = delayDurationMs;
    }

    @Override
    public CompletableFuture<Void> waitForMetadataCompleteness(HybridTimestamp ts) {
        return this.schemaSafeTimeTracker.waitFor(this.metastoreSafeTimeToWait(ts));
    }

    private HybridTimestamp metastoreSafeTimeToWait(HybridTimestamp ts) {
        return ts.subtractPhysicalTime(this.delayDurationMs.getAsLong());
    }
}

