/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.entity;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.entity.FileBuilder;
import org.apache.ignite3.raft.jraft.entity.FileSerializer;
import org.apache.ignite3.raft.jraft.entity.LocalFileMetaOutter;
import org.apache.ignite3.raft.jraft.entity.LocalStorageOutter;

public class FileImpl
implements LocalStorageOutter.LocalSnapshotPbMeta.File,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 2005;
    @IgniteToStringInclude
    private final LocalFileMetaOutter.LocalFileMeta meta;
    @IgniteToStringInclude
    private final String name;

    private FileImpl(LocalFileMetaOutter.LocalFileMeta meta, String name) {
        this.meta = meta;
        this.name = name;
    }

    @Override
    public LocalFileMetaOutter.LocalFileMeta meta() {
        return this.meta;
    }

    @Override
    public String name() {
        return this.name;
    }

    public MessageSerializer serializer() {
        return FileSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(FileImpl.class, this);
    }

    @Override
    public short messageType() {
        return 2005;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FileImpl otherMessage = (FileImpl)other;
        return Objects.equals(this.meta, otherMessage.meta) && Objects.equals(this.name, otherMessage.name);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.meta, this.name);
        return result;
    }

    @Override
    public FileImpl clone() {
        try {
            return (FileImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static FileBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.meta != null) {
            this.meta.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.meta != null) {
            this.meta.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements FileBuilder {
        private LocalFileMetaOutter.LocalFileMeta meta;
        private String name;

        private Builder() {
        }

        @Override
        public FileBuilder meta(LocalFileMetaOutter.LocalFileMeta meta) {
            Objects.requireNonNull(meta, "meta is not marked @Nullable");
            this.meta = meta;
            return this;
        }

        @Override
        public FileBuilder name(String name) {
            Objects.requireNonNull(name, "name is not marked @Nullable");
            this.name = name;
            return this;
        }

        @Override
        public LocalFileMetaOutter.LocalFileMeta meta() {
            return this.meta;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public LocalStorageOutter.LocalSnapshotPbMeta.File build() {
            return new FileImpl(Objects.requireNonNull(this.meta, "meta is not marked @Nullable"), Objects.requireNonNull(this.name, "name is not marked @Nullable"));
        }
    }
}

