/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted;

import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;
import java.util.function.Function;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.internal.U;

public final class IndexKeyType
extends Enum<IndexKeyType> {
    public static final /* enum */ IndexKeyType UNKNOWN = new IndexKeyType(-1);
    public static final /* enum */ IndexKeyType NULL = new IndexKeyType(0);
    public static final /* enum */ IndexKeyType BOOLEAN = new IndexKeyType(1);
    public static final /* enum */ IndexKeyType BYTE = new IndexKeyType(2);
    public static final /* enum */ IndexKeyType SHORT = new IndexKeyType(3);
    public static final /* enum */ IndexKeyType INT = new IndexKeyType(4);
    public static final /* enum */ IndexKeyType LONG = new IndexKeyType(5);
    public static final /* enum */ IndexKeyType DECIMAL = new IndexKeyType(6);
    public static final /* enum */ IndexKeyType DOUBLE = new IndexKeyType(7);
    public static final /* enum */ IndexKeyType FLOAT = new IndexKeyType(8);
    public static final /* enum */ IndexKeyType TIME = new IndexKeyType(9);
    public static final /* enum */ IndexKeyType DATE = new IndexKeyType(10);
    public static final /* enum */ IndexKeyType TIMESTAMP = new IndexKeyType(11);
    public static final /* enum */ IndexKeyType BYTES = new IndexKeyType(12);
    public static final /* enum */ IndexKeyType STRING = new IndexKeyType(13);
    public static final /* enum */ IndexKeyType STRING_IGNORECASE = new IndexKeyType(14);
    public static final /* enum */ IndexKeyType BLOB = new IndexKeyType(15);
    public static final /* enum */ IndexKeyType CLOB = new IndexKeyType(16);
    public static final /* enum */ IndexKeyType ARRAY = new IndexKeyType(17);
    public static final /* enum */ IndexKeyType RESULT_SET = new IndexKeyType(18);
    public static final /* enum */ IndexKeyType JAVA_OBJECT = new IndexKeyType(19);
    public static final /* enum */ IndexKeyType UUID = new IndexKeyType(20);
    public static final /* enum */ IndexKeyType STRING_FIXED = new IndexKeyType(21);
    public static final /* enum */ IndexKeyType GEOMETRY = new IndexKeyType(22);
    public static final /* enum */ IndexKeyType TIMESTAMP_TZ = new IndexKeyType(24);
    public static final /* enum */ IndexKeyType ENUM = new IndexKeyType(25);
    private final int code;
    private static final IndexKeyType[] keyTypesByCode;
    private static final /* synthetic */ IndexKeyType[] $VALUES;

    public static IndexKeyType[] values() {
        return (IndexKeyType[])$VALUES.clone();
    }

    public static IndexKeyType valueOf(String name) {
        return Enum.valueOf(IndexKeyType.class, name);
    }

    private IndexKeyType(int code) {
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public static IndexKeyType forCode(int code) {
        if (code == IndexKeyType.UNKNOWN.code) {
            return UNKNOWN;
        }
        if (code < 0 || code >= keyTypesByCode.length) {
            throw new IllegalArgumentException("Argument is invalid: " + code);
        }
        return keyTypesByCode[code];
    }

    public static IndexKeyType forClass(Class<?> cls) {
        if (cls == null) {
            return NULL;
        }
        if (String.class == (cls = U.box(cls))) {
            return STRING;
        }
        if (Integer.class == cls) {
            return INT;
        }
        if (Long.class == cls) {
            return LONG;
        }
        if (Boolean.class == cls) {
            return BOOLEAN;
        }
        if (Double.class == cls) {
            return DOUBLE;
        }
        if (Byte.class == cls) {
            return BYTE;
        }
        if (Short.class == cls) {
            return SHORT;
        }
        if (Character.class == cls) {
            throw new IgniteException("Cannot convert class char (not supported)");
        }
        if (Float.class == cls) {
            return FLOAT;
        }
        if (byte[].class == cls) {
            return BYTES;
        }
        if (UUID.class == cls) {
            return UUID;
        }
        if (Void.class == cls) {
            return NULL;
        }
        if (BigDecimal.class.isAssignableFrom(cls)) {
            return DECIMAL;
        }
        if (ResultSet.class.isAssignableFrom(cls)) {
            return RESULT_SET;
        }
        if (Date.class.isAssignableFrom(cls)) {
            return DATE;
        }
        if (Time.class.isAssignableFrom(cls)) {
            return TIME;
        }
        if (Timestamp.class.isAssignableFrom(cls)) {
            return TIMESTAMP;
        }
        if (java.util.Date.class.isAssignableFrom(cls)) {
            return TIMESTAMP;
        }
        if (Clob.class.isAssignableFrom(cls)) {
            return CLOB;
        }
        if (Blob.class.isAssignableFrom(cls)) {
            return BLOB;
        }
        if (Object[].class.isAssignableFrom(cls)) {
            return ARRAY;
        }
        if (QueryUtils.isGeometryClass(cls)) {
            return GEOMETRY;
        }
        if (LocalDate.class == cls) {
            return DATE;
        }
        if (LocalTime.class == cls) {
            return TIME;
        }
        if (LocalDateTime.class == cls) {
            return TIMESTAMP;
        }
        if (OffsetDateTime.class == cls || Instant.class == cls) {
            return TIMESTAMP_TZ;
        }
        return JAVA_OBJECT;
    }

    static {
        $VALUES = new IndexKeyType[]{UNKNOWN, NULL, BOOLEAN, BYTE, SHORT, INT, LONG, DECIMAL, DOUBLE, FLOAT, TIME, DATE, TIMESTAMP, BYTES, STRING, STRING_IGNORECASE, BLOB, CLOB, ARRAY, RESULT_SET, JAVA_OBJECT, UUID, STRING_FIXED, GEOMETRY, TIMESTAMP_TZ, ENUM};
        int maxCode = Collections.max(Arrays.asList(IndexKeyType.values()), Comparator.comparing((Function<IndexKeyType, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, code(), (Lorg/apache/ignite/internal/cache/query/index/sorted/IndexKeyType;)Ljava/lang/Integer;)())).code;
        keyTypesByCode = new IndexKeyType[maxCode + 1];
        for (IndexKeyType type : IndexKeyType.values()) {
            assert (type.code >= 0 || type == UNKNOWN);
            if (type.code < 0) continue;
            IndexKeyType.keyTypesByCode[type.code] = type;
        }
    }
}

