/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management;

import java.util.UUID;
import java.util.function.Consumer;
import org.apache.ignite.Ignite;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientClusterState;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.LocalCommand;
import org.apache.ignite.internal.management.api.NoArg;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.misc.VisorIdAndTagViewTask;
import org.apache.ignite.internal.visor.misc.VisorIdAndTagViewTaskResult;
import org.jetbrains.annotations.Nullable;

public class StateCommand
implements LocalCommand<NoArg, GridTuple3<UUID, String, ClusterState>> {
    @Override
    public String description() {
        return "Print current cluster state";
    }

    @Override
    public Class<NoArg> argClass() {
        return NoArg.class;
    }

    @Override
    public GridTuple3<UUID, String, ClusterState> execute(@Nullable GridClient cli, @Nullable IgniteClient client, @Nullable Ignite ignite, NoArg arg, Consumer<String> printer) throws Exception {
        String tag;
        UUID id;
        ClusterState state;
        if (cli != null) {
            GridClientClusterState state0 = cli.state();
            state = state0.state();
            id = state0.id();
            tag = state0.tag();
        } else if (client != null) {
            VisorIdAndTagViewTaskResult idAndTag = (VisorIdAndTagViewTaskResult)CommandUtils.execute(null, client, null, VisorIdAndTagViewTask.class, null, CommandUtils.nodes(cli, client, ignite));
            state = client.cluster().state();
            id = idAndTag.id();
            tag = idAndTag.tag();
        } else {
            state = ignite.cluster().state();
            id = ignite.cluster().id();
            tag = ignite.cluster().tag();
        }
        printer.accept("Cluster  ID: " + id);
        printer.accept("Cluster tag: " + tag);
        printer.accept("--------------------------------------------------------------------------------");
        printer.accept("Cluster state: " + state);
        return F.t(id, tag, state);
    }
}

