/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.ArgumentGroup;
import org.apache.ignite.internal.management.api.EnumDescription;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.management.cache.CacheMetricsOperation;
import org.apache.ignite.internal.util.typedef.internal.U;

@ArgumentGroup(value={"caches", "allCaches"}, onlyOneOf=true, optional=false)
public class CacheMetricsCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument
    @EnumDescription(names={"ENABLE", "DISABLE", "STATUS"}, descriptions={"Enable metrics", "Disable metrics", "Status"})
    private CacheMetricsOperation operation;
    @Argument(description="specifies a comma-separated list of cache names to which operation should be applied", example="cache1[,...,cacheN]")
    private String[] caches;
    @Argument(description="applies operation to all user caches")
    private boolean allCaches;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.operation);
        U.writeArray(out, this.caches);
        out.writeBoolean(this.allCaches);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.operation = U.readEnum(in, CacheMetricsOperation.class);
        this.caches = U.readArray(in, String.class);
        this.allCaches = in.readBoolean();
    }

    public CacheMetricsOperation operation() {
        return this.operation;
    }

    public void operation(CacheMetricsOperation op) {
        this.operation = op;
    }

    public String[] caches() {
        return this.caches;
    }

    public void caches(String[] caches) {
        this.caches = caches;
    }

    public boolean allCaches() {
        return this.allCaches;
    }

    public void allCaches(boolean allCaches) {
        this.allCaches = allCaches;
    }
}

