/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.encryption;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.encryption.CacheGroupEncryptionTaskResult;
import org.apache.ignite.internal.management.encryption.EncryptionCacheGroupArg;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.jetbrains.annotations.Nullable;

public abstract class CacheGroupEncryptionTask<T>
extends VisorMultiNodeTask<EncryptionCacheGroupArg, CacheGroupEncryptionTaskResult<T>, SingleFieldDto<T>> {
    @Override
    @Nullable
    protected CacheGroupEncryptionTaskResult<T> reduce0(List<ComputeJobResult> results) {
        HashMap jobResults = new HashMap();
        HashMap<UUID, IgniteException> exceptions = new HashMap<UUID, IgniteException>();
        for (ComputeJobResult res : results) {
            UUID nodeId = res.getNode().id();
            if (res.getException() != null) {
                exceptions.put(nodeId, res.getException());
                continue;
            }
            SingleFieldDto dtoRes = (SingleFieldDto)res.getData();
            jobResults.put(nodeId, dtoRes.value());
        }
        return new CacheGroupEncryptionTaskResult(jobResults, exceptions);
    }

    protected static abstract class ReencryptionBaseJob<T>
    extends VisorJob<EncryptionCacheGroupArg, SingleFieldDto<T>> {
        protected ReencryptionBaseJob(@Nullable EncryptionCacheGroupArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected SingleFieldDto<T> run(EncryptionCacheGroupArg arg) throws IgniteException {
            try {
                String grpName = arg.cacheGroupName();
                CacheGroupContext grp = this.ignite.context().cache().cacheGroup(CU.cacheId(grpName));
                if (grp == null) {
                    IgniteInternalCache cache = this.ignite.context().cache().cache(grpName);
                    if (cache == null) {
                        throw new IgniteException("Cache group " + grpName + " not found.");
                    }
                    grp = cache.context().group();
                    if (grp.sharedGroup()) {
                        throw new IgniteException("Cache or group \"" + grpName + "\" is a part of group \"" + grp.name() + "\". Provide group name instead of cache name for shared groups.");
                    }
                }
                return this.run0(grp);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        protected abstract SingleFieldDto<T> run0(CacheGroupContext var1) throws IgniteCheckedException;
    }

    public static abstract class SingleFieldDto<T>
    extends IgniteDataTransferObject {
        private T val;

        protected T value() {
            return this.val;
        }

        protected SingleFieldDto<T> value(T val) {
            this.val = val;
            return this;
        }
    }
}

