/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.encryption;

import java.util.function.Consumer;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.encryption.ChangeCacheGroupKeyTask;
import org.apache.ignite.internal.management.encryption.EncryptionCacheGroupArg;

public class EncryptionChangeCacheKeyCommand
implements ComputeCommand<EncryptionCacheGroupArg, Void> {
    @Override
    public String description() {
        return "Change the encryption key of the cache group";
    }

    @Override
    public Class<EncryptionCacheGroupArg> argClass() {
        return EncryptionCacheGroupArg.class;
    }

    @Override
    public Class<ChangeCacheGroupKeyTask> taskClass() {
        return ChangeCacheGroupKeyTask.class;
    }

    @Override
    public void printResult(EncryptionCacheGroupArg arg, Void res, Consumer<String> printer) {
        printer.accept("The encryption key has been changed for the cache group \"" + arg.cacheGroupName() + "\".");
    }

    @Override
    public String confirmationPrompt(EncryptionCacheGroupArg arg) {
        return "Warning: the command will change the encryption key of the cache group. Joining a node during the key change process is prohibited and will be rejected.";
    }
}

