/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.MetaPageUpdatePartitionDataRecordV2;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIOV3;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MetaPageUpdatePartitionDataRecordV3
extends MetaPageUpdatePartitionDataRecordV2 {
    private int encryptedPageIdx;
    private int encryptedPageCnt;

    public MetaPageUpdatePartitionDataRecordV3(int grpId, long pageId, long updateCntr, long globalRmvId, int partSize, long cntrsPageId, byte state, int allocatedIdxCandidate, long link, int encryptedPageIdx, int encryptedPageCnt) {
        super(grpId, pageId, updateCntr, globalRmvId, partSize, cntrsPageId, state, allocatedIdxCandidate, link);
        this.encryptedPageIdx = encryptedPageIdx;
        this.encryptedPageCnt = encryptedPageCnt;
    }

    public MetaPageUpdatePartitionDataRecordV3(DataInput in) throws IOException {
        super(in);
        this.encryptedPageIdx = in.readInt();
        this.encryptedPageCnt = in.readInt();
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        super.applyDelta(pageMem, pageAddr);
        PagePartitionMetaIOV3 io = (PagePartitionMetaIOV3)PagePartitionMetaIO.VERSIONS.forPage(pageAddr);
        io.setEncryptedPageIndex(pageAddr, this.encryptedPageIdx);
        io.setEncryptedPageCount(pageAddr, this.encryptedPageCnt);
    }

    public int encryptedPageIndex() {
        return this.encryptedPageIdx;
    }

    public int encryptedPageCount() {
        return this.encryptedPageCnt;
    }

    @Override
    public void toBytes(ByteBuffer buf) {
        super.toBytes(buf);
        buf.putInt(this.encryptedPageIndex());
        buf.putInt(this.encryptedPageCount());
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.PARTITION_META_PAGE_DELTA_RECORD_V3;
    }

    @Override
    public String toString() {
        return S.toString(MetaPageUpdatePartitionDataRecordV3.class, this, "partId", (Object)PageIdUtils.partId(this.pageId()), "super", (Object)super.toString());
    }
}

