/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.metric.MetricRegistryImpl;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderWithDelegateMetric;
import org.jetbrains.annotations.Nullable;

public class PageMetricsImpl
implements PageMetrics {
    private final LongAdderMetric totalPages;
    private final LongAdderMetric idxPages;

    private PageMetricsImpl(MetricRegistryImpl metricRegistry, @Nullable LongAdderWithDelegateMetric.Delegate totalPagesCb, @Nullable LongAdderWithDelegateMetric.Delegate idxPagesCb) {
        this.totalPages = PageMetricsImpl.createMetricWithOptionalDelegate(metricRegistry, "TotalAllocatedPages", "Total allocated pages.", totalPagesCb);
        this.idxPages = PageMetricsImpl.createMetricWithOptionalDelegate(metricRegistry, "InMemoryIndexPages", "Amount of index pages loaded into memory.", idxPagesCb);
    }

    public static Builder builder(MetricRegistryImpl metricRegistry) {
        return new Builder(metricRegistry);
    }

    private static LongAdderMetric createMetricWithOptionalDelegate(MetricRegistryImpl metricRegistry, String name, String desc, @Nullable LongAdderWithDelegateMetric.Delegate delegate) {
        return delegate == null ? metricRegistry.longAdderMetric(name, desc) : metricRegistry.longAdderMetric(name, delegate, desc);
    }

    @Override
    public LongAdderMetric totalPages() {
        return this.totalPages;
    }

    @Override
    public LongAdderMetric indexPages() {
        return this.idxPages;
    }

    @Override
    public void reset() {
        this.totalPages.reset();
        this.idxPages.reset();
    }

    public static final class Builder {
        private final MetricRegistryImpl metricRegistry;
        private LongAdderWithDelegateMetric.Delegate totalPagesCb;
        private LongAdderWithDelegateMetric.Delegate idxPagesCb;

        Builder(MetricRegistryImpl metricRegistry) {
            this.metricRegistry = metricRegistry;
        }

        public Builder totalPagesCallback(LongAdderWithDelegateMetric.Delegate cb) {
            this.totalPagesCb = cb;
            return this;
        }

        public Builder indexPagesCallback(LongAdderWithDelegateMetric.Delegate cb) {
            this.idxPagesCb = cb;
            return this;
        }

        public PageMetricsImpl build() {
            return new PageMetricsImpl(this.metricRegistry, this.totalPagesCb, this.idxPagesCb);
        }
    }
}

