/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.reducer;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.index.IndexQueryResultMeta;
import org.apache.ignite.internal.cache.query.index.SortOrder;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparator;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparatorImpl;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKeyFactory;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.query.reducer.MergeSortCacheQueryReducer;
import org.apache.ignite.internal.processors.cache.query.reducer.NodePage;
import org.apache.ignite.internal.processors.cache.query.reducer.NodePageStream;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.lang.IgniteBiTuple;

public class IndexQueryReducer<R>
extends MergeSortCacheQueryReducer<R> {
    private static final long serialVersionUID = 0L;
    private final CompletableFuture<IndexQueryResultMeta> metaFut;
    private final String valType;
    private final GridCacheContext<?, ?> cctx;

    public IndexQueryReducer(String valType, Map<UUID, NodePageStream<R>> pageStreams, GridCacheContext<?, ?> cctx, CompletableFuture<IndexQueryResultMeta> meta) {
        super(pageStreams);
        this.valType = valType;
        this.metaFut = meta;
        this.cctx = cctx;
    }

    @Override
    protected CompletableFuture<Comparator<NodePage<R>>> pageComparator() {
        return this.metaFut.thenApply(m -> {
            LinkedHashMap<String, IndexKeyDefinition> keyDefs = m.keyDefinitions();
            GridQueryTypeDescriptor typeDesc = this.cctx.kernalContext().query().typeDescriptor(this.cctx.name(), QueryUtils.typeName(this.valType));
            return new IndexedNodePageComparator((IndexQueryResultMeta)m, typeDesc, keyDefs);
        });
    }

    private class IndexedNodePageComparator
    implements Comparator<NodePage<R>>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final LinkedHashMap<String, IndexKeyDefinition> keyDefs;
        private final GridQueryTypeDescriptor typeDesc;
        private final IndexQueryResultMeta meta;
        private final IndexRowComparator idxRowComp = new IndexRowComparatorImpl(null);

        IndexedNodePageComparator(IndexQueryResultMeta meta, GridQueryTypeDescriptor typeDesc, LinkedHashMap<String, IndexKeyDefinition> keyDefs) {
            this.meta = meta;
            this.typeDesc = typeDesc;
            this.keyDefs = keyDefs;
        }

        @Override
        public int compare(NodePage<R> o1, NodePage<R> o2) {
            IgniteBiTuple e1 = (IgniteBiTuple)o1.head();
            IgniteBiTuple e2 = (IgniteBiTuple)o2.head();
            Iterator<Map.Entry<String, IndexKeyDefinition>> defs = this.keyDefs.entrySet().iterator();
            try {
                while (defs.hasNext()) {
                    IndexKey k2;
                    Map.Entry<String, IndexKeyDefinition> d = defs.next();
                    IndexKey k1 = this.key(d.getKey(), d.getValue().idxType(), e1);
                    int cmp = this.idxRowComp.compareKey(k1, k2 = this.key(d.getKey(), d.getValue().idxType(), e2));
                    if (cmp == 0) continue;
                    return d.getValue().order().sortOrder() == SortOrder.DESC ? -cmp : cmp;
                }
                return 0;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to sort remote index rows", e);
            }
        }

        private IndexKey key(String key, IndexKeyType type, IgniteBiTuple<?, ?> entry) throws IgniteCheckedException {
            Object o;
            if (this.isKeyField(key)) {
                o = entry.getKey();
            } else if (this.isValueField(key)) {
                o = entry.getValue();
            } else {
                GridQueryProperty prop = this.typeDesc.property(key);
                o = prop.value(entry.getKey(), entry.getValue());
            }
            return IndexKeyFactory.wrap(o, type, (CacheObjectValueContext)IndexQueryReducer.this.cctx.cacheObjectContext(), this.meta.keyTypeSettings());
        }

        private boolean isKeyField(String fld) {
            return fld.equals(this.typeDesc.keyFieldAlias()) || fld.equals("_KEY");
        }

        private boolean isValueField(String fld) {
            return fld.equals(this.typeDesc.valueFieldAlias()) || fld.equals("_VAL");
        }
    }
}

