/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryThreadLocalContext;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequest;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.ClientMessage;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResponse;

public class JdbcMessageParser
implements ClientListenerMessageParser {
    private final GridKernalContext ctx;
    private final JdbcProtocolContext protoCtx;
    protected static final int INIT_CAP = 1024;
    private BinaryContext binCtx;

    public JdbcMessageParser(GridKernalContext ctx, JdbcProtocolContext protoCtx) {
        this.ctx = ctx;
        this.protoCtx = protoCtx;
        this.binCtx = ((CacheObjectBinaryProcessorImpl)ctx.cacheObjects()).marshaller().context();
    }

    protected BinaryReaderExImpl createReader(ClientMessage msg) {
        BinaryHeapInputStream stream = new BinaryHeapInputStream(msg.payload());
        return new BinaryReaderExImpl(this.binCtx, stream, this.ctx.config().getClassLoader(), true);
    }

    protected BinaryWriterExImpl createWriter(int cap) {
        return new BinaryWriterExImpl(this.binCtx, new BinaryHeapOutputStream(cap), BinaryThreadLocalContext.get().schemaHolder(), null);
    }

    @Override
    public ClientListenerRequest decode(ClientMessage msg) {
        assert (msg != null);
        BinaryReaderExImpl reader = this.createReader(msg);
        return JdbcRequest.readRequest(reader, this.protoCtx);
    }

    @Override
    public ClientMessage encode(ClientListenerResponse msg) {
        assert (msg != null);
        assert (msg instanceof JdbcResponse);
        JdbcResponse res = (JdbcResponse)msg;
        BinaryWriterExImpl writer = this.createWriter(1024);
        res.writeBinary(writer, this.protoCtx);
        return new ClientMessage(writer.array());
    }

    @Override
    public int decodeCommandType(ClientMessage msg) {
        assert (msg != null);
        return JdbcRequest.readType(msg.payload());
    }

    @Override
    public long decodeRequestId(ClientMessage msg) {
        assert (msg != null);
        return JdbcRequest.readRequestId(msg.payload());
    }
}

