/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cluster;

import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.processors.platform.client.ClientBooleanResponse;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cluster.ClientClusterGroupGetNodeIdsResponse;
import org.apache.ignite.internal.processors.platform.client.cluster.ClientClusterGroupProjection;

public class ClientClusterGroupGetNodeIdsRequest
extends ClientRequest {
    private final long topVer;
    private ClientClusterGroupProjection prj;

    public ClientClusterGroupGetNodeIdsRequest(BinaryRawReader reader) {
        super(reader);
        this.topVer = reader.readLong();
        this.prj = ClientClusterGroupProjection.read(reader);
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        IgniteClusterEx cluster = ctx.kernalContext().grid().cluster();
        long curTopVer = cluster.topologyVersion();
        if (curTopVer <= this.topVer) {
            return new ClientBooleanResponse(this.requestId(), false);
        }
        ClusterGroup clusterGrp = this.prj.apply(cluster);
        UUID[] nodeIds = this.getNodeIds(clusterGrp);
        return new ClientClusterGroupGetNodeIdsResponse(this.requestId(), curTopVer, nodeIds);
    }

    private UUID[] getNodeIds(ClusterGroup clusterGrp) {
        Collection<ClusterNode> nodes = clusterGrp.nodes();
        UUID[] nodeIds = new UUID[nodes.size()];
        int i = 0;
        for (ClusterNode node : nodes) {
            nodeIds[i++] = node.id();
        }
        return nodeIds;
    }
}

