/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.checkpoint.cache;

import javax.cache.CacheException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.events.CacheEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMBeanAdapter;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.checkpoint.CheckpointListener;
import org.apache.ignite.spi.checkpoint.CheckpointSpi;
import org.apache.ignite.spi.checkpoint.cache.CacheCheckpointSpiMBean;
import org.jetbrains.annotations.Nullable;

@IgniteSpiMultipleInstancesSupport(value=true)
public class CacheCheckpointSpi
extends IgniteSpiAdapter
implements CheckpointSpi {
    public static final String DFLT_CACHE_NAME = "checkpoints";
    @LoggerResource
    private IgniteLogger log;
    private String cacheName = "checkpoints";
    private CheckpointListener lsnr;
    private GridLocalEventListener evtLsnr;

    @IgniteSpiConfiguration(optional=true)
    public CacheCheckpointSpi setCacheName(String cacheName) {
        this.cacheName = cacheName;
        return this;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        this.assertParameter(!F.isEmpty(this.cacheName), "!F.isEmpty(cacheName)");
        this.startStopwatch();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.configInfo("cacheName", this.cacheName));
        }
        this.registerMBean(igniteInstanceName, new CacheCheckpointSpiMBeanImpl(this), CacheCheckpointSpiMBean.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    protected void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        this.evtLsnr = new GridLocalEventListener(){

            @Override
            public void onEvent(Event evt) {
                CheckpointListener tmp;
                assert (evt != null);
                assert (evt.type() == 65 || evt.type() == 70);
                CacheEvent e = (CacheEvent)evt;
                if (!F.eq(e.cacheName(), CacheCheckpointSpi.this.cacheName)) {
                    return;
                }
                if (e.oldValue() != null && (tmp = CacheCheckpointSpi.this.lsnr) != null) {
                    tmp.onCheckpointRemoved((String)e.key());
                }
            }
        };
        this.getSpiContext().addLocalEventListener(this.evtLsnr, 65, 70);
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.unregisterMBean();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    @Override
    protected void onContextDestroyed0() {
        IgniteSpiContext ctx;
        if (this.evtLsnr != null && (ctx = this.getSpiContext()) != null) {
            ctx.removeLocalEventListener(this.evtLsnr);
        }
    }

    @Override
    @Nullable
    public byte[] loadCheckpoint(String key) throws IgniteSpiException {
        assert (key != null);
        try {
            return (byte[])this.getSpiContext().get(this.cacheName, key);
        }
        catch (CacheException e) {
            throw new IgniteSpiException("Failed to load checkpoint data [key=" + key + "]", e);
        }
    }

    @Override
    public boolean saveCheckpoint(String key, byte[] state, long timeout, boolean overwrite) throws IgniteSpiException {
        assert (key != null);
        assert (timeout >= 0L);
        try {
            if (overwrite) {
                this.getSpiContext().put(this.cacheName, key, state, timeout);
                return true;
            }
            return this.getSpiContext().putIfAbsent(this.cacheName, key, state, timeout) == null;
        }
        catch (CacheException e) {
            throw new IgniteSpiException("Failed to save checkpoint data [key=" + key + ", stateSize=" + state.length + ", timeout=" + timeout + "]", e);
        }
    }

    @Override
    public boolean removeCheckpoint(String key) {
        assert (key != null);
        try {
            return this.getSpiContext().remove(this.cacheName, key) != null;
        }
        catch (CacheException e) {
            U.error(this.log, "Failed to remove checkpoint data [key=" + key + "]", e);
            return false;
        }
    }

    @Override
    public void setCheckpointListener(CheckpointListener lsnr) {
        this.lsnr = lsnr;
    }

    @Override
    public CacheCheckpointSpi setName(String name) {
        super.setName(name);
        return this;
    }

    public String toString() {
        return S.toString(CacheCheckpointSpi.class, this);
    }

    private class CacheCheckpointSpiMBeanImpl
    extends IgniteSpiMBeanAdapter
    implements CacheCheckpointSpiMBean {
        CacheCheckpointSpiMBeanImpl(IgniteSpiAdapter spiAdapter) {
            super(spiAdapter);
        }

        @Override
        public String getCacheName() {
            return CacheCheckpointSpi.this.getCacheName();
        }
    }
}

