/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.expression.unary;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.udf.core.executor.UDTFExecutor;
import org.apache.iotdb.db.query.udf.core.layer.IntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.LayerMemoryAssigner;
import org.apache.iotdb.db.query.udf.core.layer.RawQueryInputLayer;
import org.apache.iotdb.db.query.udf.core.layer.SingleInputColumnMultiReferenceIntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.SingleInputColumnSingleReferenceIntermediateLayer;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class TimeSeriesOperand
extends Expression {
    protected PartialPath path;

    public TimeSeriesOperand(PartialPath path) {
        this.path = path;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    @Override
    public boolean isConstantOperandInternal() {
        return false;
    }

    @Override
    public List<Expression> getExpressions() {
        return Collections.emptyList();
    }

    @Override
    public void concat(List<PartialPath> prefixPaths, List<Expression> resultExpressions) {
        for (PartialPath prefixPath : prefixPaths) {
            resultExpressions.add(new TimeSeriesOperand(prefixPath.concatPath(this.path)));
        }
    }

    @Override
    public void removeWildcards(WildcardsRemover wildcardsRemover, List<Expression> resultExpressions) throws LogicalOptimizeException {
        for (PartialPath partialPath : wildcardsRemover.removeWildcardFrom(this.path)) {
            resultExpressions.add(new TimeSeriesOperand(partialPath));
        }
    }

    @Override
    public void collectPaths(Set<PartialPath> pathSet) {
        pathSet.add(this.path);
    }

    @Override
    public void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    public IntermediateLayer constructIntermediateLayer(long queryId, UDTFPlan udtfPlan, RawQueryInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, Map<Expression, TSDataType> expressionDataTypeMap, LayerMemoryAssigner memoryAssigner) throws QueryProcessException {
        if (!expressionIntermediateLayerMap.containsKey(this)) {
            float memoryBudgetInMB = memoryAssigner.assign();
            LayerPointReader parentLayerPointReader = rawTimeSeriesInputLayer.constructPointReader(udtfPlan.getReaderIndex(this.path.getFullPath()));
            expressionDataTypeMap.put(this, parentLayerPointReader.getDataType());
            expressionIntermediateLayerMap.put(this, memoryAssigner.getReference(this) == 1 ? new SingleInputColumnSingleReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, parentLayerPointReader) : new SingleInputColumnMultiReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, parentLayerPointReader));
        }
        return expressionIntermediateLayerMap.get(this);
    }

    @Override
    public String getExpressionStringInternal() {
        return this.path.isMeasurementAliasExists() ? this.path.getFullPathWithAlias() : this.path.getFullPath();
    }
}

