/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression;

import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.expression.BinaryOperator;

public enum ArithmeticOperator implements BinaryOperator
{
    ADD{

        @Override
        public Object apply(Object left, Object right) {
            if (left == null || right == null) {
                return null;
            }
            return ArithmeticOperator.normalizeToDouble(left) + ArithmeticOperator.normalizeToDouble(right);
        }
    }
    ,
    SUBTRACT{

        @Override
        public Object apply(Object left, Object right) {
            if (left == null || right == null) {
                return null;
            }
            return ArithmeticOperator.normalizeToDouble(left) - ArithmeticOperator.normalizeToDouble(right);
        }
    }
    ,
    MULTIPLY{

        @Override
        public Object apply(Object left, Object right) {
            if (left == null || right == null) {
                return null;
            }
            return ((Number)left).intValue() * ((Number)right).intValue();
        }
    }
    ,
    DIVIDE{

        @Override
        public Object apply(Object left, Object right) {
            if (left == null || right == null) {
                return null;
            }
            double r = ArithmeticOperator.normalizeToDouble(right);
            if (r == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            return ArithmeticOperator.normalizeToDouble(left) / r;
        }
    }
    ,
    MODULUS{

        @Override
        public Object apply(Object left, Object right) {
            if (left == null || right == null) {
                return null;
            }
            double r = ArithmeticOperator.normalizeToDouble(right);
            if (r == 0.0) {
                throw new ArithmeticException("Modulus by zero");
            }
            return ArithmeticOperator.normalizeToDouble(left) % r;
        }
    };


    private static double normalizeToDouble(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof String) {
            try {
                return Double.parseDouble((String)obj);
            }
            catch (NumberFormatException e) {
                throw new SemanticException("Cannot parse String to double: " + obj);
            }
        }
        throw new SemanticException("Unsupported type for arithmetic operation: " + obj.getClass());
    }
}

