/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.table;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TsTableInternalRPCUtil {
    private TsTableInternalRPCUtil() {
    }

    public static byte[] serializeBatchTsTable(Map<String, List<TsTable>> tableMap) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((int)tableMap.size(), (OutputStream)outputStream);
            for (Map.Entry<String, List<TsTable>> entry : tableMap.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((int)entry.getValue().size(), (OutputStream)outputStream);
                for (TsTable table : entry.getValue()) {
                    table.serialize(outputStream);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public static Map<String, List<TsTable>> deserializeBatchTsTable(InputStream inputStream) {
        HashMap<String, List<TsTable>> result = new HashMap<String, List<TsTable>>();
        try {
            int dbNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
            for (int i = 0; i < dbNum; ++i) {
                String database = ReadWriteIOUtils.readString((InputStream)inputStream);
                int tableNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                ArrayList<TsTable> tableList = new ArrayList<TsTable>(tableNum);
                for (int j = 0; j < tableNum; ++j) {
                    tableList.add(TsTable.deserialize(inputStream));
                }
                result.put(database, tableList);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static byte[] serializeSingleTsTableWithDatabase(String database, TsTable table) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((String)database, (OutputStream)outputStream);
            table.serialize(outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public static Pair<String, TsTable> deserializeSingleTsTableWithDatabase(byte[] bytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            return new Pair((Object)ReadWriteIOUtils.readString((InputStream)inputStream), (Object)TsTable.deserialize(inputStream));
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public static byte[] serializeSingleTsTable(TsTable table) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            table.serialize(outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public static TsTable deserializeSingleTsTable(byte[] bytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            return TsTable.deserialize(inputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public static byte[] serializeTableInitializationInfo(Map<String, List<TsTable>> usingTableMap, Map<String, List<TsTable>> preCreateTableMap) {
        byte[] usingBytes = TsTableInternalRPCUtil.serializeBatchTsTable(usingTableMap);
        byte[] preCreateBytes = TsTableInternalRPCUtil.serializeBatchTsTable(preCreateTableMap);
        byte[] result = new byte[usingBytes.length + preCreateBytes.length];
        System.arraycopy(usingBytes, 0, result, 0, usingBytes.length);
        System.arraycopy(preCreateBytes, 0, result, usingBytes.length, preCreateBytes.length);
        return result;
    }

    public static Pair<Map<String, List<TsTable>>, Map<String, List<TsTable>>> deserializeTableInitializationInfo(byte[] bytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return new Pair(TsTableInternalRPCUtil.deserializeBatchTsTable(inputStream), TsTableInternalRPCUtil.deserializeBatchTsTable(inputStream));
    }

    public static byte[] serializeTableFetchResult(Map<String, Map<String, TsTable>> fetchTableMap) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((int)fetchTableMap.size(), (OutputStream)outputStream);
            for (Map.Entry<String, Map<String, TsTable>> entry : fetchTableMap.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((int)entry.getValue().size(), (OutputStream)outputStream);
                for (Map.Entry<String, TsTable> tableEntry : entry.getValue().entrySet()) {
                    ReadWriteIOUtils.write((String)tableEntry.getKey(), (OutputStream)outputStream);
                    ReadWriteIOUtils.write((Boolean)Objects.nonNull(tableEntry.getValue()), (OutputStream)outputStream);
                    if (!Objects.nonNull(tableEntry.getValue())) continue;
                    tableEntry.getValue().serialize(outputStream);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public static Map<String, Map<String, TsTable>> deserializeTsTableFetchResult(byte[] bytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        HashMap<String, Map<String, TsTable>> result = new HashMap<String, Map<String, TsTable>>();
        try {
            int dbNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
            for (int i = 0; i < dbNum; ++i) {
                String database = ReadWriteIOUtils.readString((InputStream)inputStream);
                int tableNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                HashMap<String, TsTable> tableMap = new HashMap<String, TsTable>(tableNum);
                for (int j = 0; j < tableNum; ++j) {
                    tableMap.put(ReadWriteIOUtils.readString((InputStream)inputStream), ReadWriteIOUtils.readBool((InputStream)inputStream) ? TsTable.deserialize(inputStream) : null);
                }
                result.put(database, tableMap);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

