/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class MonitoredItemModifyResult
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=758");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=760");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=759");
    private final StatusCode statusCode;
    private final Double revisedSamplingInterval;
    private final UInteger revisedQueueSize;
    private final ExtensionObject filterResult;

    public MonitoredItemModifyResult(StatusCode statusCode, Double revisedSamplingInterval, UInteger revisedQueueSize, ExtensionObject filterResult) {
        this.statusCode = statusCode;
        this.revisedSamplingInterval = revisedSamplingInterval;
        this.revisedQueueSize = revisedQueueSize;
        this.filterResult = filterResult;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public Double getRevisedSamplingInterval() {
        return this.revisedSamplingInterval;
    }

    public UInteger getRevisedQueueSize() {
        return this.revisedQueueSize;
    }

    public ExtensionObject getFilterResult() {
        return this.filterResult;
    }

    protected MonitoredItemModifyResult(MonitoredItemModifyResultBuilder<?, ?> b) {
        super(b);
        this.statusCode = ((MonitoredItemModifyResultBuilder)b).statusCode;
        this.revisedSamplingInterval = ((MonitoredItemModifyResultBuilder)b).revisedSamplingInterval;
        this.revisedQueueSize = ((MonitoredItemModifyResultBuilder)b).revisedQueueSize;
        this.filterResult = ((MonitoredItemModifyResultBuilder)b).filterResult;
    }

    public static MonitoredItemModifyResultBuilder<?, ?> builder() {
        return new MonitoredItemModifyResultBuilderImpl();
    }

    public MonitoredItemModifyResultBuilder<?, ?> toBuilder() {
        return new MonitoredItemModifyResultBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitoredItemModifyResult)) {
            return false;
        }
        MonitoredItemModifyResult other = (MonitoredItemModifyResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$revisedSamplingInterval = this.getRevisedSamplingInterval();
        Double other$revisedSamplingInterval = other.getRevisedSamplingInterval();
        if (this$revisedSamplingInterval == null ? other$revisedSamplingInterval != null : !((Object)this$revisedSamplingInterval).equals(other$revisedSamplingInterval)) {
            return false;
        }
        StatusCode this$statusCode = this.getStatusCode();
        StatusCode other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        UInteger this$revisedQueueSize = this.getRevisedQueueSize();
        UInteger other$revisedQueueSize = other.getRevisedQueueSize();
        if (this$revisedQueueSize == null ? other$revisedQueueSize != null : !((Object)this$revisedQueueSize).equals(other$revisedQueueSize)) {
            return false;
        }
        ExtensionObject this$filterResult = this.getFilterResult();
        ExtensionObject other$filterResult = other.getFilterResult();
        return !(this$filterResult == null ? other$filterResult != null : !((Object)this$filterResult).equals(other$filterResult));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MonitoredItemModifyResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $revisedSamplingInterval = this.getRevisedSamplingInterval();
        result = result * 59 + ($revisedSamplingInterval == null ? 43 : ((Object)$revisedSamplingInterval).hashCode());
        StatusCode $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        UInteger $revisedQueueSize = this.getRevisedQueueSize();
        result = result * 59 + ($revisedQueueSize == null ? 43 : ((Object)$revisedQueueSize).hashCode());
        ExtensionObject $filterResult = this.getFilterResult();
        result = result * 59 + ($filterResult == null ? 43 : ((Object)$filterResult).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MonitoredItemModifyResult(statusCode=" + this.getStatusCode() + ", revisedSamplingInterval=" + this.getRevisedSamplingInterval() + ", revisedQueueSize=" + this.getRevisedQueueSize() + ", filterResult=" + this.getFilterResult() + ")";
    }

    private static final class MonitoredItemModifyResultBuilderImpl
    extends MonitoredItemModifyResultBuilder<MonitoredItemModifyResult, MonitoredItemModifyResultBuilderImpl> {
        private MonitoredItemModifyResultBuilderImpl() {
        }

        @Override
        protected MonitoredItemModifyResultBuilderImpl self() {
            return this;
        }

        @Override
        public MonitoredItemModifyResult build() {
            return new MonitoredItemModifyResult(this);
        }
    }

    public static abstract class MonitoredItemModifyResultBuilder<C extends MonitoredItemModifyResult, B extends MonitoredItemModifyResultBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private StatusCode statusCode;
        private Double revisedSamplingInterval;
        private UInteger revisedQueueSize;
        private ExtensionObject filterResult;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MonitoredItemModifyResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(MonitoredItemModifyResult instance, MonitoredItemModifyResultBuilder<?, ?> b) {
            b.statusCode(instance.statusCode);
            b.revisedSamplingInterval(instance.revisedSamplingInterval);
            b.revisedQueueSize(instance.revisedQueueSize);
            b.filterResult(instance.filterResult);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B statusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return (B)this.self();
        }

        public B revisedSamplingInterval(Double revisedSamplingInterval) {
            this.revisedSamplingInterval = revisedSamplingInterval;
            return (B)this.self();
        }

        public B revisedQueueSize(UInteger revisedQueueSize) {
            this.revisedQueueSize = revisedQueueSize;
            return (B)this.self();
        }

        public B filterResult(ExtensionObject filterResult) {
            this.filterResult = filterResult;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MonitoredItemModifyResult.MonitoredItemModifyResultBuilder(super=" + super.toString() + ", statusCode=" + this.statusCode + ", revisedSamplingInterval=" + this.revisedSamplingInterval + ", revisedQueueSize=" + this.revisedQueueSize + ", filterResult=" + this.filterResult + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<MonitoredItemModifyResult> {
        @Override
        public Class<MonitoredItemModifyResult> getType() {
            return MonitoredItemModifyResult.class;
        }

        @Override
        public MonitoredItemModifyResult decode(SerializationContext context, UaDecoder decoder) {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            Double revisedSamplingInterval = decoder.readDouble("RevisedSamplingInterval");
            UInteger revisedQueueSize = decoder.readUInt32("RevisedQueueSize");
            ExtensionObject filterResult = decoder.readExtensionObject("FilterResult");
            return new MonitoredItemModifyResult(statusCode, revisedSamplingInterval, revisedQueueSize, filterResult);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, MonitoredItemModifyResult value) {
            encoder.writeStatusCode("StatusCode", value.getStatusCode());
            encoder.writeDouble("RevisedSamplingInterval", value.getRevisedSamplingInterval());
            encoder.writeUInt32("RevisedQueueSize", value.getRevisedQueueSize());
            encoder.writeExtensionObject("FilterResult", value.getFilterResult());
        }
    }
}

