/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferResult;

public class TransferSubscriptionsResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=842");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=844");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=843");
    private final ResponseHeader responseHeader;
    private final TransferResult[] results;
    private final DiagnosticInfo[] diagnosticInfos;

    public TransferSubscriptionsResponse(ResponseHeader responseHeader, TransferResult[] results, DiagnosticInfo[] diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.results = results;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public TransferResult[] getResults() {
        return this.results;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    protected TransferSubscriptionsResponse(TransferSubscriptionsResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((TransferSubscriptionsResponseBuilder)b).responseHeader;
        this.results = ((TransferSubscriptionsResponseBuilder)b).results;
        this.diagnosticInfos = ((TransferSubscriptionsResponseBuilder)b).diagnosticInfos;
    }

    public static TransferSubscriptionsResponseBuilder<?, ?> builder() {
        return new TransferSubscriptionsResponseBuilderImpl();
    }

    public TransferSubscriptionsResponseBuilder<?, ?> toBuilder() {
        return new TransferSubscriptionsResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferSubscriptionsResponse)) {
            return false;
        }
        TransferSubscriptionsResponse other = (TransferSubscriptionsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getResults(), other.getResults())) {
            return false;
        }
        return Arrays.deepEquals(this.getDiagnosticInfos(), other.getDiagnosticInfos());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransferSubscriptionsResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getResults());
        result = result * 59 + Arrays.deepHashCode(this.getDiagnosticInfos());
        return result;
    }

    @Override
    public String toString() {
        return "TransferSubscriptionsResponse(responseHeader=" + this.getResponseHeader() + ", results=" + Arrays.deepToString(this.getResults()) + ", diagnosticInfos=" + Arrays.deepToString(this.getDiagnosticInfos()) + ")";
    }

    private static final class TransferSubscriptionsResponseBuilderImpl
    extends TransferSubscriptionsResponseBuilder<TransferSubscriptionsResponse, TransferSubscriptionsResponseBuilderImpl> {
        private TransferSubscriptionsResponseBuilderImpl() {
        }

        @Override
        protected TransferSubscriptionsResponseBuilderImpl self() {
            return this;
        }

        @Override
        public TransferSubscriptionsResponse build() {
            return new TransferSubscriptionsResponse(this);
        }
    }

    public static abstract class TransferSubscriptionsResponseBuilder<C extends TransferSubscriptionsResponse, B extends TransferSubscriptionsResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private TransferResult[] results;
        private DiagnosticInfo[] diagnosticInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TransferSubscriptionsResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(TransferSubscriptionsResponse instance, TransferSubscriptionsResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.results(instance.results);
            b.diagnosticInfos(instance.diagnosticInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B results(TransferResult[] results) {
            this.results = results;
            return (B)this.self();
        }

        public B diagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
            this.diagnosticInfos = diagnosticInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TransferSubscriptionsResponse.TransferSubscriptionsResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", results=" + Arrays.deepToString(this.results) + ", diagnosticInfos=" + Arrays.deepToString(this.diagnosticInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<TransferSubscriptionsResponse> {
        @Override
        public Class<TransferSubscriptionsResponse> getType() {
            return TransferSubscriptionsResponse.class;
        }

        @Override
        public TransferSubscriptionsResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            TransferResult[] results = (TransferResult[])decoder.readStructArray("Results", TransferResult.TYPE_ID);
            DiagnosticInfo[] diagnosticInfos = decoder.readDiagnosticInfoArray("DiagnosticInfos");
            return new TransferSubscriptionsResponse(responseHeader, results, diagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, TransferSubscriptionsResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeStructArray("Results", (Object[])value.getResults(), TransferResult.TYPE_ID);
            encoder.writeDiagnosticInfoArray("DiagnosticInfos", value.getDiagnosticInfos());
        }
    }
}

