/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.logdispatcher;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.consensus.iot.logdispatcher.LogDispatcher;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class LogDispatcherThreadMetrics
implements IMetricSet {
    private final LogDispatcher.LogDispatcherThread logDispatcherThread;
    private final String peerGroupId;
    private Timer constructBatchTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer syncLogTimePerRequestTimer = DoNothingMetricManager.DO_NOTHING_TIMER;

    public LogDispatcherThreadMetrics(LogDispatcher.LogDispatcherThread logDispatcherThread) {
        this.logDispatcherThread = logDispatcherThread;
        this.peerGroupId = logDispatcherThread.getPeer().getGroupId().toString();
    }

    public void recordConstructBatchTime(long costTimeInNanos) {
        this.constructBatchTimer.updateNanos(costTimeInNanos);
    }

    public void recordSyncLogTimePerRequest(long costTimeInNanos) {
        this.syncLogTimePerRequestTimer.updateNanos(costTimeInNanos);
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindAutoGauge(metricService);
        this.bindStageTimer(metricService);
    }

    private void bindAutoGauge(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.logDispatcherThread, LogDispatcher.LogDispatcherThread::getCurrentSyncIndex, new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "currentSyncIndex"});
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.logDispatcherThread, x -> x.getSyncStatus().getPendingBatches().size(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "pipelineNum"});
        metricService.createAutoGauge(Metric.IOT_CONSENSUS.toString(), MetricLevel.IMPORTANT, (Object)this.logDispatcherThread, x -> x.getPendingEntriesSize() + x.getBufferRequestSize(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "cachedRequestInMemoryQueue"});
    }

    private void bindStageTimer(AbstractMetricService metricService) {
        this.constructBatchTimer = metricService.getOrCreateTimer(Metric.IOT_SEND_LOG.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.STAGE.toString(), "constructBatch", Tag.REGION.toString(), this.peerGroupId});
        this.syncLogTimePerRequestTimer = metricService.getOrCreateTimer(Metric.IOT_SEND_LOG.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.STAGE.toString(), "syncLogTimePerRequest", Tag.REGION.toString(), this.peerGroupId});
    }

    private void unbindStageTimer(AbstractMetricService metricService) {
        metricService.remove(MetricType.TIMER, Metric.IOT_SEND_LOG.toString(), new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.STAGE.toString(), "constructBatch", Tag.REGION.toString(), this.peerGroupId});
        metricService.remove(MetricType.TIMER, Metric.IOT_SEND_LOG.toString(), new String[]{Tag.NAME.toString(), Metric.IOT_CONSENSUS.toString(), Tag.STAGE.toString(), "syncLogTimePerRequest", Tag.REGION.toString(), this.peerGroupId});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindAutoGauge(metricService);
        this.unbindStageTimer(metricService);
    }

    private void unbindAutoGauge(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "currentSyncIndex"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "pipelineNum"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.IOT_CONSENSUS.toString(), new String[]{Tag.NAME.toString(), this.formatName(), Tag.REGION.toString(), this.logDispatcherThread.getPeer().getGroupId().toString(), Tag.TYPE.toString(), "cachedRequestInMemoryQueue"});
    }

    private String formatName() {
        return String.format("logDispatcher-%s:%s", this.logDispatcherThread.getPeer().getEndpoint().getIp(), this.logDispatcherThread.getPeer().getEndpoint().getPort());
    }
}

