/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class RenameTable
extends Statement {
    private final QualifiedName source;
    private final Identifier target;
    private final boolean tableIfExists;
    private final boolean view;

    public RenameTable(NodeLocation location, QualifiedName source, Identifier target, boolean tableIfExists, boolean view) {
        super(Objects.requireNonNull(location, "location is null"));
        this.source = Objects.requireNonNull(source, "source name is null");
        this.target = Objects.requireNonNull(target, "target name is null");
        this.tableIfExists = tableIfExists;
        this.view = view;
        if (!view) {
            throw new UnsupportedOperationException("The renaming for base table is currently unsupported");
        }
    }

    public QualifiedName getSource() {
        return this.source;
    }

    public Identifier getTarget() {
        return this.target;
    }

    public boolean tableIfExists() {
        return this.tableIfExists;
    }

    public boolean isView() {
        return this.view;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRenameTable(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.target, this.tableIfExists, this.view);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenameTable that = (RenameTable)o;
        return this.tableIfExists == that.tableIfExists && Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target) && this.view == that.view;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("target", (Object)this.target).add("tableIfExists", this.tableIfExists).add("view", this.view).toString();
    }
}

