/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.crud;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadTsFile;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.load.config.LoadTsFileConfigurator;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.annotations.TableModel;

public class LoadTsFileStatement
extends Statement {
    private final File file;
    private int databaseLevel;
    private String database;
    private boolean verifySchema = true;
    private boolean deleteAfterLoad = false;
    private boolean convertOnTypeMismatch = true;
    private long tabletConversionThresholdBytes = -1L;
    private boolean autoCreateDatabase = true;
    private boolean isGeneratedByPipe = false;
    private boolean isAsyncLoad = false;
    private Map<String, String> loadAttributes;
    private List<File> tsFiles;
    private List<Boolean> isTableModel;
    private List<TsFileResource> resources;
    private List<Long> writePointCountList;

    public LoadTsFileStatement(String filePath) throws FileNotFoundException {
        this.file = new File(filePath);
        this.databaseLevel = IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel();
        this.verifySchema = true;
        this.deleteAfterLoad = false;
        this.convertOnTypeMismatch = true;
        this.tabletConversionThresholdBytes = IoTDBDescriptor.getInstance().getConfig().getLoadTabletConversionThresholdBytes();
        this.autoCreateDatabase = IoTDBDescriptor.getInstance().getConfig().isAutoCreateSchemaEnabled();
        this.tsFiles = LoadTsFileStatement.processTsFile(this.file);
        this.resources = new ArrayList<TsFileResource>();
        this.writePointCountList = new ArrayList<Long>();
        this.isTableModel = new ArrayList<Boolean>(Collections.nCopies(this.tsFiles.size(), false));
        this.statementType = StatementType.MULTI_BATCH_INSERT;
    }

    public static List<File> processTsFile(File file) throws FileNotFoundException {
        ArrayList<File> tsFiles = new ArrayList<File>();
        if (file.isFile()) {
            tsFiles.add(file);
        } else {
            if (file.listFiles() == null) {
                throw new FileNotFoundException(String.format("Can not find %s on this machine, notice that load can only handle files on this machine.", file.getPath()));
            }
            tsFiles.addAll(LoadTsFileStatement.findAllTsFile(file));
        }
        LoadTsFileStatement.sortTsFiles(tsFiles);
        return tsFiles;
    }

    protected LoadTsFileStatement() {
        this.file = null;
        this.databaseLevel = IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel();
        this.verifySchema = true;
        this.deleteAfterLoad = false;
        this.convertOnTypeMismatch = true;
        this.tabletConversionThresholdBytes = IoTDBDescriptor.getInstance().getConfig().getLoadTabletConversionThresholdBytes();
        this.autoCreateDatabase = IoTDBDescriptor.getInstance().getConfig().isAutoCreateSchemaEnabled();
        this.tsFiles = new ArrayList<File>();
        this.resources = new ArrayList<TsFileResource>();
        this.writePointCountList = new ArrayList<Long>();
        this.statementType = StatementType.MULTI_BATCH_INSERT;
    }

    private static List<File> findAllTsFile(File file) {
        File[] files = file.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<File> tsFiles = new ArrayList<File>();
        for (File nowFile : files) {
            if (nowFile.getName().endsWith(".tsfile")) {
                tsFiles.add(nowFile);
                continue;
            }
            if (!nowFile.isDirectory()) continue;
            tsFiles.addAll(LoadTsFileStatement.findAllTsFile(nowFile));
        }
        return tsFiles;
    }

    private static void sortTsFiles(List<File> files) {
        files.sort((o1, o2) -> {
            String file1Name = o1.getName();
            String file2Name = o2.getName();
            try {
                return TsFileResource.checkAndCompareFileName(file1Name, file2Name);
            }
            catch (IOException e) {
                return file1Name.compareTo(file2Name);
            }
        });
    }

    public void setDatabaseLevel(int databaseLevel) {
        this.databaseLevel = databaseLevel;
    }

    public int getDatabaseLevel() {
        return this.databaseLevel;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setVerifySchema(boolean verifySchema) {
        this.verifySchema = verifySchema;
    }

    public boolean isVerifySchema() {
        return this.verifySchema;
    }

    public LoadTsFileStatement setDeleteAfterLoad(boolean deleteAfterLoad) {
        this.deleteAfterLoad = deleteAfterLoad;
        return this;
    }

    public boolean isDeleteAfterLoad() {
        return this.deleteAfterLoad;
    }

    public LoadTsFileStatement setConvertOnTypeMismatch(boolean convertOnTypeMismatch) {
        this.convertOnTypeMismatch = convertOnTypeMismatch;
        return this;
    }

    public boolean isConvertOnTypeMismatch() {
        return this.convertOnTypeMismatch;
    }

    public void setTabletConversionThresholdBytes(long tabletConversionThresholdBytes) {
        this.tabletConversionThresholdBytes = tabletConversionThresholdBytes;
    }

    public long getTabletConversionThresholdBytes() {
        return this.tabletConversionThresholdBytes;
    }

    public void setAutoCreateDatabase(boolean autoCreateDatabase) {
        this.autoCreateDatabase = autoCreateDatabase;
    }

    public boolean isAutoCreateDatabase() {
        return this.autoCreateDatabase;
    }

    public List<Boolean> getIsTableModel() {
        return this.isTableModel;
    }

    public void setIsTableModel(List<Boolean> isTableModel) {
        this.isTableModel = isTableModel;
    }

    public void markIsGeneratedByPipe() {
        this.isGeneratedByPipe = true;
    }

    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    public List<File> getTsFiles() {
        return this.tsFiles;
    }

    public void addTsFileResource(TsFileResource resource) {
        this.resources.add(resource);
    }

    public List<TsFileResource> getResources() {
        return this.resources;
    }

    public void addWritePointCount(long writePointCount) {
        this.writePointCountList.add(writePointCount);
    }

    public long getWritePointCount(int resourceIndex) {
        return this.writePointCountList.get(resourceIndex);
    }

    public void setLoadAttributes(Map<String, String> loadAttributes) {
        this.loadAttributes = loadAttributes;
        this.initAttributes();
    }

    public boolean isAsyncLoad() {
        return this.isAsyncLoad;
    }

    private void initAttributes() {
        this.databaseLevel = LoadTsFileConfigurator.parseOrGetDefaultDatabaseLevel(this.loadAttributes);
        this.database = LoadTsFileConfigurator.parseDatabaseName(this.loadAttributes);
        this.deleteAfterLoad = LoadTsFileConfigurator.parseOrGetDefaultOnSuccess(this.loadAttributes);
        this.convertOnTypeMismatch = LoadTsFileConfigurator.parseOrGetDefaultConvertOnTypeMismatch(this.loadAttributes);
        this.tabletConversionThresholdBytes = LoadTsFileConfigurator.parseOrGetDefaultTabletConversionThresholdBytes(this.loadAttributes);
        this.verifySchema = LoadTsFileConfigurator.parseOrGetDefaultVerify(this.loadAttributes);
        this.isAsyncLoad = LoadTsFileConfigurator.parseOrGetDefaultAsyncLoad(this.loadAttributes);
    }

    public boolean reconstructStatementIfMiniFileConverted(List<Boolean> isMiniTsFile) {
        int lastNonMiniTsFileIndex = -1;
        int n = isMiniTsFile.size();
        for (int i = 0; i < n; ++i) {
            if (isMiniTsFile.get(i).booleanValue()) continue;
            ++lastNonMiniTsFileIndex;
            if (this.tsFiles != null) {
                this.tsFiles.set(lastNonMiniTsFileIndex, this.tsFiles.get(i));
            }
            if (this.isTableModel != null) {
                this.isTableModel.set(lastNonMiniTsFileIndex, this.isTableModel.get(i));
            }
            if (this.resources != null) {
                this.resources.set(lastNonMiniTsFileIndex, this.resources.get(i));
            }
            if (this.writePointCountList == null) continue;
            this.writePointCountList.set(lastNonMiniTsFileIndex, this.writePointCountList.get(i));
        }
        this.tsFiles = this.tsFiles != null ? this.tsFiles.subList(0, lastNonMiniTsFileIndex + 1) : Collections.emptyList();
        this.isTableModel = this.isTableModel != null ? this.isTableModel.subList(0, lastNonMiniTsFileIndex + 1) : Collections.emptyList();
        this.resources = this.resources != null ? this.resources.subList(0, lastNonMiniTsFileIndex + 1) : Collections.emptyList();
        this.writePointCountList = this.writePointCountList != null ? this.writePointCountList.subList(0, lastNonMiniTsFileIndex + 1) : Collections.emptyList();
        return this.tsFiles == null || this.tsFiles.isEmpty();
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    @Override
    @TableModel
    public org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement toRelationalStatement(MPPQueryContext context) {
        this.loadAttributes = new HashMap<String, String>();
        this.loadAttributes.put("database-level", String.valueOf(this.databaseLevel));
        if (this.database != null) {
            this.loadAttributes.put("database-name", this.database);
        }
        this.loadAttributes.put("on-success", this.deleteAfterLoad ? "delete" : "none");
        this.loadAttributes.put("convert-on-type-mismatch", String.valueOf(this.convertOnTypeMismatch));
        this.loadAttributes.put("tablet-conversion-threshold", String.valueOf(this.tabletConversionThresholdBytes));
        this.loadAttributes.put("async", String.valueOf(this.isAsyncLoad));
        return new LoadTsFile(null, this.file.getAbsolutePath(), this.loadAttributes);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitLoadFile(this, context);
    }

    public String toString() {
        return "LoadTsFileStatement{file=" + this.file + ", delete-after-load=" + this.deleteAfterLoad + ", database-level=" + this.databaseLevel + ", verify-schema=" + this.verifySchema + ", convert-on-type-mismatch=" + this.convertOnTypeMismatch + ", tablet-conversion-threshold=" + this.tabletConversionThresholdBytes + ", async-load=" + this.isAsyncLoad + ", tsFiles size=" + this.tsFiles.size() + '}';
    }
}

