/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction0;
import org.eclipse.collections.api.block.function.primitive.CharToCharFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToCharFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectCharPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.CharBags;
import org.eclipse.collections.api.factory.primitive.CharLists;
import org.eclipse.collections.api.factory.primitive.CharObjectMaps;
import org.eclipse.collections.api.factory.primitive.CharSets;
import org.eclipse.collections.api.factory.primitive.ObjectCharMaps;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.ImmutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.MutableCharObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.ObjectCharMap;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.ObjectCharPair;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedCharCollection;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedObjectCharMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableObjectCharMap;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class ObjectCharHashMapWithHashingStrategy<K>
implements MutableObjectCharMap<K>,
Externalizable {
    public static final char EMPTY_VALUE = '\u0000';
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Object NULL_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectCharHashMapWithHashingStrategy.NULL_KEY";
        }
    };
    private static final Object REMOVED_KEY = new Object(){

        public boolean equals(Object obj) {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public int hashCode() {
            throw new RuntimeException("Possible corruption through unsynchronized concurrent modification.");
        }

        public String toString() {
            return "ObjectCharHashMapWithHashingStrategy.REMOVED_KEY";
        }
    };
    private Object[] keys;
    private char[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private HashingStrategy<? super K> hashingStrategy;

    @Deprecated
    public ObjectCharHashMapWithHashingStrategy() {
    }

    public ObjectCharHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy) {
        this.hashingStrategy = hashingStrategy;
        this.allocateTable(16);
    }

    public ObjectCharHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        this.hashingStrategy = hashingStrategy;
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity << 1));
        this.allocateTable(capacity);
    }

    public ObjectCharHashMapWithHashingStrategy(HashingStrategy<? super K> hashingStrategy, ObjectCharMap<? extends K> map) {
        this(hashingStrategy, Math.max(map.size(), 8));
        this.putAll(map);
    }

    public static <K> ObjectCharHashMapWithHashingStrategy<K> newMap(HashingStrategy<? super K> hashingStrategy) {
        return new ObjectCharHashMapWithHashingStrategy<K>(hashingStrategy);
    }

    public static <K> ObjectCharHashMapWithHashingStrategy<K> newMap(HashingStrategy<? super K> hashingStrategy, ObjectCharMap<K> map) {
        return new ObjectCharHashMapWithHashingStrategy<K>(hashingStrategy, map);
    }

    public static <K> ObjectCharHashMapWithHashingStrategy<K> newMap(ObjectCharHashMapWithHashingStrategy<K> map) {
        return new ObjectCharHashMapWithHashingStrategy<K>(map.hashingStrategy, map);
    }

    public static <K> ObjectCharHashMapWithHashingStrategy<K> newMapWithInitialCapacity(HashingStrategy<? super K> hashingStrategy, int initialCapacity) {
        return new ObjectCharHashMapWithHashingStrategy<K>(hashingStrategy, initialCapacity);
    }

    public static <K> ObjectCharHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, char value1) {
        return new ObjectCharHashMapWithHashingStrategy<K>(hashingStrategy, 1).withKeyValue((Object)key1, value1);
    }

    public static <K> ObjectCharHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, char value1, K key2, char value2) {
        return new ObjectCharHashMapWithHashingStrategy<K>(hashingStrategy, 2).withKeysValues(key1, value1, key2, value2);
    }

    public static <K> ObjectCharHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, char value1, K key2, char value2, K key3, char value3) {
        return new ObjectCharHashMapWithHashingStrategy<K>(hashingStrategy, 3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static <K> ObjectCharHashMapWithHashingStrategy<K> newWithKeysValues(HashingStrategy<? super K> hashingStrategy, K key1, char value1, K key2, char value2, K key3, char value3, K key4, char value4) {
        return new ObjectCharHashMapWithHashingStrategy<K>(hashingStrategy, 4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObjectCharMap)) {
            return false;
        }
        ObjectCharMap other = (ObjectCharMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || other.containsKey(this.toNonSentinel(this.keys[i])) && this.values[i] == other.getOrThrow(this.toNonSentinel(this.keys[i]))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result += this.hashingStrategy.computeHashCode(this.toNonSentinel(this.keys[i])) ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        for (int i = 0; i < this.keys.length; ++i) {
            Object key = this.keys[i];
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(this.toNonSentinel(key)).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    @Override
    public int size() {
        return this.occupiedWithData;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean notEmpty() {
        return this.size() != 0;
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            for (int i = 0; i < this.keys.length; ++i) {
                Object key = this.keys[i];
                if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(String.valueOf(this.values[i])));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MutableCharIterator charIterator() {
        return new InternalCharIterator();
    }

    @Override
    public char[] toArray() {
        char[] result = new char[this.size()];
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result[index] = this.values[i];
            ++index;
        }
        return result;
    }

    @Override
    public char[] toArray(char[] target) {
        if (target.length < this.size()) {
            target = new char[this.size()];
        }
        int index = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            target[index] = this.values[i];
            ++index;
        }
        return target;
    }

    @Override
    public boolean contains(char value) {
        return this.containsValue(value);
    }

    @Override
    public boolean containsAll(char ... source) {
        for (char item : source) {
            if (this.containsValue(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return this.containsAll(source.toArray());
    }

    @Override
    public void clear() {
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, null);
        Arrays.fill(this.values, '\u0000');
    }

    @Override
    public void put(K key, char value) {
        int index = this.probe(key);
        if (ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    @Override
    public void putAll(ObjectCharMap<? extends K> map) {
        map.forEachKeyValue(this::put);
    }

    @Override
    public void updateValues(ObjectCharToCharFunction<? super K> function) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    @Override
    public void removeKey(K key) {
        int index = this.probe(key);
        this.removeKeyAtIndex(key, index);
    }

    public void removeKeyAtIndex(K key, int index) {
        if (ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            this.values[index] = '\u0000';
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
        }
    }

    @Override
    public void remove(Object key) {
        this.removeKey(key);
    }

    @Override
    public char removeKeyIfAbsent(K key, char value) {
        int index = this.probe(key);
        if (ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.keys[index] = REMOVED_KEY;
            char oldValue = this.values[index];
            this.values[index] = '\u0000';
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            return oldValue;
        }
        return value;
    }

    @Override
    public char getIfAbsentPut(K key, char value) {
        int index = this.probe(key);
        if (ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public char getAndPut(K key, char putValue, char defaultValue) {
        int index = this.probe(key);
        if (ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            char existingValue = this.values[index];
            this.values[index] = putValue;
            return existingValue;
        }
        this.addKeyValueAtIndex(key, putValue, index);
        return defaultValue;
    }

    @Override
    public char getIfAbsentPut(K key, CharFunction0 function) {
        int index = this.probe(key);
        if (ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        char value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public <P> char getIfAbsentPutWith(K key, CharFunction<? super P> function, P parameter) {
        int index = this.probe(key);
        if (ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        char value = function.charValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public char getIfAbsentPutWithKey(K key, CharFunction<? super K> function) {
        int index = this.probe(key);
        if (ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        char value = function.charValueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    @Override
    public char updateValue(K key, char initialValueIfAbsent, CharToCharFunction function) {
        int index = this.probe(key);
        if (ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        char value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(K key, char value, int index) {
        if (this.keys[index] == REMOVED_KEY) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = ObjectCharHashMapWithHashingStrategy.toSentinelIfNull(key);
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    @Override
    public char addToValue(K key, char toBeAdded) {
        int index = this.probe(key);
        if (ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            int n = index;
            this.values[n] = (char)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    @Override
    public ObjectCharHashMapWithHashingStrategy<K> withKeyValue(K key1, char value1) {
        this.put(key1, value1);
        return this;
    }

    public ObjectCharHashMapWithHashingStrategy<K> withKeysValues(K key1, char value1, K key2, char value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public ObjectCharHashMapWithHashingStrategy<K> withKeysValues(K key1, char value1, K key2, char value2, K key3, char value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public ObjectCharHashMapWithHashingStrategy<K> withKeysValues(K key1, char value1, K key2, char value2, K key3, char value3, K key4, char value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    @Override
    public ObjectCharHashMapWithHashingStrategy<K> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    @Override
    public ObjectCharHashMapWithHashingStrategy<K> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    @Override
    public MutableObjectCharMap<K> asUnmodifiable() {
        return new UnmodifiableObjectCharMap(this);
    }

    @Override
    public MutableObjectCharMap<K> asSynchronized() {
        return new SynchronizedObjectCharMap(this);
    }

    @Override
    public ImmutableObjectCharMap<K> toImmutable() {
        return ObjectCharMaps.immutable.withAll(this);
    }

    @Override
    public char get(Object key) {
        return this.getIfAbsent(key, '\u0000');
    }

    @Override
    public char getOrThrow(Object key) {
        int index = this.probe(key);
        if (ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public char getIfAbsent(Object key, char ifAbsent) {
        int index = this.probe(key);
        if (ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key)) {
            return this.values[index];
        }
        return ifAbsent;
    }

    @Override
    public boolean containsKey(Object key) {
        int index = this.probe(key);
        return ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[index]) && this.nullSafeEquals(this.toNonSentinel(this.keys[index]), key);
    }

    @Override
    public boolean containsValue(char value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void each(CharProcedure procedure) {
        this.forEachValue(procedure);
    }

    @Override
    public void forEachValue(CharProcedure procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]));
        }
    }

    @Override
    public void forEachKeyValue(ObjectCharProcedure<? super K> procedure) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
    }

    @Override
    public ObjectCharHashMapWithHashingStrategy<K> select(ObjectCharPredicate<? super K> predicate) {
        ObjectCharHashMapWithHashingStrategy<K> result = ObjectCharHashMapWithHashingStrategy.newMap(this.hashingStrategy);
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    @Override
    public ObjectCharHashMapWithHashingStrategy<K> reject(ObjectCharPredicate<? super K> predicate) {
        ObjectCharHashMapWithHashingStrategy<K> result = ObjectCharHashMapWithHashingStrategy.newMap(this.hashingStrategy);
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.toNonSentinel(this.keys[i]), this.values[i])) continue;
            result.put(this.toNonSentinel(this.keys[i]), this.values[i]);
        }
        return result;
    }

    @Override
    public MutableCharCollection select(CharPredicate predicate) {
        MutableCharList result = CharLists.mutable.empty();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableCharCollection reject(CharPredicate predicate) {
        MutableCharList result = CharLists.mutable.empty();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return ifNone;
    }

    @Override
    public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        MutableList result = Lists.mutable.withInitialCapacity(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(function.valueOf(this.values[i]));
        }
        return result;
    }

    @Override
    public int count(CharPredicate predicate) {
        int count = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectCharToObjectFunction<? super V, ? extends V> function) {
        V result = injectedValue;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public RichIterable<CharIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList<CharIterable> result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableCharIterator iterator = this.charIterator();
            while (iterator.hasNext()) {
                MutableCharBag batch = CharBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add(batch);
            }
        }
        return result;
    }

    @Override
    public long sum() {
        long result = 0L;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    @Override
    public char max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        char max = '\u0000';
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.values[i]) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public char min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        char min2 = '\u0000';
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min2) continue;
            min2 = this.values[i];
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        char max = '\u0000';
        boolean isMaxSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMaxSet && max >= this.values[i]) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return max;
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        char min2 = '\u0000';
        boolean isMinSet = false;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i]) || isMinSet && this.values[i] >= min2) continue;
            min2 = this.values[i];
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        char[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            char first = sortedArray[middleIndex];
            char second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public MutableCharList toList() {
        MutableCharList result = CharLists.mutable.withInitialCapacity(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableCharSet toSet() {
        MutableCharSet result = CharSets.mutable.empty();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public MutableCharBag toBag() {
        MutableCharBag result = CharBags.mutable.empty();
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    @Override
    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter(this);
    }

    @Override
    public char[] toSortedArray() {
        char[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableCharList toSortedList() {
        return this.toList().sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.hashingStrategy);
        out.writeInt(this.size());
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.keys[i])) continue;
            out.writeObject(this.toNonSentinel(this.keys[i]));
            out.writeChar(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.hashingStrategy = (HashingStrategy)in.readObject();
        int size = in.readInt();
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(size << 1));
        this.allocateTable(capacity);
        for (int i = 0; i < size; ++i) {
            this.put(in.readObject(), in.readChar());
        }
    }

    @Override
    public LazyIterable<K> keysView() {
        return new KeysView();
    }

    @Override
    public RichIterable<ObjectCharPair<K>> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public MutableCharObjectMap<K> flipUniqueValues() {
        MutableCharObjectMap result = CharObjectMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        Object[] old = this.keys;
        char[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(old[i])) continue;
            this.put(this.toNonSentinel(old[i]), oldValues[i]);
        }
    }

    int probe(Object element) {
        int index = this.spread(element);
        int removedIndex = -1;
        if (ObjectCharHashMapWithHashingStrategy.isRemovedKey(this.keys[index])) {
            removedIndex = index;
        } else if (this.keys[index] == null || this.nullSafeEquals(this.toNonSentinel(this.keys[index]), element)) {
            return index;
        }
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (ObjectCharHashMapWithHashingStrategy.isRemovedKey(this.keys[nextIndex &= this.keys.length - 1])) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.nullSafeEquals(this.toNonSentinel(this.keys[nextIndex]), element)) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == null) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(Object element) {
        K nonSentinelKey = this.toNonSentinel(element);
        int h2 = nonSentinelKey == null ? 0 : this.hashingStrategy.computeHashCode(nonSentinelKey);
        h2 ^= h2 >>> 20 ^ h2 >>> 12;
        h2 ^= h2 >>> 7 ^ h2 >>> 4;
        return h2 & this.keys.length - 1;
    }

    private boolean nullSafeEquals(K value, Object other) {
        return value == null ? other == null : value != NULL_KEY && other != null && this.hashingStrategy.equals(value, this.toNonSentinel(other));
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new Object[sizeToAllocate];
        this.values = new char[sizeToAllocate];
    }

    private static boolean isRemovedKey(Object key) {
        return key == REMOVED_KEY;
    }

    private static <K> boolean isNonSentinel(K key) {
        return key != null && !ObjectCharHashMapWithHashingStrategy.isRemovedKey(key);
    }

    private K toNonSentinel(Object key) {
        return (K)(key == NULL_KEY ? null : key);
    }

    private static Object toSentinelIfNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity >> 1);
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public MutableCharCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ Object[] access$302(ObjectCharHashMapWithHashingStrategy x0, Object[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ char[] access$502(ObjectCharHashMapWithHashingStrategy x0, char[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<ObjectCharPair<K>> {
        private KeyValuesView() {
        }

        @Override
        public void each(Procedure<? super ObjectCharPair<K>> procedure) {
            for (int i = 0; i < ObjectCharHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(ObjectCharHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectCharHashMapWithHashingStrategy.this.toNonSentinel(ObjectCharHashMapWithHashingStrategy.this.keys[i]), ObjectCharHashMapWithHashingStrategy.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super ObjectCharPair<K>> objectIntProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectCharHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(ObjectCharHashMapWithHashingStrategy.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(ObjectCharHashMapWithHashingStrategy.this.toNonSentinel(ObjectCharHashMapWithHashingStrategy.this.keys[i]), ObjectCharHashMapWithHashingStrategy.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super ObjectCharPair<K>, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectCharHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(ObjectCharHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(ObjectCharHashMapWithHashingStrategy.this.toNonSentinel(ObjectCharHashMapWithHashingStrategy.this.keys[i]), ObjectCharHashMapWithHashingStrategy.this.values[i]), parameter);
            }
        }

        @Override
        public Iterator<ObjectCharPair<K>> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<ObjectCharPair<K>> {
            private int count;
            private int position;

            @Override
            public ObjectCharPair<K> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectCharHashMapWithHashingStrategy.this.keys;
                while (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                ObjectCharPair<Object> result = PrimitiveTuples.pair(ObjectCharHashMapWithHashingStrategy.this.toNonSentinel(ObjectCharHashMapWithHashingStrategy.this.keys[this.position]), ObjectCharHashMapWithHashingStrategy.this.values[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectCharHashMapWithHashingStrategy.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyIterable<K> {
        private KeysView() {
        }

        @Override
        public void each(Procedure<? super K> procedure) {
            ObjectCharHashMapWithHashingStrategy.this.forEachKey(procedure);
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super K> objectCharProcedure) {
            int index = 0;
            for (int i = 0; i < ObjectCharHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(ObjectCharHashMapWithHashingStrategy.this.keys[i])) continue;
                objectCharProcedure.value(ObjectCharHashMapWithHashingStrategy.this.toNonSentinel(ObjectCharHashMapWithHashingStrategy.this.keys[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super K, ? super P> procedure, P parameter) {
            for (int i = 0; i < ObjectCharHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(ObjectCharHashMapWithHashingStrategy.this.keys[i])) continue;
                procedure.value(ObjectCharHashMapWithHashingStrategy.this.toNonSentinel(ObjectCharHashMapWithHashingStrategy.this.keys[i]), parameter);
            }
        }

        @Override
        public Iterator<K> iterator() {
            return new InternalKeysViewIterator();
        }

        public class InternalKeysViewIterator
        implements Iterator<K> {
            private int count;
            private int position;

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] keys = ObjectCharHashMapWithHashingStrategy.this.keys;
                while (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                Object result = ObjectCharHashMapWithHashingStrategy.this.toNonSentinel(ObjectCharHashMapWithHashingStrategy.this.keys[this.position]);
                ++this.count;
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != ObjectCharHashMapWithHashingStrategy.this.size();
            }
        }
    }

    private class ValuesCollection
    implements MutableCharCollection {
        private ValuesCollection() {
        }

        @Override
        public int size() {
            return ObjectCharHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectCharHashMapWithHashingStrategy.this.isEmpty();
        }

        @Override
        public boolean notEmpty() {
            return ObjectCharHashMapWithHashingStrategy.this.notEmpty();
        }

        @Override
        public String makeString() {
            return this.makeString(", ");
        }

        @Override
        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        @Override
        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        @Override
        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        @Override
        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        @Override
        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                for (int i = 0; i < ObjectCharHashMapWithHashingStrategy.this.keys.length; ++i) {
                    Object key = ObjectCharHashMapWithHashingStrategy.this.keys[i];
                    if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(ObjectCharHashMapWithHashingStrategy.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean add(char element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(char ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(CharIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(char item) {
            int oldSize = ObjectCharHashMapWithHashingStrategy.this.size();
            for (int i = 0; i < ObjectCharHashMapWithHashingStrategy.this.keys.length; ++i) {
                if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(ObjectCharHashMapWithHashingStrategy.this.keys[i]) || item != ObjectCharHashMapWithHashingStrategy.this.values[i]) continue;
                ObjectCharHashMapWithHashingStrategy.this.removeKey(ObjectCharHashMapWithHashingStrategy.this.keys[i]);
            }
            return oldSize != ObjectCharHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean removeAll(CharIterable source) {
            int oldSize = ObjectCharHashMapWithHashingStrategy.this.size();
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != ObjectCharHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean removeAll(char ... source) {
            int oldSize = ObjectCharHashMapWithHashingStrategy.this.size();
            for (char item : source) {
                this.remove(item);
            }
            return oldSize != ObjectCharHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean retainAll(CharIterable source) {
            int oldSize = ObjectCharHashMapWithHashingStrategy.this.size();
            CharSet sourceSet = source instanceof CharSet ? (CharSet)source : source.toSet();
            MutableObjectCharMap retained = ObjectCharHashMapWithHashingStrategy.this.select((T object, char value) -> sourceSet.contains(value));
            if (((ObjectCharHashMapWithHashingStrategy)retained).size() != oldSize) {
                ObjectCharHashMapWithHashingStrategy.access$302(ObjectCharHashMapWithHashingStrategy.this, ((ObjectCharHashMapWithHashingStrategy)retained).keys);
                ObjectCharHashMapWithHashingStrategy.access$502(ObjectCharHashMapWithHashingStrategy.this, ((ObjectCharHashMapWithHashingStrategy)retained).values);
                ObjectCharHashMapWithHashingStrategy.this.occupiedWithData = ((ObjectCharHashMapWithHashingStrategy)retained).occupiedWithData;
                ObjectCharHashMapWithHashingStrategy.this.occupiedWithSentinels = ((ObjectCharHashMapWithHashingStrategy)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        @Override
        public boolean retainAll(char ... source) {
            return this.retainAll(CharSets.mutable.with(source));
        }

        @Override
        public void clear() {
            ObjectCharHashMapWithHashingStrategy.this.clear();
        }

        @Override
        public MutableCharCollection with(char element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableCharCollection without(char element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableCharCollection withAll(CharIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableCharCollection withoutAll(CharIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public MutableCharCollection asUnmodifiable() {
            return UnmodifiableCharCollection.of(this);
        }

        @Override
        public MutableCharCollection asSynchronized() {
            return SynchronizedCharCollection.of(this);
        }

        @Override
        public ImmutableCharCollection toImmutable() {
            return CharLists.immutable.withAll(this);
        }

        @Override
        public MutableCharIterator charIterator() {
            return ObjectCharHashMapWithHashingStrategy.this.charIterator();
        }

        @Override
        public char[] toArray() {
            return ObjectCharHashMapWithHashingStrategy.this.toArray();
        }

        @Override
        public char[] toArray(char[] target) {
            return ObjectCharHashMapWithHashingStrategy.this.toArray(target);
        }

        @Override
        public boolean contains(char value) {
            return ObjectCharHashMapWithHashingStrategy.this.containsValue(value);
        }

        @Override
        public boolean containsAll(char ... source) {
            return ObjectCharHashMapWithHashingStrategy.this.containsAll(source);
        }

        @Override
        public boolean containsAll(CharIterable source) {
            return ObjectCharHashMapWithHashingStrategy.this.containsAll(source);
        }

        @Override
        public void forEach(CharProcedure procedure) {
            ObjectCharHashMapWithHashingStrategy.this.forEach(procedure);
        }

        @Override
        public void each(CharProcedure procedure) {
            this.forEach(procedure);
        }

        @Override
        public MutableCharCollection select(CharPredicate predicate) {
            return ObjectCharHashMapWithHashingStrategy.this.select(predicate);
        }

        @Override
        public MutableCharCollection reject(CharPredicate predicate) {
            return ObjectCharHashMapWithHashingStrategy.this.reject(predicate);
        }

        @Override
        public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
            return ObjectCharHashMapWithHashingStrategy.this.collect((CharToObjectFunction)function);
        }

        @Override
        public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
            return ObjectCharHashMapWithHashingStrategy.this.injectInto(injectedValue, function);
        }

        @Override
        public RichIterable<CharIterable> chunk(int size) {
            return ObjectCharHashMapWithHashingStrategy.this.chunk(size);
        }

        @Override
        public char detectIfNone(CharPredicate predicate, char ifNone) {
            return ObjectCharHashMapWithHashingStrategy.this.detectIfNone(predicate, ifNone);
        }

        @Override
        public int count(CharPredicate predicate) {
            return ObjectCharHashMapWithHashingStrategy.this.count(predicate);
        }

        @Override
        public boolean anySatisfy(CharPredicate predicate) {
            return ObjectCharHashMapWithHashingStrategy.this.anySatisfy(predicate);
        }

        @Override
        public boolean allSatisfy(CharPredicate predicate) {
            return ObjectCharHashMapWithHashingStrategy.this.allSatisfy(predicate);
        }

        @Override
        public boolean noneSatisfy(CharPredicate predicate) {
            return ObjectCharHashMapWithHashingStrategy.this.noneSatisfy(predicate);
        }

        @Override
        public MutableCharList toList() {
            return ObjectCharHashMapWithHashingStrategy.this.toList();
        }

        @Override
        public MutableCharSet toSet() {
            return ObjectCharHashMapWithHashingStrategy.this.toSet();
        }

        @Override
        public MutableCharBag toBag() {
            return ObjectCharHashMapWithHashingStrategy.this.toBag();
        }

        @Override
        public LazyCharIterable asLazy() {
            return new LazyCharIterableAdapter(this);
        }

        @Override
        public char[] toSortedArray() {
            return ObjectCharHashMapWithHashingStrategy.this.toSortedArray();
        }

        @Override
        public MutableCharList toSortedList() {
            return ObjectCharHashMapWithHashingStrategy.this.toSortedList();
        }

        @Override
        public long sum() {
            return ObjectCharHashMapWithHashingStrategy.this.sum();
        }

        @Override
        public char max() {
            return ObjectCharHashMapWithHashingStrategy.this.max();
        }

        @Override
        public char maxIfEmpty(char defaultValue) {
            return ObjectCharHashMapWithHashingStrategy.this.maxIfEmpty(defaultValue);
        }

        @Override
        public char min() {
            return ObjectCharHashMapWithHashingStrategy.this.min();
        }

        @Override
        public char minIfEmpty(char defaultValue) {
            return ObjectCharHashMapWithHashingStrategy.this.minIfEmpty(defaultValue);
        }

        @Override
        public double average() {
            return ObjectCharHashMapWithHashingStrategy.this.average();
        }

        @Override
        public double median() {
            return ObjectCharHashMapWithHashingStrategy.this.median();
        }

        @Override
        public MutableCharCollection newEmpty() {
            return CharBags.mutable.empty();
        }
    }

    private class KeySetIterator
    implements Iterator<K> {
        private int count;
        private int position;
        private K currentKey;
        private boolean isCurrentKeySet;

        private KeySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ObjectCharHashMapWithHashingStrategy.this.size();
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Object[] keys = ObjectCharHashMapWithHashingStrategy.this.keys;
            while (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = ObjectCharHashMapWithHashingStrategy.this.keys[this.position];
            this.isCurrentKeySet = true;
            ++this.position;
            return ObjectCharHashMapWithHashingStrategy.this.toNonSentinel(this.currentKey);
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (ObjectCharHashMapWithHashingStrategy.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                ObjectCharHashMapWithHashingStrategy.this.removeKeyAtIndex(ObjectCharHashMapWithHashingStrategy.this.toNonSentinel(this.currentKey), index);
            } else {
                ObjectCharHashMapWithHashingStrategy.this.removeKey(this.currentKey);
            }
        }
    }

    private class KeySet
    implements Set<K> {
        private KeySet() {
        }

        @Override
        public boolean equals(Object obj) {
            Set other;
            if (obj instanceof Set && (other = (Set)obj).size() == this.size()) {
                return this.containsAll(other);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            Object[] table = ObjectCharHashMapWithHashingStrategy.this.keys;
            for (int i = 0; i < table.length; ++i) {
                Object key = table[i];
                if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                Object nonSentinelKey = ObjectCharHashMapWithHashingStrategy.this.toNonSentinel(key);
                hashCode += nonSentinelKey == null ? 0 : ObjectCharHashMapWithHashingStrategy.this.hashingStrategy.computeHashCode(nonSentinelKey);
            }
            return hashCode;
        }

        @Override
        public int size() {
            return ObjectCharHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectCharHashMapWithHashingStrategy.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObjectCharHashMapWithHashingStrategy.this.containsKey(o);
        }

        @Override
        public Object[] toArray() {
            int size = ObjectCharHashMapWithHashingStrategy.this.size();
            Object[] result = new Object[size];
            this.copyKeys(result);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] result) {
            int size = ObjectCharHashMapWithHashingStrategy.this.size();
            if (result.length < size) {
                result = (Object[])Array.newInstance(result.getClass().getComponentType(), size);
            }
            this.copyKeys(result);
            if (size < result.length) {
                result[size] = null;
            }
            return result;
        }

        @Override
        public boolean add(K key) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean remove(Object key) {
            int oldSize = ObjectCharHashMapWithHashingStrategy.this.size();
            ObjectCharHashMapWithHashingStrategy.this.removeKey(key);
            return oldSize != ObjectCharHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object aCollection : collection) {
                if (ObjectCharHashMapWithHashingStrategy.this.containsKey(aCollection)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends K> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            int oldSize = ObjectCharHashMapWithHashingStrategy.this.size();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (collection.contains(next)) continue;
                iterator.remove();
            }
            return oldSize != ObjectCharHashMapWithHashingStrategy.this.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            int oldSize = ObjectCharHashMapWithHashingStrategy.this.size();
            for (Object object : collection) {
                ObjectCharHashMapWithHashingStrategy.this.removeKey(object);
            }
            return oldSize != ObjectCharHashMapWithHashingStrategy.this.size();
        }

        @Override
        public void clear() {
            ObjectCharHashMapWithHashingStrategy.this.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator();
        }

        private void copyKeys(Object[] result) {
            int count = 0;
            for (int i = 0; i < ObjectCharHashMapWithHashingStrategy.this.keys.length; ++i) {
                Object key = ObjectCharHashMapWithHashingStrategy.this.keys[i];
                if (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(key)) continue;
                result[count++] = ObjectCharHashMapWithHashingStrategy.this.keys[i];
            }
        }
    }

    private class InternalCharIterator
    implements MutableCharIterator {
        private int count;
        private int position;

        private InternalCharIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count != ObjectCharHashMapWithHashingStrategy.this.size();
        }

        @Override
        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] keys = ObjectCharHashMapWithHashingStrategy.this.keys;
            while (!ObjectCharHashMapWithHashingStrategy.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            char result = ObjectCharHashMapWithHashingStrategy.this.values[this.position];
            ++this.count;
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (this.position == 0 || !ObjectCharHashMapWithHashingStrategy.isNonSentinel(ObjectCharHashMapWithHashingStrategy.this.keys[this.position - 1])) {
                throw new IllegalStateException();
            }
            ObjectCharHashMapWithHashingStrategy.this.remove(ObjectCharHashMapWithHashingStrategy.this.keys[this.position - 1]);
            --this.count;
        }
    }
}

