/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.util.BundleNames;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.util.ResourceBasedBLOBStore;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BundleWriter {
    private static Logger log = LoggerFactory.getLogger(BundleWriter.class);
    private final BundleBinding binding;
    private final DataOutputStream out;
    private final String[] namespaces = new String[]{"", null, null, null, null, null, null};

    public BundleWriter(BundleBinding binding, OutputStream stream) throws IOException {
        assert (this.namespaces.length == 7);
        this.binding = binding;
        this.out = new DataOutputStream(stream);
        this.out.writeByte(3);
    }

    public void writeBundle(NodePropBundle bundle) throws IOException {
        long size = this.out.size();
        this.writeName(bundle.getNodeTypeName());
        NodeId parentId = bundle.getParentId();
        if (parentId == null) {
            parentId = BundleBinding.NULL_PARENT_ID;
        }
        this.writeNodeId(parentId);
        this.writeVarInt(bundle.getModCount());
        Set<Name> mixins = bundle.getMixinTypeNames();
        Collection<NodePropBundle.PropertyEntry> properties = bundle.getPropertyEntries();
        List<NodePropBundle.ChildNodeEntry> nodes = bundle.getChildNodeEntries();
        Set<NodeId> shared = bundle.getSharedSet();
        int mn = mixins.size();
        int pn = properties.size();
        int nn = nodes.size();
        int sn = shared.size();
        int referenceable = 0;
        if (bundle.isReferenceable()) {
            referenceable = 1;
        }
        this.out.writeByte(Math.min(mn, 1) << 7 | Math.min(pn, 7) << 4 | Math.min(nn, 3) << 2 | Math.min(sn, 1) << 1 | referenceable);
        this.writeVarInt(mn, 1);
        for (Name name : mixins) {
            this.writeName(name);
        }
        this.writeVarInt(pn, 7);
        for (NodePropBundle.PropertyEntry property : properties) {
            this.writeState(property);
        }
        this.writeVarInt(nn, 3);
        for (NodePropBundle.ChildNodeEntry child : nodes) {
            this.writeName(child.getName());
            this.writeNodeId(child.getId());
        }
        this.writeVarInt(sn, 1);
        for (NodeId nodeId : shared) {
            this.writeNodeId(nodeId);
        }
        bundle.setSize((long)this.out.size() - size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void writeState(NodePropBundle.PropertyEntry state) throws IOException {
        this.writeName(state.getName());
        values = state.getValues();
        type = state.getType();
        if (type < 0 || type > 15) {
            throw new IOException("Illegal property type " + type);
        }
        if (state.isMultiValued()) {
            len = values.length + 1;
            if (len < 15) {
                this.out.writeByte(len << 4 | type);
            } else {
                this.out.writeByte(240 | type);
                this.writeVarInt(len - 15);
            }
        } else {
            if (values.length != 1) {
                throw new IOException("Single values property with " + values.length + " values: " + state.getName());
            }
            this.out.writeByte(type);
        }
        this.writeVarInt(state.getModCount());
        block32: for (i = 0; i < values.length; ++i) {
            val = values[i];
            switch (type) {
                case 2: {
                    try {
                        size = val.getLength();
                        if (val.isInDataStore()) {
                            this.out.writeInt(-2);
                            this.writeString(val.toString());
                            continue block32;
                        }
                        if (this.binding.dataStore != null) {
                            this.writeSmallBinary(val, state, i);
                            continue block32;
                        }
                        if (size < 0L) {
                            BundleWriter.log.warn("Blob has negative size. Potential loss of data. id={} idx={}", (Object)state.getId(), (Object)String.valueOf(i));
                            this.out.writeInt(0);
                            values[i] = InternalValue.create(new byte[0]);
                            val.discard();
                            continue block32;
                        }
                        if (size <= this.binding.getMinBlobSize()) ** GOTO lbl66
                        this.out.writeInt(-1);
                        blobId = state.getBlobId(i);
                        if (blobId != null) ** GOTO lbl64
                        blobStore = this.binding.getBlobStore();
                        try {
                            in = val.getStream();
                            try {
                                blobId = blobStore.createId(state.getId(), i);
                                blobStore.put(blobId, in, size);
                                state.setBlobId(blobId, i);
                            }
                            finally {
                                IOUtils.closeQuietly(in);
                            }
                        }
                        catch (Exception e) {
                            msg = "Error while storing blob. id=" + state.getId() + " idx=" + i + " size=" + size;
                            BundleWriter.log.error(msg, e);
                            throw new IOExceptionWithCause(msg, e);
                        }
                        try {
                            values[i] = blobStore instanceof ResourceBasedBLOBStore ? InternalValue.create(((ResourceBasedBLOBStore)blobStore).getResource(blobId)) : InternalValue.create(blobStore.get(blobId));
                        }
                        catch (Exception e) {
                            BundleWriter.log.error("Error while reloading blob. truncating. id=" + state.getId() + " idx=" + i + " size=" + size, e);
                            values[i] = InternalValue.create(new byte[0]);
                        }
                        val.discard();
lbl64:
                        // 2 sources

                        this.writeString(blobId);
                        continue block32;
lbl66:
                        // 1 sources

                        data = this.writeSmallBinary(val, state, i);
                        values[i] = InternalValue.create(data);
                        val.discard();
                        continue block32;
                    }
                    catch (RepositoryException e) {
                        msg = "Error while storing blob. id=" + state.getId() + " idx=" + i + " value=" + val;
                        BundleWriter.log.error(msg, e);
                        throw new IOExceptionWithCause(msg, e);
                    }
                }
                case 4: {
                    try {
                        this.out.writeDouble(val.getDouble());
                        continue block32;
                    }
                    catch (RepositoryException e) {
                        throw BundleWriter.convertToIOException(type, e);
                    }
                }
                case 12: {
                    try {
                        this.writeDecimal(val.getDecimal());
                        continue block32;
                    }
                    catch (RepositoryException e) {
                        throw BundleWriter.convertToIOException(type, e);
                    }
                }
                case 3: {
                    try {
                        this.writeVarLong(val.getLong());
                        continue block32;
                    }
                    catch (RepositoryException e) {
                        throw BundleWriter.convertToIOException(type, e);
                    }
                }
                case 6: {
                    try {
                        this.out.writeBoolean(val.getBoolean());
                        continue block32;
                    }
                    catch (RepositoryException e) {
                        throw BundleWriter.convertToIOException(type, e);
                    }
                }
                case 7: {
                    try {
                        this.writeName(val.getName());
                        continue block32;
                    }
                    catch (RepositoryException e) {
                        throw BundleWriter.convertToIOException(type, e);
                    }
                }
                case 9: 
                case 10: {
                    this.writeNodeId(val.getNodeId());
                    continue block32;
                }
                case 5: {
                    try {
                        this.writeDate(val.getCalendar());
                        continue block32;
                    }
                    catch (RepositoryException e) {
                        throw BundleWriter.convertToIOException(type, e);
                    }
                }
                case 1: 
                case 8: 
                case 11: {
                    this.writeString(val.toString());
                    continue block32;
                }
                default: {
                    throw new IOException("Inknown property type: " + type);
                }
            }
        }
    }

    private static IOException convertToIOException(int propertyType, Exception e) {
        String typeName = PropertyType.nameFromValue(propertyType);
        String message = "Unexpected error for property type " + typeName + " value.";
        log.error(message, e);
        return new IOExceptionWithCause(message, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] writeSmallBinary(InternalValue value, NodePropBundle.PropertyEntry state, int i) throws IOException {
        try {
            int size = (int)value.getLength();
            this.out.writeInt(size);
            byte[] data = new byte[size];
            DataInputStream in = new DataInputStream(value.getStream());
            try {
                in.readFully(data);
            }
            finally {
                IOUtils.closeQuietly(in);
            }
            this.out.write(data, 0, data.length);
            return data;
        }
        catch (Exception e) {
            String msg = "Error while storing blob. id=" + state.getId() + " idx=" + i + " value=" + value;
            log.error(msg, e);
            throw new IOExceptionWithCause(msg, e);
        }
    }

    private void writeNodeId(NodeId id) throws IOException {
        this.out.writeLong(id.getMostSignificantBits());
        this.out.writeLong(id.getLeastSignificantBits());
    }

    private void writeDecimal(BigDecimal decimal) throws IOException {
        if (decimal == null) {
            this.out.writeBoolean(false);
        } else {
            this.out.writeBoolean(true);
            this.writeString(decimal.toString());
        }
    }

    private void writeName(Name name) throws IOException {
        int index = BundleNames.nameToIndex(name);
        if (index != -1) {
            assert (0 <= index && index < 128);
            this.out.writeByte(index);
        } else {
            int ns;
            String uri = name.getNamespaceURI();
            for (ns = 0; ns < this.namespaces.length && this.namespaces[ns] != null && !this.namespaces[ns].equals(uri); ++ns) {
            }
            String local = name.getLocalName();
            if (local.length() == 0) {
                throw new IOException("Attempt to write an empty local name: " + name);
            }
            byte[] bytes = local.getBytes(StandardCharsets.UTF_8);
            int len = Math.min(bytes.length - 1, 15);
            this.out.writeByte(0x80 | ns << 4 | len);
            if (ns == this.namespaces.length || this.namespaces[ns] == null) {
                this.writeString(uri);
                if (ns < this.namespaces.length) {
                    this.namespaces[ns] = uri;
                }
            }
            if (len != 15) {
                this.out.write(bytes);
            } else {
                this.writeBytes(bytes, 16);
            }
        }
    }

    private void writeVarInt(int value) throws IOException {
        int b;
        while ((b = value & 0x7F) != value) {
            this.out.writeByte(b | 0x80);
            value >>>= 7;
        }
        this.out.writeByte(b);
    }

    private void writeVarInt(int value, int base) throws IOException {
        if (value >= base) {
            this.writeVarInt(value - base);
        }
    }

    private void writeVarLong(long value) throws IOException {
        long b;
        value = value < 0L ? (value ^ 0xFFFFFFFFFFFFFFFFL) << 1 | 1L : (value <<= 1);
        while ((b = value & 0x7FL) != value) {
            this.out.writeByte((int)b | 0x80);
            value >>>= 7;
        }
        this.out.writeByte((int)b);
    }

    private void writeDate(Calendar value) throws IOException {
        int y = value.get(1);
        if (value.isSet(0) && value.get(0) == 0) {
            y = 1 - y;
        }
        y -= 2010;
        int d = value.get(6);
        int h = value.get(11);
        int m = value.get(12);
        int s = value.get(13);
        int u = value.get(14);
        int z = value.getTimeZone().getOffset(value.getTimeInMillis()) / 60000;
        int zh = z / 60;
        int zm = z - zh * 60;
        long ts = y << 9 | d & 0x1FF;
        if ((u != 0 || s != 0) && (-512 <= y && y < 512 || zm == 0)) {
            ts <<= 30;
            ts |= (long)(((h * 60 + m) * 60 + s) * 1000 + u & 0x3FFFFFFF);
            ts <<= 2;
            ts |= 3L;
        } else if (m != 0) {
            ts <<= 11;
            ts |= (long)(h * 60 + m & 0x7FF);
            ts <<= 2;
            ts |= 2L;
        } else if (h != 0) {
            ts <<= 5;
            ts |= (long)(h & 0x1F);
            ts <<= 2;
            ts |= 1L;
        } else {
            ts <<= 2;
        }
        if (zm != 0) {
            ts <<= 11;
            this.writeVarLong((ts |= (long)(z & 0x7FF)) << 2 | 3L);
        } else if (zh != 0) {
            ts <<= 5;
            this.writeVarLong((ts |= (long)(zh & 0x1F)) << 2 | 1L);
        } else {
            this.writeVarLong(ts << 1);
        }
    }

    private void writeString(String value) throws IOException {
        this.writeBytes(value.getBytes(StandardCharsets.UTF_8), 0);
    }

    private void writeBytes(byte[] bytes, int base) throws IOException {
        assert (bytes.length >= base);
        this.writeVarInt(bytes.length - base);
        this.out.write(bytes);
    }
}

