/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.constraint;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.commons.query.qom.Operator;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.constraint.DynamicOperand;
import org.apache.jackrabbit.core.query.lucene.constraint.EvaluationContext;
import org.apache.jackrabbit.core.query.lucene.constraint.SelectorBasedConstraint;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.query.qom.SelectorImpl;

public class ComparisonConstraint
extends SelectorBasedConstraint {
    private final DynamicOperand operand1;
    private final Operator operator;
    private final Value operand2;

    public ComparisonConstraint(DynamicOperand operand1, Operator operator2, Value operand2, SelectorImpl selector) {
        super(selector);
        this.operand1 = operand1;
        this.operator = operator2;
        this.operand2 = operand2;
    }

    @Override
    public boolean evaluate(ScoreNode[] row, Name[] selectorNames, EvaluationContext context) throws IOException {
        ScoreNode sn = row[this.getSelectorIndex(selectorNames)];
        if (sn == null) {
            return false;
        }
        try {
            Value[] values;
            for (Value value : values = this.operand1.getValues(sn, context)) {
                if (!this.evaluate(value)) continue;
                return true;
            }
        }
        catch (RepositoryException e) {
            throw Util.createIOException(e);
        }
        return false;
    }

    protected boolean evaluate(Value op1) throws RepositoryException {
        int c = Util.compare(op1, this.operand2);
        if (this.operator == Operator.EQ) {
            return c == 0;
        }
        if (this.operator == Operator.GT) {
            return c > 0;
        }
        if (this.operator == Operator.GE) {
            return c >= 0;
        }
        if (this.operator == Operator.LT) {
            return c < 0;
        }
        if (this.operator == Operator.LE) {
            return c <= 0;
        }
        if (this.operator == Operator.NE) {
            return c != 0;
        }
        throw new UnsupportedOperationException("Unsupported comparison operator: " + (Object)((Object)this.operator));
    }
}

