/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authentication;

import java.security.Principal;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.core.security.authentication.Authentication;
import org.apache.jackrabbit.core.security.authentication.SimpleCredentialsAuthentication;
import org.apache.jackrabbit.core.security.authentication.token.TokenBasedAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLoginModule
extends AbstractLoginModule {
    private static final Logger log = LoggerFactory.getLogger(DefaultLoginModule.class);
    private static final String PARAM_DISABLE_TOKEN_AUTH = "disableTokenAuth";
    private static final String PARAM_TOKEN_EXPIRATION = "tokenExpiration";
    private boolean disableTokenAuth;
    private long tokenExpiration = 0x6DDD00L;
    protected User user;
    private SessionImpl session;
    private UserManager userManager;
    private TokenCredentials tokenCredentials;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean commit() throws LoginException {
        boolean success = super.commit();
        if (!success || this.disableTokenAuth) return success;
        if (TokenBasedAuthentication.doCreateToken(this.credentials)) {
            Session s = null;
            try {
                s = this.session.createSession(this.session.getWorkspace().getName());
                Credentials tc = TokenBasedAuthentication.createToken(this.user, this.credentials, this.tokenExpiration, s);
                if (tc == null) return success;
                this.subject.getPublicCredentials().add(tc);
                return success;
            }
            catch (RepositoryException e) {
                LoginException le = new LoginException("Failed to commit: " + e.getMessage());
                le.initCause(e);
                throw le;
            }
            finally {
                if (s != null) {
                    s.logout();
                }
            }
        } else {
            if (this.tokenCredentials == null) return success;
            this.subject.getPublicCredentials().add(this.tokenCredentials);
        }
        return success;
    }

    @Override
    protected void doInit(CallbackHandler callbackHandler, Session session, Map options) throws LoginException {
        if (!(session instanceof SessionImpl)) {
            throw new LoginException("Unable to initialize LoginModule: SessionImpl expected.");
        }
        try {
            this.session = (SessionImpl)session;
            this.userManager = this.session.getUserManager();
            log.debug("- UserManager -> '" + this.userManager.getClass().getName() + "'");
        }
        catch (RepositoryException e) {
            throw new LoginException("Unable to initialize LoginModule: " + e.getMessage());
        }
        if (options.containsKey(PARAM_DISABLE_TOKEN_AUTH)) {
            this.disableTokenAuth = Boolean.parseBoolean(options.get(PARAM_DISABLE_TOKEN_AUTH).toString());
            log.debug("- Token authentication disabled -> '" + this.disableTokenAuth + "'");
        }
        if (options.containsKey(PARAM_TOKEN_EXPIRATION)) {
            try {
                this.tokenExpiration = Long.parseLong(options.get(PARAM_TOKEN_EXPIRATION).toString());
                log.debug("- Token expiration -> '" + this.tokenExpiration + "'");
            }
            catch (NumberFormatException e) {
                log.warn("Unabled to parse token expiration: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    protected Principal getPrincipal(Credentials credentials) {
        Principal principal = null;
        String userId = this.getUserID(credentials);
        try {
            Authorizable authrz = this.userManager.getAuthorizable(userId);
            if (authrz != null && !authrz.isGroup()) {
                this.user = (User)authrz;
                if (this.user.isDisabled()) {
                    log.debug("User " + userId + " has been disabled.");
                } else {
                    principal = this.user.getPrincipal();
                }
            }
        }
        catch (RepositoryException e) {
            log.warn("Error while retrieving principal. {}", (Object)e.getMessage());
        }
        return principal;
    }

    @Override
    protected boolean supportsCredentials(Credentials creds) {
        if (creds instanceof TokenCredentials) {
            return !this.disableTokenAuth;
        }
        return super.supportsCredentials(creds);
    }

    @Override
    protected String getUserID(Credentials credentials) {
        if (this.user != null) {
            try {
                return this.user.getID();
            }
            catch (RepositoryException e) {
                log.warn("Failed to retrieve userID from user", e);
            }
        }
        if (!this.disableTokenAuth && TokenBasedAuthentication.isTokenBasedLogin(credentials)) {
            this.tokenCredentials = (TokenCredentials)credentials;
            try {
                return TokenBasedAuthentication.getUserId(this.tokenCredentials, this.session);
            }
            catch (RepositoryException e) {
                if (log.isDebugEnabled()) {
                    log.warn("Failed to retrieve UserID from token-based credentials", e);
                } else {
                    log.warn("Failed to retrieve UserID from token-based credentials: {}", (Object)e.toString());
                }
                return null;
            }
        }
        return super.getUserID(credentials);
    }

    @Override
    protected Authentication getAuthentication(Principal principal, Credentials creds) throws RepositoryException {
        Authentication authentication;
        if (!this.disableTokenAuth && this.tokenCredentials != null && (authentication = new TokenBasedAuthentication(this.tokenCredentials.getToken(), this.tokenExpiration, this.session)).canHandle(creds)) {
            return authentication;
        }
        if (this.user != null && (authentication = new SimpleCredentialsAuthentication(this.user)).canHandle(creds)) {
            return authentication;
        }
        return null;
    }

    @Override
    protected boolean impersonate(Principal principal, Credentials credentials) throws RepositoryException, FailedLoginException {
        if (this.user != null) {
            Subject impersSubject = this.getImpersonatorSubject(credentials);
            if (this.user.getImpersonation().allows(impersSubject)) {
                return true;
            }
            throw new FailedLoginException("attempt to impersonate denied for " + principal.getName());
        }
        log.debug("Failed to retrieve user to impersonate for principal name " + principal.getName());
        return false;
    }

    public boolean isDisableTokenAuth() {
        return this.disableTokenAuth;
    }

    public void setDisableTokenAuth(boolean disableTokenAuth) {
        this.disableTokenAuth = disableTokenAuth;
    }

    public long getTokenExpiration() {
        return this.tokenExpiration;
    }

    public void setTokenExpiration(long tokenExpiration) {
        this.tokenExpiration = tokenExpiration;
    }
}

