/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.security.authorization.jackrabbit.acl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.QValueValue;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;
import org.apache.jackrabbit.value.ValueHelper;

class AccessControlEntryImpl
implements JackrabbitAccessControlEntry {
    private final Principal principal;
    private final Privilege[] privileges;
    private final boolean isAllow;
    private final Map<Name, QValue> restrictions;
    private final Map<Name, Iterable<QValue>> mvRestrictions;
    private final NamePathResolver resolver;
    private final QValueFactory qvf;
    private int hashCode = -1;
    private int privsHashCode = -1;

    AccessControlEntryImpl(Principal principal, Privilege[] privileges, boolean isAllow, Map<Name, QValue> restrictions, Map<Name, Iterable<QValue>> mvRestrictions, NamePathResolver resolver, QValueFactory qvf) throws RepositoryException {
        if (principal == null || privileges != null && privileges.length == 0) {
            throw new AccessControlException("An Entry must not have a NULL principal or empty privileges");
        }
        this.checkAbstract(privileges);
        this.principal = principal;
        this.privileges = privileges;
        this.isAllow = isAllow;
        this.resolver = resolver;
        this.qvf = qvf;
        this.restrictions = restrictions == null ? Collections.emptyMap() : restrictions;
        this.mvRestrictions = mvRestrictions == null ? Collections.emptyMap() : mvRestrictions;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public Privilege[] getPrivileges() {
        return this.privileges;
    }

    @Override
    public boolean isAllow() {
        return this.isAllow;
    }

    @Override
    public String[] getRestrictionNames() throws RepositoryException {
        ArrayList<String> restNames = new ArrayList<String>(this.restrictions.size());
        for (Name restName : this.restrictions.keySet()) {
            restNames.add(this.resolver.getJCRName(restName));
        }
        return restNames.toArray(new String[restNames.size()]);
    }

    @Override
    public Value getRestriction(String restrictionName) throws ValueFormatException, RepositoryException {
        try {
            Name restName = this.resolver.getQName(restrictionName);
            if (!this.restrictions.containsKey(restName)) {
                return null;
            }
            return this.createJcrValue(this.restrictions.get(restName));
        }
        catch (IllegalStateException e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    @Override
    public Value[] getRestrictions(String restrictionName) throws RepositoryException {
        return new Value[]{this.getRestriction(restrictionName)};
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.buildHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AccessControlEntryImpl) {
            AccessControlEntryImpl other = (AccessControlEntryImpl)obj;
            return this.principal.getName().equals(other.principal.getName()) && this.isAllow == other.isAllow && this.restrictions.equals(other.restrictions) && this.mvRestrictions.equals(other.mvRestrictions) && this.getPrivilegesHashCode() == other.getPrivilegesHashCode();
        }
        return false;
    }

    private int buildHashCode() {
        int h = 17;
        h = 37 * h + this.principal.getName().hashCode();
        h = 37 * h + this.getPrivilegesHashCode();
        h = 37 * h + Boolean.valueOf(this.isAllow).hashCode();
        h = 37 * h + this.restrictions.hashCode();
        h = 37 * h + this.mvRestrictions.hashCode();
        return h;
    }

    private int getPrivilegesHashCode() {
        if (this.privsHashCode == -1) {
            HashSet<Privilege> prvs = new HashSet<Privilege>(Arrays.asList(this.privileges));
            for (Privilege p : this.privileges) {
                if (!p.isAggregate()) continue;
                prvs.addAll(Arrays.asList(p.getAggregatePrivileges()));
            }
            this.privsHashCode = prvs.hashCode();
        }
        return this.privsHashCode;
    }

    private void checkAbstract(Privilege[] privileges) throws AccessControlException {
        for (Privilege privilege : privileges) {
            if (!privilege.isAbstract()) continue;
            throw new AccessControlException("An Entry cannot contain abstract privileges.");
        }
    }

    private Value createJcrValue(QValue qValue) throws RepositoryException {
        ValueFactoryQImpl valueFactory = new ValueFactoryQImpl(this.qvf, this.resolver);
        QValueValue jcrValue = new QValueValue(qValue, this.resolver);
        return ValueHelper.copy(jcrValue, (ValueFactory)valueFactory);
    }
}

