/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.io.InputStream;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.rmi.client.ClientItem;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.remote.RemoteLock;
import org.apache.jackrabbit.rmi.remote.RemoteNode;
import org.apache.jackrabbit.rmi.remote.RemoteProperty;
import org.apache.jackrabbit.rmi.value.SerialValueFactory;

public class ClientNode
extends ClientItem
implements Node {
    private RemoteNode remote;

    public ClientNode(Session session, RemoteNode remote, LocalAdapterFactory factory) {
        super(session, remote, factory);
        this.remote = remote;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public void accept(ItemVisitor visitor) throws RepositoryException {
        visitor.visit(this);
    }

    @Override
    public Node addNode(String path) throws RepositoryException {
        try {
            return this.getNode(this.getSession(), this.remote.addNode(path));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Node addNode(String path, String type) throws RepositoryException {
        try {
            RemoteNode node = this.remote.addNode(path, type);
            return this.getNode(this.getSession(), node);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void orderBefore(String src, String dst) throws RepositoryException {
        try {
            this.remote.orderBefore(src, dst);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Property setProperty(String name, Value value) throws RepositoryException {
        try {
            if (value == null) {
                this.remote.setProperty(name, value);
                return null;
            }
            RemoteProperty property = this.remote.setProperty(name, SerialValueFactory.makeSerialValue(value));
            return this.getFactory().getProperty(this.getSession(), property);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Property setProperty(String name, Value[] values) throws RepositoryException {
        try {
            if (values == null) {
                this.remote.setProperty(name, values);
                return null;
            }
            Value[] serials = SerialValueFactory.makeSerialValueArray(values);
            RemoteProperty property = this.remote.setProperty(name, serials);
            return this.getFactory().getProperty(this.getSession(), property);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Property setProperty(String name, String[] strings) throws RepositoryException {
        try {
            if (strings == null) {
                this.remote.setProperty(name, (Value[])null);
                return null;
            }
            Value[] serials = SerialValueFactory.makeSerialValueArray(strings);
            RemoteProperty property = this.remote.setProperty(name, serials);
            return this.getFactory().getProperty(this.getSession(), property);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Property setProperty(String name, String value) throws RepositoryException {
        if (value == null) {
            return this.setProperty(name, (Value)null);
        }
        return this.setProperty(name, this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public Property setProperty(String name, InputStream value) throws RepositoryException {
        if (value == null) {
            return this.setProperty(name, (Value)null);
        }
        return this.setProperty(name, this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public Property setProperty(String name, boolean value) throws RepositoryException {
        return this.setProperty(name, this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public Property setProperty(String name, double value) throws RepositoryException {
        return this.setProperty(name, this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public Property setProperty(String name, long value) throws RepositoryException {
        return this.setProperty(name, this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public Property setProperty(String name, Calendar value) throws RepositoryException {
        if (value == null) {
            return this.setProperty(name, (Value)null);
        }
        return this.setProperty(name, this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public Property setProperty(String name, Node value) throws RepositoryException {
        if (value == null) {
            return this.setProperty(name, (Value)null);
        }
        return this.setProperty(name, this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public Property setProperty(String name, Binary value) throws RepositoryException {
        if (value == null) {
            return this.setProperty(name, (Value)null);
        }
        return this.setProperty(name, this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public Property setProperty(String name, BigDecimal value) throws RepositoryException {
        if (value == null) {
            return this.setProperty(name, (Value)null);
        }
        return this.setProperty(name, this.getSession().getValueFactory().createValue(value));
    }

    @Override
    public Node getNode(String path) throws RepositoryException {
        try {
            return this.getNode(this.getSession(), this.remote.getNode(path));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public NodeIterator getNodes() throws RepositoryException {
        try {
            return this.getFactory().getNodeIterator(this.getSession(), this.remote.getNodes());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public NodeIterator getNodes(String pattern) throws RepositoryException {
        try {
            return this.getFactory().getNodeIterator(this.getSession(), this.remote.getNodes(pattern));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public NodeIterator getNodes(String[] globs) throws RepositoryException {
        try {
            return this.getFactory().getNodeIterator(this.getSession(), this.remote.getNodes(globs));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Property getProperty(String path) throws RepositoryException {
        try {
            RemoteProperty property = this.remote.getProperty(path);
            return this.getFactory().getProperty(this.getSession(), property);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public PropertyIterator getProperties() throws RepositoryException {
        try {
            return this.getFactory().getPropertyIterator(this.getSession(), this.remote.getProperties());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public PropertyIterator getProperties(String pattern) throws RepositoryException {
        try {
            return this.getFactory().getPropertyIterator(this.getSession(), this.remote.getProperties(pattern));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public PropertyIterator getProperties(String[] globs) throws RepositoryException {
        try {
            return this.getFactory().getPropertyIterator(this.getSession(), this.remote.getProperties(globs));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Item getPrimaryItem() throws RepositoryException {
        try {
            return this.getItem(this.getSession(), this.remote.getPrimaryItem());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public String getIdentifier() throws RepositoryException {
        try {
            return this.remote.getIdentifier();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public String getUUID() throws RepositoryException {
        try {
            return this.remote.getUUID();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public PropertyIterator getReferences() throws RepositoryException {
        try {
            return this.getFactory().getPropertyIterator(this.getSession(), this.remote.getReferences());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public PropertyIterator getReferences(String name) throws RepositoryException {
        try {
            return this.getFactory().getPropertyIterator(this.getSession(), this.remote.getReferences(name));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public boolean hasNode(String path) throws RepositoryException {
        try {
            return this.remote.hasNode(path);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public boolean hasProperty(String path) throws RepositoryException {
        try {
            return this.remote.hasProperty(path);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public boolean hasNodes() throws RepositoryException {
        try {
            return this.remote.hasNodes();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public boolean hasProperties() throws RepositoryException {
        try {
            return this.remote.hasProperties();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public NodeType getPrimaryNodeType() throws RepositoryException {
        try {
            return this.getFactory().getNodeType(this.remote.getPrimaryNodeType());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        try {
            return this.getNodeTypeArray(this.remote.getMixinNodeTypes());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public boolean isNodeType(String type) throws RepositoryException {
        try {
            return this.remote.isNodeType(type);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void addMixin(String name) throws RepositoryException {
        try {
            this.remote.addMixin(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void removeMixin(String name) throws RepositoryException {
        try {
            this.remote.removeMixin(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public boolean canAddMixin(String name) throws RepositoryException {
        try {
            return this.remote.canAddMixin(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public NodeDefinition getDefinition() throws RepositoryException {
        try {
            return this.getFactory().getNodeDef(this.remote.getDefinition());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Version checkin() throws RepositoryException {
        try {
            return this.getFactory().getVersion(this.getSession(), this.remote.checkin());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void checkout() throws RepositoryException {
        try {
            this.remote.checkout();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void update(String workspace) throws RepositoryException {
        try {
            this.remote.update(workspace);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public NodeIterator merge(String workspace, boolean bestEffort) throws RepositoryException {
        try {
            return this.getFactory().getNodeIterator(this.getSession(), this.remote.merge(workspace, bestEffort));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void cancelMerge(Version version) throws RepositoryException {
        try {
            this.remote.cancelMerge(version.getUUID());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void doneMerge(Version version) throws RepositoryException {
        try {
            this.remote.doneMerge(version.getUUID());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public String getCorrespondingNodePath(String workspace) throws RepositoryException {
        try {
            return this.remote.getCorrespondingNodePath(workspace);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public int getIndex() throws RepositoryException {
        try {
            return this.remote.getIndex();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void restore(String version, boolean removeExisting) throws RepositoryException {
        try {
            this.remote.restore(version, removeExisting);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void restore(Version version, boolean removeExisting) throws RepositoryException {
        try {
            this.remote.restoreByUUID(version.getUUID(), removeExisting);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void restore(Version version, String path, boolean removeExisting) throws RepositoryException {
        try {
            this.remote.restore(version.getUUID(), path, removeExisting);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void restoreByLabel(String label, boolean removeExisting) throws RepositoryException {
        try {
            this.remote.restoreByLabel(label, removeExisting);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Property setProperty(String name, String[] strings, int type) throws RepositoryException {
        try {
            if (strings == null) {
                this.remote.setProperty(name, (Value[])null);
                return null;
            }
            Value[] serials = SerialValueFactory.makeSerialValueArray(strings);
            RemoteProperty property = this.remote.setProperty(name, serials, type);
            return this.getFactory().getProperty(this.getSession(), property);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Property setProperty(String name, Value[] values, int type) throws RepositoryException {
        try {
            RemoteProperty property;
            if (values != null) {
                values = SerialValueFactory.makeSerialValueArray(values);
            }
            if ((property = this.remote.setProperty(name, values, type)) != null) {
                return this.getFactory().getProperty(this.getSession(), property);
            }
            return null;
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Property setProperty(String name, Value value, int type) throws RepositoryException {
        try {
            RemoteProperty property;
            if (value != null) {
                value = SerialValueFactory.makeSerialValue(value);
            }
            if ((property = this.remote.setProperty(name, value, type)) != null) {
                return this.getFactory().getProperty(this.getSession(), property);
            }
            return null;
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Property setProperty(String name, String string, int type) throws RepositoryException {
        Value value = null;
        if (string != null) {
            value = this.getSession().getValueFactory().createValue(string);
        }
        return this.setProperty(name, value, type);
    }

    @Override
    public boolean isCheckedOut() throws RepositoryException {
        try {
            return this.remote.isCheckedOut();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public VersionHistory getVersionHistory() throws RepositoryException {
        try {
            return this.getFactory().getVersionHistory(this.getSession(), this.remote.getVersionHistory());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Version getBaseVersion() throws RepositoryException {
        try {
            return this.getFactory().getVersion(this.getSession(), this.remote.getBaseVersion());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Lock lock(boolean isDeep, boolean isSessionScoped) throws RepositoryException {
        try {
            RemoteLock lock = this.remote.lock(isDeep, isSessionScoped);
            return this.getFactory().getLock(this.getSession(), lock);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Lock getLock() throws RepositoryException {
        try {
            return this.getFactory().getLock(this.getSession(), this.remote.getLock());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void unlock() throws RepositoryException {
        try {
            this.remote.unlock();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public boolean holdsLock() throws RepositoryException {
        try {
            return this.remote.holdsLock();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public boolean isLocked() throws RepositoryException {
        try {
            return this.remote.isLocked();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void followLifecycleTransition(String transition) throws RepositoryException {
        try {
            this.remote.followLifecycleTransition(transition);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public String[] getAllowedLifecycleTransistions() throws RepositoryException {
        try {
            return this.remote.getAllowedLifecycleTransistions();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public NodeIterator getSharedSet() throws RepositoryException {
        try {
            return this.getFactory().getNodeIterator(this.getSession(), this.remote.getSharedSet());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public PropertyIterator getWeakReferences() throws RepositoryException {
        try {
            return this.getFactory().getPropertyIterator(this.getSession(), this.remote.getWeakReferences());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public PropertyIterator getWeakReferences(String name) throws RepositoryException {
        try {
            return this.getFactory().getPropertyIterator(this.getSession(), this.remote.getWeakReferences(name));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void removeShare() throws RepositoryException {
        try {
            this.remote.removeShare();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void removeSharedSet() throws RepositoryException {
        try {
            this.remote.removeSharedSet();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void setPrimaryType(String nodeTypeName) throws RepositoryException {
        try {
            this.remote.setPrimaryType(nodeTypeName);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }
}

