/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.rmi.value.AbstractValue;

class DoubleValue
extends AbstractValue {
    private static final long serialVersionUID = -2767063038068929611L;
    private final double value;

    public DoubleValue(double value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public Calendar getDate() throws ValueFormatException {
        if (-9.223372036854776E18 <= this.value && this.value <= 9.223372036854776E18) {
            Calendar date = Calendar.getInstance();
            date.setTimeInMillis((long)this.value);
            return date;
        }
        throw new ValueFormatException("Double value is outside the date range: " + this.value);
    }

    @Override
    public BigDecimal getDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public long getLong() {
        return (long)this.value;
    }

    @Override
    public String getString() {
        return Double.toString(this.value);
    }
}

