/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.xml;

import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.referencing.CommonCRS;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

@XmlTransient
public abstract class GeographicEnvelope
extends AbstractEnvelope
implements GeographicBoundingBox,
Extent {
    protected GeographicEnvelope() {
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return CommonCRS.WGS84.geographic();
    }

    @Override
    public double getLower(int n) {
        switch (n) {
            case 0: {
                return this.getSouthBoundLatitude();
            }
            case 1: {
                return this.getWestBoundLongitude();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double getUpper(int n) {
        switch (n) {
            case 0: {
                return this.getNorthBoundLatitude();
            }
            case 1: {
                return this.getEastBoundLongitude();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public InternationalString getDescription() {
        return null;
    }

    @Override
    public Collection<? extends GeographicExtent> getGeographicElements() {
        return Collections.singleton(this);
    }

    @Override
    public Collection<? extends TemporalExtent> getTemporalElements() {
        return Collections.emptySet();
    }

    @Override
    public Collection<? extends VerticalExtent> getVerticalElements() {
        return Collections.emptySet();
    }

    @Override
    public Boolean getInclusion() {
        return Boolean.TRUE;
    }
}

