<!--
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
  -->

Release Notes -- Apache Jackrabbit FileVault Package Maven Plugin -- Version 1.4.0
==================================================================================

Introduction
------------
The Apache Jackrabbit FileVault Package Maven Plugin is an Apache Maven plugin that simplifies the creation of
content package Maven artifacts. The content packages can later be used to install content into a JCR repository
using the Apache Jackrabbit FileVault packaging runtime.

Changes in Jackrabbit FileVault Package Maven Plugin 1.4.0
---------------------------------------------------

#### Bug
* [JCRVLT-769] - mapPackageDependencyToMavenGa does no longer work

#### Improvement
* [JCRVLT-742] - Stop generating MD5, SHA1 and SHA512 with Ant
* [JCRVLT-757] - Optionally apply Enhanced DocView XML escaping to filtered values
* [JCRVLT-765] - Update to FileVault 3.8.2
* [JCRVLT-780] - Remove @Component annotations

#### Task
* [JCRVLT-754] - check-release does not work for filevault anymore


Changes in Jackrabbit FileVault Package Maven Plugin 1.3.6
---------------------------------------------------

#### Bug Fixes
* [JCRVLT-713] - filevault-package-maven-plugin wrongly reports duplicate files for same path
* [JCRVLT-715] - Content Package with classifier potentially installed/deployed with wrong extension
* [JCRVLT-723] - validate-packages must only validate artifacts of type "content-package"

#### Improvements
* [JCRVLT-717] - Update dependencies
* [JCRVLT-732] - Use FileVault 3.7.2


Changes in Jackrabbit FileVault Package Maven Plugin 1.3.4
---------------------------------------------------

#### Bug Fixes
* [JCRVLT-681] - validate-files: Files which don't end up in the package are validated
* [JCRVLT-699] - Installation of Sub Packages fails if Maven Reproducible Builds are enabled

#### Improvements
* [JCRVLT-669] - Log throwable of ValidationMessage
* [JCRVLT-686] - Goal format-xml: Improve help how to format docview XML
* [JCRVLT-694] - Document OSGi support
* [JCRVLT-712] - Use FileVault 3.7.0


Changes in Jackrabbit FileVault Package Maven Plugin 1.3.2
---------------------------------------------------

#### Bug Fixes
* [JCRVLT-431] - GenerateMetadataMojo.computePackageType does not work correctly for OSGi configurations/bundles
* [JCRVLT-651] - validate-package: Allow to exclude main artifact
* [JCRVLT-665] - Allow standalone usage of filevault-package:validate-package

#### Improvements
* [JCRVLT-618] - Clarify repositoryStructurePackages parameter
* [JCRVLT-621] - Set "builtWith" property
* [JCRVLT-625] - Ignore goal "generate-cnd" in Eclipse m2e
* [JCRVLT-626] - Update to maven-verifier 1.8.0
* [JCRVLT-629] - Change default value for failOnUncoveredSourceFiles to true
* [JCRVLT-635] - Write validation messages with styles
* [JCRVLT-641] - Use plexus-utils instead of Maven Shared Utils
* [JCRVLT-642] - Drop Plexus components and only rely on JSR 330
* [JCRVLT-668] - Use FileVault 3.6.6


Changes in Jackrabbit FileVault Package Maven Plugin 1.3.0
---------------------------------------------------

#### Bug Fixes
* [JCRVLT-566] - "validatorSettings" does no longer detect lowercase values for "defaultSeverity"
* [JCRVLT-595] - NPE when using filevault-package-maven-plugin:validate-package without project
* [JCRVLT-609] - Package specific validator settings rely on colon which is not allowed in XML names
* [JCRVLT-611] - Fix default phase binding
* [JCRVLT-616] - Fix default excludes

#### New Features
* [JCRVLT-558] - Support adding a CND automatically

#### Improvements
* [JCRVLT-567] - Move ValidationContext implementation to validation module and export them
* [JCRVLT-580] - Execute ITs with multiple Maven versions
* [JCRVLT-585] - Update some dependencies
* [JCRVLT-586] - Mark Maven-exported dependencies as scope provided
* [JCRVLT-610] - filevault-package-maven-plugin: Switch to JUnit5
* [JCRVLT-617] - Use FileVault 3.6.0

#### Tasks
* [JCRVLT-607] - Require Java 11+ for building


Changes in Jackrabbit FileVault Package Maven Plugin 1.2.2
---------------------------------------------------

#### Bug Fixes
* [JCRVLT-528] - filevault-package-maven-plugin:validate-files reports nodetype related errors validate-package does not
* [JCRVLT-537] - validate-package goal incorrectly assumes that all zip files inside packages are subpackages
* [JCRVLT-553] - validate-package fails when using classifier
* [JCRVLT-564] - jackrabbit-packagetype validation fails for content package with .cfg.json OSGi configurations

#### Improvements
* [JCRVLT-316] - Add dedicated parameter to specify subPackageHandling
* [JCRVLT-530] - Add Jenkins build automatically deploying SNAPSHOTs
* [JCRVLT-541] - Reduce logging of filevault-package-maven-plugin:analyze-classes
* [JCRVLT-554] - Don't bind "analyze-classes" goal by default
* [JCRVLT-555] - Don't bind "check-signature" goal by default
* [JCRVLT-562] - Build with Java 17
* [JCRVLT-563] - Change default phases for goals


Changes in Jackrabbit FileVault Package Maven Plugin 1.1.8
---------------------------------------------------

#### Bug Fixes
* [JCRVLT-495] - Allow to exclude binaries without extension from filtering
* [JCRVLT-498] - Package mojo is using wrong workDirectory if classifier is used

#### Improvements
* [JCRVLT-249] - Allow to include a hook jar via a dedicated parameter
* [JCRVLT-501] - Get rid of plexus-utils dependency
* [JCRVLT-518] - Optionally create CSV report from validation violations


Changes in Jackrabbit FileVault Package Maven Plugin 1.1.6
---------------------------------------------------

#### Bug Fixes
* [JCRVLT-467] - Thread Context ClassLoader destroyed in validate-files mojo
* [JCRVLT-477] - package maven plugin filtering complains about platform encoding although project.build.sourceEncoding is set
* [JCRVLT-478] - package maven plugin reports warning when classifier option is not used
* [JCRVLT-481] - filefault-package:format-xml fails when executed in build reactor
* [JCRVLT-483] - Package thumbnail image is copied twice (and produced warnings) if placed in META-INF/vault/definition folder
* [JCRVLT-490] - jackrabbit-filevault-package-maven-plugin fails embedding files located on different drives on Windows

#### Improvements
* [JCRVLT-466] - Allow embeddeds and subpackages to optionally only work on direct but not transitive dependencies
* [JCRVLT-468] - Skip "validate-files" when "validate-package" is executed later on also in case of forked executions
* [JCRVLT-471] - Allow configuring files that will be packaged under META-INF
* [JCRVLT-475] - Enable Sonarcloud.io analysis with Travis


Changes in Jackrabbit FileVault Package Maven Plugin 1.1.4
---------------------------------------------------

#### Bug Fixes
* [JCRVLT-425] - m2e integration emits all errors on the pom.xml

#### Improvements
* [JCRVLT-398] - Migrate Filevault to Git
* [JCRVLT-434] - Allow classifier option for filevault-maven-plugin
* [JCRVLT-435] - Allow creating cleanup packages only
* [JCRVLT-442] - Validate Mojos: Make sure that .content.xml files are processed before any other siblings
* [JCRVLT-455] - Validation goals: Allow to hide warning due to unresolvable package dependencies


Changes in Jackrabbit FileVault Package Maven Plugin 1.1.2
---------------------------------------------------

#### Bug Fixes
* [JCRVLT-405] - Potential NPE in GenerateMetadataMojo:computeDependenciesLocations
* [JCRVLT-408] - Filter entries which are not covering anything may lead to the root's .content.xml being copied to the entry root
* [JCRVLT-412] - Option "isAllVersionsFilter" does not generate a correct pattern
* [JCRVLT-415] - jackrabbit-emptyelements validator reports error for nested folders
* [JCRVLT-418] - Failed to scan the classpath Unknown constant pool tag for FastClasspathScanner for analyze-classes goal

#### Improvements
* [JCRVLT-404] - Allow to adjust validator settings for specific packages
* [JCRVLT-420] - Allow to skip sub package validation


Changes in Jackrabbit FileVault Package Maven Plugin 1.1.0
----------------------------------------------------------

#### Bug Fixes
* [JCRVLT-342] - File leak in ProjectBuilder.getPluginVersion()
* [JCRVLT-343] - Check for index definitions also considers ACL entries
* [JCRVLT-351] - IOE thrown in case of no filter and <failOnEmptyFilter>false</failOnEmptyFilter>
* [JCRVLT-354] - False warnings for files not being included in the package due to being outside of filter roots
* [JCRVLT-355] - False error in case embedded file/subpackage is overwritten by jcrRootSourceDirectory
* [JCRVLT-363] - .content.xml of ancestor nodes not included in package
* [JCRVLT-381] - m2e Integration for goal "format-xml" might lead to endless loops
* [JCRVLT-386] - Eclipse/m2e: Could not get metadata for dependencies which are resolved via m2e workspace resolution or for multimodule builds with phases < package
* [JCRVLT-387] - Support reproducible builds

#### New Features
* [JCRVLT-232] - Enforce constraints for package types
* [JCRVLT-345] - Support pluggable node/file/filter validators

#### Improvements
* [JCRVLT-350] - Make all goals support parallel builds (mark as threadSafe)
* [JCRVLT-361] - Validate that all includes/excludes are below the filter root
* [JCRVLT-365] - Migrate from JSR 305 to Jetbrains annotations
* [JCRVLT-370] - New filter option below embeddeds and subpackages which removes other versions
* [JCRVLT-371] - Include Maven groupId and artifactId of each dependency in the MANIFEST.MF and the properties.xml
* [JCRVLT-373] - Log overlapping files from workDirectory and metaInf source directory
* [JCRVLT-389] - Optionally support Maven Filtering during packaging
* [JCRVLT-399] - Update to Jackrabbit 2.20.0  / Oak 1.20.0

#### Tasks
* [JCRVLT-392] - Support Matrix builds on Windows/Linux with Travis
* [JCRVLT-393] - Java 13 Build Support


Changes in Jackrabbit FileVault Package Maven Plugin 1.0.4
----------------------------------------------------------

#### Bug Fixes
* [JCRVLT-279] - Emit warning/error in case embedded file/subpackage is overwritten by jcrRootSourceDirectory
* [JCRVLT-320] - filevault-package-maven-plugin:package does not work with Java >= 9
* [JCRVLT-324] - In case of a long project description in CDATA the resulting MANIFEST.MF is invalid
* [JCRVLT-326] - Embedded files Map stored in project properties breaks Jenkins+Artifactory integration

#### Improvements
* [JCRVLT-321] - Warn for files not being included in the package due to being outside of filter roots
* [JCRVLT-331] - Incorrect embedded base name used in generate-metadata goal during CLI execution of `mvn test`


Changes in Jackrabbit FileVault Package Maven Plugin 1.0.3
----------------------------------------------------------

#### Bug Fixes
* [JCRVLT-256] Package Maven Plugin: NPE when dependency has no manifest
* [JCRVLT-276] Switch to timezone designators being understood by ISO8601.parse(...)
* [JCRVLT-272] analyze-classes mojo can fail with "Access denied" for multi-module projects
* [JCRVLT-268] scanning for oak index does not work on windows systems

#### New Features
* [JCRVLT-288] Support XML Docview formatting in a dedicated goal

#### Improvements
* [JCRVLT-246] Generate metadata like filter.xml and properties.xml in dedicated goal
* [JCRVLT-274] Package Maven Plugin: Support multiple types and classifiers as filter within embedded/subpackage section
* [JCRVLT-315] Improve error message in case of embedding invalid sub packages


Changes in Jackrabbit FileVault Package Maven Plugin 1.0.1
----------------------------------------------------------

#### Bug Fixes
* [JCRVLT-218] Repository structure package satisfies too aggressively
* [JCRVLT-219] Internal ancestors not used for dependency validation
* [JCRVLT-222] analyze-classes goal should be marked as ignored for m2e
* [JCRVLT-237] Fix description on how import-package manifests are generated
* [JCRVLT-241] Goal analyze-classes: Dependencies with type "bundle" not correctly considered
* [JCRVLT-242] Link for the web access of Jackrabbit's FileVault Package source repository is wrong
* [JCRVLT-244] Package Maven Plugin: Fix resource leaks in integration tests
* [JCRVLT-245] Package Maven Plugin: ProjectBuilder.verifyPackageProperty swaps expected/actual value
* [JCRVLT-253] Problems with Configuration inside an Execution with Filters

#### Improvements
* [JCRVLT-217] Create tests for JCRVLT-207 (HTL) as soon as plugin is released
* [JCRVLT-224] Use filevault-core instead of copy-pasting code
* [JCRVLT-231] Clarify repositoryStructurePackages parameter
* [JCRVLT-234] Remove irrelevant @Parameter annotations on field in classes which are not mojos
* [JCRVLT-236] Package Maven Plugin: Improve packageType param documentation
* [JCRVLT-238] Remove classesDirectory parameter
* [JCRVLT-243] VaultMojo: extend javadoc for all complex type parameters
* [JCRVLT-252] Package Maven Plugin: Update to htl-maven-plugin 1.1.2

#### New Features
* [JCRVLT-230] Allow to give an explicit directory as source for META-INF/vault
* [JCRVLT-239] Package Maven Plugin: Add "accessControlHandling" property
* [JCRVLT-240] Package Maven Plugin: Support for package thumbnails


Changes in Jackrabbit FileVault Package Maven Plugin 1.0.0
----------------------------------------------------------

#### Notes
Version 1.0.0 is the initial version of this contribution to the Apache
Jackrabbit project.

For more detailed information about all the changes in this and other
FileVault releases, please see the FileVault issue tracker at
https://issues.apache.org/jira/browse/JCRVLT

#### Bug Fixes
* [JCRVLT-206] Auto import-statement too big in case no compiled classes found

#### Improvements
* [JCRVLT-202] Import Adobe's content package maven plugin
* [JCRVLT-204] Create documentation site for maven plugin
* [JCRVLT-207] Make auto-import package a analyzer work with htl scripts
* [JCRVLT-209] Always write to the filter.xml inside the vaultDir but never to filter-plugin-generated.xml

#### New Features
* [JCRVLT-205] Add support for cleanup filter entries
* [JCRVLT-210] Allow to define excludes for the ContentPackageArchiver to prevent copying of script files from src to target
* [JCRVLT-214] auto-import package analyzer needs option to exclude compiletime bundles


Release Contents
----------------
This release consists of a single source archive packaged as a zip file.
The archive can be unpacked with the jar tool from your JDK installation.
See the [README](./README.md) file for instructions on how to build this release.

The source archive is accompanied by SHA1 and MD5 checksums and a PGP
signature that you can use to verify the authenticity of your download.
The public key used for the PGP signature can be found at
https://www.apache.org/dist/jackrabbit/KEYS

About Apache Jackrabbit
-----------------------
Apache Jackrabbit is a fully conforming implementation of the Content
Repository for Java Technology API (JCR). A content repository is a
hierarchical content store with support for structured and unstructured
content, full text search, versioning, transactions, observation, and
more.

For more information, visit http://jackrabbit.apache.org/

About The Apache Software Foundation
------------------------------------
Established in 1999, The Apache Software Foundation provides organizational,
legal, and financial support for more than 100 freely-available,
collaboratively-developed Open Source projects. The pragmatic Apache License
enables individual and commercial users to easily deploy Apache software;
the Foundation's intellectual property framework limits the legal exposure
of its 2,500+ contributors.

For more information, visit http://www.apache.org/

Trademarks
----------
Apache Jackrabbit, Jackrabbit, Apache, the Apache feather logo, and the Apache
Jackrabbit project logo are trademarks of The Apache Software Foundation.
