/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.UnknownHook;

public class MaxUnknownCmdHandler
implements UnknownHook {
    public static final int DEFAULT_MAX_UNKOWN = 5;
    private static final ProtocolSession.AttachmentKey<Integer> UNKOWN_COMMAND_COUNT = ProtocolSession.AttachmentKey.of((String)"UNKNOWN_COMMAND_COUNT", Integer.class);
    private int maxUnknown = 5;

    public void setMaxUnknownCmdCount(int maxUnknown) {
        this.maxUnknown = maxUnknown;
    }

    @Override
    public HookResult doUnknown(SMTPSession session, String command) {
        Integer count = session.getAttachment(UNKOWN_COMMAND_COUNT, ProtocolSession.State.Transaction).map(fetchedCount -> fetchedCount + 1).orElse(1);
        session.setAttachment(UNKOWN_COMMAND_COUNT, count, ProtocolSession.State.Transaction);
        if (count > this.maxUnknown) {
            return HookResult.builder().hookReturnCode(HookReturnCode.disconnected(HookReturnCode.Action.DENY)).smtpReturnCode("521").smtpDescription("Closing connection as too many unknown commands received").build();
        }
        return HookResult.DECLINED;
    }
}

