/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.tasks.CancelTasksRequest;
import org.elasticsearch.client.tasks.GetTaskRequest;

final class TasksRequestConverters {
    private TasksRequestConverters() {
    }

    static Request cancelTasks(CancelTasksRequest req) {
        Request request = new Request("POST", "/_tasks/_cancel");
        RequestConverters.Params params = new RequestConverters.Params();
        req.getTimeout().ifPresent(params::withTimeout);
        req.getTaskId().ifPresent(params::withTaskId);
        req.getParentTaskId().ifPresent(params::withParentTaskId);
        params.withNodes(req.getNodes()).withActions(req.getActions());
        if (req.getWaitForCompletion() != null) {
            params.withWaitForCompletion(req.getWaitForCompletion());
        }
        request.addParameters(params.asMap());
        return request;
    }

    static Request listTasks(ListTasksRequest listTaskRequest) {
        if (listTaskRequest.getTaskId() != null && listTaskRequest.getTaskId().isSet()) {
            throw new IllegalArgumentException("TaskId cannot be used for list tasks request");
        }
        Request request = new Request("GET", "/_tasks");
        RequestConverters.Params params = new RequestConverters.Params();
        params.withTimeout(listTaskRequest.getTimeout()).withDetailed(listTaskRequest.getDetailed()).withWaitForCompletion(listTaskRequest.getWaitForCompletion()).withParentTaskId(listTaskRequest.getParentTaskId()).withNodes(listTaskRequest.getNodes()).withActions(listTaskRequest.getActions()).putParam("group_by", "none");
        request.addParameters(params.asMap());
        return request;
    }

    static Request getTask(GetTaskRequest getTaskRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_tasks").addPathPartAsIs(getTaskRequest.getNodeId() + ":" + Long.toString(getTaskRequest.getTaskId())).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.withTimeout(getTaskRequest.getTimeout()).withWaitForCompletion(getTaskRequest.getWaitForCompletion());
        request.addParameters(params.asMap());
        return request;
    }
}

