/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.mailbox;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.jmap.draft.model.Number;
import org.apache.james.jmap.draft.model.mailbox.MailboxNamespace;
import org.apache.james.jmap.draft.model.mailbox.Quotas;
import org.apache.james.jmap.draft.model.mailbox.Rights;
import org.apache.james.jmap.draft.model.mailbox.SortOrder;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.model.MailboxId;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="propertiesFilter")
public class Mailbox {
    private final MailboxId id;
    private final String name;
    private final Optional<MailboxId> parentId;
    private final Optional<Role> role;
    private final SortOrder sortOrder;
    private final boolean mustBeOnlyMailbox;
    private final boolean mayReadItems;
    private final boolean mayAddItems;
    private final boolean mayRemoveItems;
    private final boolean mayCreateChild;
    private final boolean mayRename;
    private final boolean mayDelete;
    private final Number totalMessages;
    private final Number unreadMessages;
    private final Number totalThreads;
    private final Number unreadThreads;
    private final Rights sharedWith;
    private final MailboxNamespace namespace;
    private final Optional<Quotas> quotas;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    Mailbox(MailboxId id, String name, Optional<MailboxId> parentId, Optional<Role> role, SortOrder sortOrder, boolean mustBeOnlyMailbox, boolean mayReadItems, boolean mayAddItems, boolean mayRemoveItems, boolean mayCreateChild, boolean mayRename, boolean mayDelete, Number totalMessages, Number unreadMessages, Number totalThreads, Number unreadThreads, Rights sharedWith, MailboxNamespace namespace, Optional<Quotas> quotas) {
        this.id = id;
        this.name = name;
        this.parentId = parentId;
        this.role = role;
        this.sortOrder = sortOrder;
        this.mustBeOnlyMailbox = mustBeOnlyMailbox;
        this.mayReadItems = mayReadItems;
        this.mayAddItems = mayAddItems;
        this.mayRemoveItems = mayRemoveItems;
        this.mayCreateChild = mayCreateChild;
        this.mayRename = mayRename;
        this.mayDelete = mayDelete;
        this.totalMessages = totalMessages;
        this.unreadMessages = unreadMessages;
        this.totalThreads = totalThreads;
        this.unreadThreads = unreadThreads;
        this.sharedWith = sharedWith;
        this.namespace = namespace;
        this.quotas = quotas;
    }

    public MailboxId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Optional<MailboxId> getParentId() {
        return this.parentId;
    }

    public Optional<Role> getRole() {
        return this.role;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public boolean isMustBeOnlyMailbox() {
        return this.mustBeOnlyMailbox;
    }

    public boolean isMayReadItems() {
        return this.mayReadItems;
    }

    public boolean isMayAddItems() {
        return this.mayAddItems;
    }

    public boolean isMayRemoveItems() {
        return this.mayRemoveItems;
    }

    public boolean isMayCreateChild() {
        return this.mayCreateChild;
    }

    public boolean isMayRename() {
        return this.mayRename;
    }

    public boolean isMayDelete() {
        return this.mayDelete;
    }

    public Number getTotalMessages() {
        return this.totalMessages;
    }

    public Number getUnreadMessages() {
        return this.unreadMessages;
    }

    public Number getTotalThreads() {
        return this.totalThreads;
    }

    public Number getUnreadThreads() {
        return this.unreadThreads;
    }

    public Rights getSharedWith() {
        return this.sharedWith;
    }

    public MailboxNamespace getNamespace() {
        return this.namespace;
    }

    public Optional<Quotas> getQuotas() {
        return this.quotas;
    }

    @JsonIgnore
    public boolean hasRole(Role role) {
        return this.role.map(currentRole -> Objects.equals(currentRole, role)).orElse(false);
    }

    @JsonIgnore
    public boolean hasSystemRole() {
        return this.role.map(Role::isSystemRole).orElse(false);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Mailbox) {
            Mailbox other = (Mailbox)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.parentId, other.parentId) && Objects.equals(this.role, other.role) && Objects.equals(this.sortOrder, other.sortOrder) && Objects.equals(this.mustBeOnlyMailbox, other.mustBeOnlyMailbox) && Objects.equals(this.mayReadItems, other.mayReadItems) && Objects.equals(this.mayAddItems, other.mayAddItems) && Objects.equals(this.mayRemoveItems, other.mayRemoveItems) && Objects.equals(this.mayCreateChild, other.mayCreateChild) && Objects.equals(this.mayRename, other.mayRename) && Objects.equals(this.mayDelete, other.mayDelete) && Objects.equals(this.totalMessages, other.totalMessages) && Objects.equals(this.unreadMessages, other.unreadMessages) && Objects.equals(this.totalThreads, other.totalThreads) && Objects.equals(this.unreadThreads, other.unreadThreads) && Objects.equals(this.sharedWith, other.sharedWith) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.quotas, other.quotas);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.name, this.parentId, this.role, this.sortOrder, this.mustBeOnlyMailbox, this.mayReadItems, this.mayAddItems, this.mayRemoveItems, this.mayCreateChild, this.mayRename, this.mayDelete, this.totalMessages, this.unreadMessages, this.totalThreads, this.unreadThreads, this.sharedWith, this.namespace, this.quotas);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id).add("name", (Object)this.name).add("sortOrder", (Object)this.sortOrder).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private MailboxId id;
        private String name;
        private Optional<MailboxId> parentId = Optional.empty();
        private Optional<Role> role;
        private SortOrder sortOrder;
        private boolean mustBeOnlyMailbox;
        private boolean mayReadItems;
        private boolean mayAddItems;
        private boolean mayRemoveItems;
        private boolean mayCreateChild;
        private boolean mayRename;
        private boolean mayDelete;
        private Optional<Number> totalMessages;
        private Optional<Number> unreadMessages;
        private Optional<Number> totalThreads;
        private Optional<Number> unreadThreads;
        private Optional<Rights> sharedWith = Optional.empty();
        private Optional<MailboxNamespace> namespace = Optional.empty();
        private Optional<Quotas> quotas;

        private Builder() {
            this.totalMessages = Optional.empty();
            this.unreadMessages = Optional.empty();
            this.totalThreads = Optional.empty();
            this.unreadThreads = Optional.empty();
            this.role = Optional.empty();
            this.quotas = Optional.empty();
        }

        public Builder id(MailboxId id) {
            Preconditions.checkNotNull((Object)id);
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            Preconditions.checkNotNull((Object)name);
            this.name = name;
            return this;
        }

        public Builder parentId(MailboxId parentId) {
            this.parentId = Optional.ofNullable(parentId);
            return this;
        }

        public Builder role(Optional<Role> role) {
            this.role = role;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder mustBeOnlyMailbox(boolean mustBeOnlyMailbox) {
            this.mustBeOnlyMailbox = mustBeOnlyMailbox;
            return this;
        }

        public Builder mayReadItems(boolean mayReadItems) {
            this.mayReadItems = mayReadItems;
            return this;
        }

        public Builder mayAddItems(boolean mayAddItems) {
            this.mayAddItems = mayAddItems;
            return this;
        }

        public Builder mayRemoveItems(boolean mayRemoveItems) {
            this.mayRemoveItems = mayRemoveItems;
            return this;
        }

        public Builder mayCreateChild(boolean mayCreateChild) {
            this.mayCreateChild = mayCreateChild;
            return this;
        }

        public Builder mayRename(boolean mayRename) {
            this.mayRename = mayRename;
            return this;
        }

        public Builder mayDelete(boolean mayDelete) {
            this.mayDelete = mayDelete;
            return this;
        }

        public Builder totalMessages(long totalMessages) {
            this.totalMessages = Optional.of(Number.BOUND_SANITIZING_FACTORY.from(totalMessages));
            return this;
        }

        public Builder unreadMessages(long unreadMessages) {
            this.unreadMessages = Optional.of(Number.BOUND_SANITIZING_FACTORY.from(unreadMessages));
            return this;
        }

        public Builder totalThreads(long totalThreads) {
            this.totalThreads = Optional.of(Number.BOUND_SANITIZING_FACTORY.from(totalThreads));
            return this;
        }

        public Builder unreadThreads(long unreadThreads) {
            this.unreadThreads = Optional.of(Number.BOUND_SANITIZING_FACTORY.from(unreadThreads));
            return this;
        }

        public Builder sharedWith(Rights sharedWith) {
            this.sharedWith = Optional.of(sharedWith);
            return this;
        }

        public Builder namespace(MailboxNamespace namespace) {
            this.namespace = Optional.of(namespace);
            return this;
        }

        public Builder quotas(Quotas quotas) {
            this.quotas = Optional.of(quotas);
            return this;
        }

        public Mailbox build() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.name) ? 1 : 0) != 0, (Object)"'name' is mandatory");
            Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"'id' is mandatory");
            return new Mailbox(this.id, this.name, this.parentId, this.role, this.sortOrder, this.mustBeOnlyMailbox, this.mayReadItems, this.mayAddItems, this.mayRemoveItems, this.mayCreateChild, this.mayRename, this.mayDelete, this.totalMessages.orElse(Number.ZERO), this.unreadMessages.orElse(Number.ZERO), this.totalThreads.orElse(Number.ZERO), this.unreadThreads.orElse(Number.ZERO), this.sharedWith.orElse(Rights.EMPTY), this.namespace.orElse(MailboxNamespace.personal()), this.quotas);
        }
    }
}

