/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.net.URISyntaxException;
import java.util.Map;
import org.apache.activemq.artemis.api.core.QueueAttributes;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.utils.uri.URISupport;

public class ParameterisedAddress {
    private final SimpleString address;
    private final QueueConfiguration queueConfiguration;

    public static SimpleString toParameterisedAddress(SimpleString address, Map<String, String> parameters) throws URISyntaxException {
        if (parameters != null && !parameters.isEmpty()) {
            return SimpleString.toSimpleString(ParameterisedAddress.toParameterisedAddress(address.toString(), parameters));
        }
        return address;
    }

    public static String toParameterisedAddress(String address, Map<String, String> parameters) throws URISyntaxException {
        if (parameters != null && !parameters.isEmpty()) {
            return URISupport.appendParameters(new StringBuilder(address), parameters).toString();
        }
        return address;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    @Deprecated
    public QueueAttributes getQueueAttributes() {
        return QueueAttributes.fromQueueConfiguration(this.queueConfiguration);
    }

    public QueueConfiguration getQueueConfiguration() {
        return this.queueConfiguration;
    }

    @Deprecated
    public ParameterisedAddress(SimpleString address, QueueAttributes queueAttributes) {
        this.address = address;
        this.queueConfiguration = queueAttributes.toQueueConfiguration();
    }

    public ParameterisedAddress(SimpleString address, QueueConfiguration queueConfiguration) {
        this.address = address;
        this.queueConfiguration = queueConfiguration;
    }

    @Deprecated
    public ParameterisedAddress(String address, QueueAttributes queueAttributes) {
        this(SimpleString.toSimpleString(address), queueAttributes.toQueueConfiguration());
    }

    public ParameterisedAddress(String address, QueueConfiguration queueConfiguration) {
        this(SimpleString.toSimpleString(address), queueConfiguration);
    }

    public ParameterisedAddress(SimpleString address) {
        this(address.toString());
    }

    public ParameterisedAddress(String address) {
        int index = address.indexOf(63);
        if (index == -1) {
            this.address = SimpleString.toSimpleString(address);
            this.queueConfiguration = null;
        } else {
            this.address = SimpleString.toSimpleString(address.substring(0, index));
            QueueConfiguration queueConfiguration = new QueueConfiguration(address);
            try {
                URISupport.parseQuery(address).forEach(queueConfiguration::set);
            }
            catch (URISyntaxException use) {
                throw new IllegalArgumentException("Malformed parameters in address " + address);
            }
            this.queueConfiguration = queueConfiguration;
        }
    }

    public boolean isParameterised() {
        return this.queueConfiguration != null;
    }

    public static boolean isParameterised(String address) {
        return URISupport.containsQuery(address);
    }

    public static boolean isParameterised(SimpleString address) {
        return URISupport.containsQuery(address);
    }
}

