/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum PasswordPolicyWarningType {
    TIME_BEFORE_EXPIRATION("time before expiration"),
    GRACE_LOGINS_REMAINING("grace logins remaining");

    @NotNull
    private final String name;

    private PasswordPolicyWarningType(String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public static PasswordPolicyWarningType forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "timebeforeexpiration": 
            case "time-before-expiration": 
            case "time_before_expiration": 
            case "time before expiration": {
                return TIME_BEFORE_EXPIRATION;
            }
            case "graceloginsremaining": 
            case "grace-logins-remaining": 
            case "grace_logins_remaining": 
            case "grace logins remaining": {
                return GRACE_LOGINS_REMAINING;
            }
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.name;
    }
}

