/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.ldap.sdk.unboundidds.monitors.ProcessingTimeHistogramMonitorEntry;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PerApplicationProcessingTimeHistogramMonitorEntry
extends ProcessingTimeHistogramMonitorEntry {
    private static final long serialVersionUID = 1467986373260986009L;
    @NotNull
    static final String PER_APPLICATION_PROCESSING_TIME_HISTOGRAM_MONITOR_OC = "ds-per-application-processing-time-histogram-monitor-entry";
    @NotNull
    private static final String ATTR_APPLICATION_NAME = "applicationName";
    @Nullable
    private final String applicationName;

    public PerApplicationProcessingTimeHistogramMonitorEntry(@NotNull Entry entry) {
        super(entry);
        this.applicationName = entry.getAttributeValue(ATTR_APPLICATION_NAME);
    }

    @Nullable
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_PER_APP_PROCESSING_TIME_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_PER_APP_PROCESSING_TIME_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        Map<String, MonitorAttribute> superAttrs = super.getMonitorAttributes();
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(superAttrs.size() + 1));
        attrs.putAll(superAttrs);
        if (this.applicationName != null) {
            PerApplicationProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_APPLICATION_NAME, MonitorMessages.INFO_PER_APP_PROCESSING_TIME_DISPNAME_APP_NAME.get(), MonitorMessages.INFO_PER_APP_PROCESSING_TIME_DESC_APP_NAME.get(), this.applicationName);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

