/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.management.Attribute;
import org.apache.activemq.artemis.api.core.management.Operation;
import org.apache.activemq.artemis.api.core.management.Parameter;

public interface ActiveMQServerControl {
    public static final String CONNECTION_COUNT_DESCRIPTION = "Number of clients connected to this server";
    public static final String TOTAL_CONNECTION_COUNT_DESCRIPTION = "Number of clients which have connected to this server since it was started";
    public static final String ADDRESS_MEMORY_USAGE_DESCRIPTION = "Memory used by all the addresses on broker for in-memory messages";
    public static final String ADDRESS_MEMORY_USAGE_PERCENTAGE_DESCRIPTION = "Memory used by all the addresses on broker as a percentage of the global-max-size";
    public static final String DISK_STORE_USAGE_DESCRIPTION = "Fraction of total disk store used";

    @Attribute(desc="Server's version")
    public String getVersion();

    @Attribute(desc="Server is active")
    public boolean isActive();

    @Attribute(desc="Number of clients connected to this server")
    public int getConnectionCount();

    @Attribute(desc="Number of clients which have connected to this server since it was started")
    public long getTotalConnectionCount();

    @Attribute(desc="Number of messages in all queues on the server")
    public long getTotalMessageCount();

    @Attribute(desc="Number of messages sent to this server since it was started")
    public long getTotalMessagesAdded();

    @Attribute(desc="Number of messages acknowledged from all the queues on this server since it was started")
    public long getTotalMessagesAcknowledged();

    @Attribute(desc="Number of consumers consuming messages from all the queues on this server")
    public long getTotalConsumerCount();

    @Attribute(desc="Whether this server is started")
    public boolean isStarted();

    @Attribute(desc="List of interceptors used by this server for incoming messages")
    public String[] getIncomingInterceptorClassNames();

    @Attribute(desc="List of interceptors used by this server for outgoing messages")
    public String[] getOutgoingInterceptorClassNames();

    @Attribute(desc="Whether this server is clustered")
    public boolean isClustered();

    @Attribute(desc="Maximum number of threads in the scheduled thread pool")
    public int getScheduledThreadPoolMaxSize();

    @Attribute(desc="Maximum number of threads in the thread pool")
    public int getThreadPoolMaxSize();

    @Attribute(desc="Interval time (in milliseconds) to invalidate security credentials")
    public long getSecurityInvalidationInterval();

    @Attribute(desc="Whether security is enabled for this server")
    public boolean isSecurityEnabled();

    @Attribute(desc="File system directory used to store bindings")
    public String getBindingsDirectory();

    @Attribute(desc="File system directory used to store journal log")
    public String getJournalDirectory();

    @Attribute(desc="Type of journal used by this server")
    public String getJournalType();

    @Attribute(desc="Whether the journal is synchronized when receiving transactional data")
    public boolean isJournalSyncTransactional();

    @Attribute(desc="Whether the journal is synchronized when receiving non-transactional datar")
    public boolean isJournalSyncNonTransactional();

    @Attribute(desc="Size (in bytes) of each journal files")
    public int getJournalFileSize();

    @Attribute(desc="Number of journal files to pre-create")
    public int getJournalMinFiles();

    @Attribute(desc="Maximum number of write requests that can be in the AIO queue at any given time")
    public int getJournalMaxIO();

    @Attribute(desc="Size of the internal buffer on the journal")
    public int getJournalBufferSize();

    @Attribute(desc="Number of files that would be acceptable to keep on a pool")
    public int getJournalPoolFiles();

    @Attribute(desc="Timeout (in nanoseconds) used to flush internal buffers on the journal")
    public int getJournalBufferTimeout();

    @Attribute(desc="If clients failover on a server shutdown")
    public void setFailoverOnServerShutdown(boolean var1) throws Exception;

    @Attribute(desc="If clients failover on a server shutdown")
    public boolean isFailoverOnServerShutdown();

    @Attribute(desc="Minimal number of journal files before compacting")
    public int getJournalCompactMinFiles();

    @Attribute(desc="Percentage of live data before compacting the journal")
    public int getJournalCompactPercentage();

    @Attribute(desc="Whether this server is using persistence and store data")
    public boolean isPersistenceEnabled();

    @Attribute(desc="Whether the bindings directory is created on this server startup")
    public boolean isCreateBindingsDir();

    @Attribute(desc="Whether the journal directory is created on this server startup")
    public boolean isCreateJournalDir();

    @Attribute(desc="Whether message counter is enabled for this server")
    public boolean isMessageCounterEnabled();

    @Attribute(desc="Maximum number of days kept in memory for message counter")
    public int getMessageCounterMaxDayCount();

    @Attribute(desc="Maximum number of days kept in memory for message counter")
    public void setMessageCounterMaxDayCount(int var1) throws Exception;

    @Attribute(desc="Sample period (in milliseconds) to take message counter snapshot")
    public long getMessageCounterSamplePeriod();

    @Attribute(desc="Sample period to take message counter snapshot")
    public void setMessageCounterSamplePeriod(long var1) throws Exception;

    @Attribute(desc="Whether this server is a backup")
    public boolean isBackup();

    @Attribute(desc="Whether this server shares its data store with a corresponding live or backup serve")
    public boolean isSharedStore();

    @Attribute(desc="File system directory used to store paging files")
    public String getPagingDirectory();

    @Attribute(desc="Whether delivery count is persisted before messages are delivered to the consumers")
    public boolean isPersistDeliveryCountBeforeDelivery();

    @Attribute(desc="Connection time to live")
    public long getConnectionTTLOverride();

    @Attribute(desc="Management address of this server")
    public String getManagementAddress();

    @Attribute(desc="Node ID of this server")
    public String getNodeID();

    @Attribute(desc="Activation sequence of this server instance")
    public long getActivationSequence();

    @Attribute(desc="Management notification address of this server")
    public String getManagementNotificationAddress();

    @Attribute(desc="Size of the cache for pre-creating message IDs")
    public int getIDCacheSize();

    @Attribute(desc="Whether message ID cache is persisted")
    public boolean isPersistIDCache();

    @Attribute(desc="File system directory used to store large messages")
    public String getLargeMessagesDirectory();

    @Attribute(desc="Whether wildcard routing is supported by this server")
    public boolean isWildcardRoutingEnabled();

    @Attribute(desc="Timeout (in milliseconds) after which transactions is removed from the resource manager after it was created")
    public long getTransactionTimeout();

    @Attribute(desc="Frequency (in milliseconds)  to scan transactions to detect which transactions have timed out")
    public long getTransactionTimeoutScanPeriod();

    @Attribute(desc="Frequency (in milliseconds)  to scan messages to detect which messages have expired")
    public long getMessageExpiryScanPeriod();

    @Attribute(desc="Priority of the thread used to scan message expiration")
    @Deprecated
    public long getMessageExpiryThreadPriority();

    @Attribute(desc="Whether code coming from connection is executed asynchronously or not")
    public boolean isAsyncConnectionExecutionEnabled();

    @Attribute(desc="Connectors configured for this server")
    public Object[] getConnectors() throws Exception;

    @Attribute(desc="Connectors configured for this server using JSON serialization")
    public String getConnectorsAsJSON() throws Exception;

    @Attribute(desc="Connectors configured for this server")
    public Object[] getAcceptors() throws Exception;

    @Attribute(desc="Acceptors configured for this server using JSON serialization")
    public String getAcceptorsAsJSON() throws Exception;

    @Attribute(desc="Number of addresses created on this server")
    public int getAddressCount();

    @Attribute(desc="Names of the addresses created on this server")
    public String[] getAddressNames();

    @Attribute(desc="Number of queues created on this server")
    public int getQueueCount();

    @Attribute(desc="Names of the queues created on this server")
    public String[] getQueueNames();

    @Attribute(desc="Uptime of this server")
    public String getUptime();

    @Attribute(desc="Uptime of this server in milliseconds")
    public long getUptimeMillis();

    @Attribute(desc="Whether the initial replication synchronization process with the backup server is complete")
    public boolean isReplicaSync();

    @Attribute(desc="How often to check for disk space usage, in milliseconds")
    public int getDiskScanPeriod();

    @Attribute(desc="Maximum limit for disk use, in percentage")
    public int getMaxDiskUsage();

    @Attribute(desc="Global maximum limit for in-memory messages, in bytes")
    public long getGlobalMaxSize();

    @Attribute(desc="Memory used by all the addresses on broker for in-memory messages")
    public long getAddressMemoryUsage();

    @Attribute(desc="Fraction of total disk store used")
    public double getDiskStoreUsage();

    @Attribute(desc="Memory used by all the addresses on broker as a percentage of the global-max-size")
    public int getAddressMemoryUsagePercentage();

    @Attribute(desc="Returns the HA Policy of this broker as a String")
    public String getHAPolicy();

    @Attribute(desc="The runtime size of the authentication cache")
    public long getAuthenticationCacheSize();

    @Attribute(desc="The runtime size of the authorization cache")
    public long getAuthorizationCacheSize();

    @Operation(desc="Isolate the broker", impact=1)
    public boolean freezeReplication();

    @Operation(desc="Create an address", impact=1)
    public String createAddress(@Parameter(name="name", desc="The name of the address") String var1, @Parameter(name="routingTypes", desc="Comma separated list of Routing Types (ANYCAST/MULTICAST)") String var2) throws Exception;

    @Operation(desc="Update an address", impact=1)
    public String updateAddress(@Parameter(name="name", desc="The name of the address") String var1, @Parameter(name="routingTypes", desc="Comma separated list of Routing Types (ANYCAST/MULTICAST)") String var2) throws Exception;

    @Operation(desc="Delete an address", impact=1)
    public void deleteAddress(@Parameter(name="name", desc="The name of the address") String var1) throws Exception;

    @Operation(desc="Delete an address", impact=1)
    public void deleteAddress(@Parameter(name="name", desc="The name of the address") String var1, @Parameter(name="force", desc="Force consumers and queues out") boolean var2) throws Exception;

    @Deprecated
    @Operation(desc="Create a queue with the specified address", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2) throws Exception;

    @Deprecated
    @Operation(desc="Create a queue with the specified address", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var3) throws Exception;

    @Deprecated
    @Operation(desc="Create a queue with the specified address, name and durability", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="durable", desc="Is the queue durable?") boolean var3) throws Exception;

    @Deprecated
    @Operation(desc="Create a queue with the specified address, name and durability", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="durable", desc="Is the queue durable?") boolean var3, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var4) throws Exception;

    @Deprecated
    @Operation(desc="Create a queue", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="filter", desc="Filter of the queue") String var3, @Parameter(name="durable", desc="Is the queue durable?") boolean var4) throws Exception;

    @Deprecated
    @Operation(desc="Create a queue", impact=1)
    public void createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="filter", desc="Filter of the queue") String var3, @Parameter(name="durable", desc="Is the queue durable?") boolean var4, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var5) throws Exception;

    @Deprecated
    @Operation(desc="Create a queue", impact=1)
    public String createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var2, @Parameter(name="name", desc="Name of the queue") String var3, @Parameter(name="filter", desc="Filter of the queue") String var4, @Parameter(name="durable", desc="Is the queue durable?") boolean var5, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") int var6, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") boolean var7, @Parameter(name="exclusive", desc="If the queue should route exclusively to one consumer") boolean var8, @Parameter(name="groupRebalance", desc="If the queue should rebalance groups when a consumer is added") boolean var9, @Parameter(name="groupBuckets", desc="Number of buckets that should be used for message groups, -1 (default) is unlimited, and groups by raw key instead") int var10, @Parameter(name="lastValue", desc="Use last-value semantics") boolean var11, @Parameter(name="lastValueKey", desc="Use the specified property key for the last value") String var12, @Parameter(name="nonDestructive", desc="If the queue is non-destructive") boolean var13, @Parameter(name="consumersBeforeDispatch", desc="Number of consumers needed before dispatch can start") int var14, @Parameter(name="delayBeforeDispatch", desc="Delay to wait before dispatching if number of consumers before dispatch is not met") long var15, @Parameter(name="autoCreateAddress", desc="Create an address with default values should a matching address not be found") boolean var17) throws Exception;

    @Deprecated
    @Operation(desc="Create a queue", impact=1)
    public String createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var2, @Parameter(name="name", desc="Name of the queue") String var3, @Parameter(name="filter", desc="Filter of the queue") String var4, @Parameter(name="durable", desc="Is the queue durable?") boolean var5, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") int var6, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") boolean var7, @Parameter(name="exclusive", desc="If the queue should route exclusively to one consumer") boolean var8, @Parameter(name="groupRebalance", desc="If the queue should rebalance groups when a consumer is added") boolean var9, @Parameter(name="groupBuckets", desc="Number of buckets that should be used for message groups, -1 (default) is unlimited, and groups by raw key instead") int var10, @Parameter(name="lastValue", desc="Use last-value semantics") boolean var11, @Parameter(name="lastValueKey", desc="Use the specified property key for the last value") String var12, @Parameter(name="nonDestructive", desc="If the queue is non-destructive") boolean var13, @Parameter(name="consumersBeforeDispatch", desc="Number of consumers needed before dispatch can start") int var14, @Parameter(name="delayBeforeDispatch", desc="Delay to wait before dispatching if number of consumers before dispatch is not met") long var15, @Parameter(name="autoDelete", desc="If the queue should be deleted once no consumers") boolean var17, @Parameter(name="autoDeleteDelay", desc="How long to wait (in milliseconds) before deleting auto-created queues after the queue has 0 consumers") long var18, @Parameter(name="autoDeleteMessageCount", desc="The message count the queue must be at or below before it can be evaluated to be auto deleted, 0 waits until empty queue (default) and -1 disables this check") long var20, @Parameter(name="autoCreateAddress", desc="Create an address with default values should a matching address not be found") boolean var22) throws Exception;

    @Deprecated
    @Operation(desc="Create a queue", impact=1)
    public String createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var2, @Parameter(name="name", desc="Name of the queue") String var3, @Parameter(name="filter", desc="Filter of the queue") String var4, @Parameter(name="durable", desc="Is the queue durable?") boolean var5, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") int var6, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") boolean var7, @Parameter(name="exclusive", desc="If the queue should route exclusively to one consumer") boolean var8, @Parameter(name="groupRebalance", desc="If the queue should rebalance groups when a consumer is added") boolean var9, @Parameter(name="groupBuckets", desc="Number of buckets that should be used for message groups, -1 (default) is unlimited, and groups by raw key instead") int var10, @Parameter(name="groupFirstKey", desc="Key used to mark a message is first in a group for a consumer") String var11, @Parameter(name="lastValue", desc="Use last-value semantics") boolean var12, @Parameter(name="lastValueKey", desc="Use the specified property key for the last value") String var13, @Parameter(name="nonDestructive", desc="If the queue is non-destructive") boolean var14, @Parameter(name="consumersBeforeDispatch", desc="Number of consumers needed before dispatch can start") int var15, @Parameter(name="delayBeforeDispatch", desc="Delay to wait before dispatching if number of consumers before dispatch is not met") long var16, @Parameter(name="autoDelete", desc="If the queue should be deleted once no consumers") boolean var18, @Parameter(name="autoDeleteDelay", desc="How long to wait (in milliseconds) before deleting auto-created queues after the queue has 0 consumers") long var19, @Parameter(name="autoDeleteMessageCount", desc="The message count the queue must be at or below before it can be evaluated to be auto deleted, 0 waits until empty queue (default) and -1 disables this check") long var21, @Parameter(name="autoCreateAddress", desc="Create an address with default values should a matching address not be found") boolean var23) throws Exception;

    @Deprecated
    @Operation(desc="Create a queue", impact=1)
    public String createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var2, @Parameter(name="name", desc="Name of the queue") String var3, @Parameter(name="filter", desc="Filter of the queue") String var4, @Parameter(name="durable", desc="Is the queue durable?") boolean var5, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") int var6, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") boolean var7, @Parameter(name="exclusive", desc="If the queue should route exclusively to one consumer") boolean var8, @Parameter(name="groupRebalance", desc="If the queue should rebalance groups when a consumer is added") boolean var9, @Parameter(name="groupBuckets", desc="Number of buckets that should be used for message groups, -1 (default) is unlimited, and groups by raw key instead") int var10, @Parameter(name="groupFirstKey", desc="Key used to mark a message is first in a group for a consumer") String var11, @Parameter(name="lastValue", desc="Use last-value semantics") boolean var12, @Parameter(name="lastValueKey", desc="Use the specified property key for the last value") String var13, @Parameter(name="nonDestructive", desc="If the queue is non-destructive") boolean var14, @Parameter(name="consumersBeforeDispatch", desc="Number of consumers needed before dispatch can start") int var15, @Parameter(name="delayBeforeDispatch", desc="Delay to wait before dispatching if number of consumers before dispatch is not met") long var16, @Parameter(name="autoDelete", desc="If the queue should be deleted once no consumers") boolean var18, @Parameter(name="autoDeleteDelay", desc="How long to wait (in milliseconds) before deleting auto-created queues after the queue has 0 consumers") long var19, @Parameter(name="autoDeleteMessageCount", desc="The message count the queue must be at or below before it can be evaluated to be auto deleted, 0 waits until empty queue (default) and -1 disables this check") long var21, @Parameter(name="autoCreateAddress", desc="Create an address with default values should a matching address not be found") boolean var23, @Parameter(name="ringSize", desc="The size this queue should maintain according to ring semantics") long var24) throws Exception;

    @Deprecated
    @Operation(desc="Create a queue", impact=1)
    public String createQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var2, @Parameter(name="name", desc="Name of the queue") String var3, @Parameter(name="filter", desc="Filter of the queue") String var4, @Parameter(name="durable", desc="Is the queue durable?") boolean var5, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") int var6, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") boolean var7, @Parameter(name="autoCreateAddress", desc="Create an address with default values should a matching address not be found") boolean var8) throws Exception;

    @Operation(desc="Create a queue", impact=1)
    public String createQueue(@Parameter(name="queueConfiguration", desc="the configuration of the queue in JSON format") String var1) throws Exception;

    @Operation(desc="Create a queue", impact=1)
    public String createQueue(@Parameter(name="queueConfiguration", desc="the configuration of the queue in JSON format") String var1, @Parameter(name="ignoreIfExists", desc="whether or not to try to create the queue if it exists already") boolean var2) throws Exception;

    @Operation(desc="Update a queue", impact=1)
    public String updateQueue(@Parameter(name="queueConfiguration", desc="the configuration of the queue in JSON format") String var1) throws Exception;

    @Deprecated
    @Operation(desc="Update a queue", impact=1)
    public String updateQueue(@Parameter(name="name", desc="Name of the queue") String var1, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var2, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") Integer var3, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") Boolean var4) throws Exception;

    @Deprecated
    @Operation(desc="Update a queue", impact=1)
    public String updateQueue(@Parameter(name="name", desc="Name of the queue") String var1, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var2, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") Integer var3, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") Boolean var4, @Parameter(name="exclusive", desc="If the queue should route exclusively to one consumer") Boolean var5) throws Exception;

    @Deprecated
    @Operation(desc="Update a queue", impact=1)
    public String updateQueue(@Parameter(name="name", desc="Name of the queue") String var1, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var2, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") Integer var3, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") Boolean var4, @Parameter(name="exclusive", desc="If the queue should route exclusively to one consumer") Boolean var5, @Parameter(name="user", desc="The user associated with this queue") String var6) throws Exception;

    @Deprecated
    @Operation(desc="Update a queue", impact=1)
    public String updateQueue(@Parameter(name="name", desc="Name of the queue") String var1, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var2, @Parameter(name="filter", desc="The filter to use on the queue") String var3, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") Integer var4, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") Boolean var5, @Parameter(name="exclusive", desc="If the queue should route exclusively to one consumer") Boolean var6, @Parameter(name="groupRebalance", desc="If the queue should rebalance groups when a consumer is added") Boolean var7, @Parameter(name="groupBuckets", desc="Number of buckets that should be used for message groups, -1 (default) is unlimited, and groups by raw key instead") Integer var8, @Parameter(name="nonDestructive", desc="If the queue is non-destructive") Boolean var9, @Parameter(name="consumersBeforeDispatch", desc="Number of consumers needed before dispatch can start") Integer var10, @Parameter(name="delayBeforeDispatch", desc="Delay to wait before dispatching if number of consumers before dispatch is not met") Long var11, @Parameter(name="user", desc="The user associated with this queue") String var12) throws Exception;

    @Deprecated
    @Operation(desc="Update a queue", impact=1)
    public String updateQueue(@Parameter(name="name", desc="Name of the queue") String var1, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var2, @Parameter(name="filter", desc="The filter to use on the queue") String var3, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") Integer var4, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") Boolean var5, @Parameter(name="exclusive", desc="If the queue should route exclusively to one consumer") Boolean var6, @Parameter(name="groupRebalance", desc="If the queue should rebalance groups when a consumer is added") Boolean var7, @Parameter(name="groupBuckets", desc="Number of buckets that should be used for message groups, -1 (default) is unlimited, and groups by raw key instead") Integer var8, @Parameter(name="groupFirstKey", desc="Key used to mark a message is first in a group for a consumer") String var9, @Parameter(name="nonDestructive", desc="If the queue is non-destructive") Boolean var10, @Parameter(name="consumersBeforeDispatch", desc="Number of consumers needed before dispatch can start") Integer var11, @Parameter(name="delayBeforeDispatch", desc="Delay to wait before dispatching if number of consumers before dispatch is not met") Long var12, @Parameter(name="user", desc="The user associated with this queue") String var13) throws Exception;

    @Deprecated
    @Operation(desc="Update a queue", impact=1)
    public String updateQueue(@Parameter(name="name", desc="Name of the queue") String var1, @Parameter(name="routingType", desc="The routing type used for this address, MULTICAST or ANYCAST") String var2, @Parameter(name="filter", desc="The filter to use on the queue") String var3, @Parameter(name="maxConsumers", desc="The maximum number of consumers allowed on this queue at any one time") Integer var4, @Parameter(name="purgeOnNoConsumers", desc="Delete this queue when the last consumer disconnects") Boolean var5, @Parameter(name="exclusive", desc="If the queue should route exclusively to one consumer") Boolean var6, @Parameter(name="groupRebalance", desc="If the queue should rebalance groups when a consumer is added") Boolean var7, @Parameter(name="groupBuckets", desc="Number of buckets that should be used for message groups, -1 (default) is unlimited, and groups by raw key instead") Integer var8, @Parameter(name="groupFirstKey", desc="Key used to mark a message is first in a group for a consumer") String var9, @Parameter(name="nonDestructive", desc="If the queue is non-destructive") Boolean var10, @Parameter(name="consumersBeforeDispatch", desc="Number of consumers needed before dispatch can start") Integer var11, @Parameter(name="delayBeforeDispatch", desc="Delay to wait before dispatching if number of consumers before dispatch is not met") Long var12, @Parameter(name="user", desc="The user associated with this queue") String var13, @Parameter(name="ringSize", desc="the size this queue should maintain according to ring semantics") Long var14) throws Exception;

    @Deprecated
    @Operation(desc="Deploy a queue", impact=1)
    public void deployQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="filter", desc="Filter of the queue") String var3) throws Exception;

    @Deprecated
    @Operation(desc="Deploy a queue", impact=1)
    public void deployQueue(@Parameter(name="address", desc="Address of the queue") String var1, @Parameter(name="name", desc="Name of the queue") String var2, @Parameter(name="filter", desc="Filter of the queue") String var3, @Parameter(name="durable", desc="Is the queue durable?") boolean var4) throws Exception;

    @Operation(desc="Destroy a queue", impact=1)
    public void destroyQueue(@Parameter(name="name", desc="Name of the queue to destroy") String var1) throws Exception;

    @Operation(desc="Destroy a queue", impact=1)
    public void destroyQueue(@Parameter(name="name", desc="Name of the queue to destroy") String var1, @Parameter(name="removeConsumers", desc="Remove consumers of this queue") boolean var2) throws Exception;

    @Operation(desc="Destroy a queue", impact=1)
    public void destroyQueue(@Parameter(name="name", desc="Name of the queue to destroy") String var1, @Parameter(name="removeConsumers", desc="Remove consumers of this queue") boolean var2, @Parameter(name="forceAutoDeleteAddress", desc="Automatically delete the address if this was the last queue") boolean var3) throws Exception;

    @Operation(desc="Enable message counters", impact=1)
    public void enableMessageCounters() throws Exception;

    @Operation(desc="Disable message counters", impact=1)
    public void disableMessageCounters() throws Exception;

    @Operation(desc="Reset all message counters", impact=1)
    public void resetAllMessageCounters() throws Exception;

    @Operation(desc="Reset all message counters history", impact=1)
    public void resetAllMessageCounterHistories() throws Exception;

    @Operation(desc="List all the prepared transaction, sorted by date, oldest first")
    public String[] listPreparedTransactions() throws Exception;

    @Operation(desc="List all the prepared transaction, sorted by date, oldest first, with details, in JSON format")
    public String listPreparedTransactionDetailsAsJSON() throws Exception;

    @Deprecated
    @Operation(desc="List all the prepared transaction, sorted by date, oldest first, with details, in HTML format")
    public String listPreparedTransactionDetailsAsHTML() throws Exception;

    @Operation(desc="List transactions which have been heuristically committed")
    public String[] listHeuristicCommittedTransactions() throws Exception;

    @Operation(desc="List transactions which have been heuristically rolled back")
    public String[] listHeuristicRolledBackTransactions() throws Exception;

    @Operation(desc="Commit a prepared transaction")
    public boolean commitPreparedTransaction(@Parameter(desc="the Base64 representation of a transaction", name="transactionAsBase64") String var1) throws Exception;

    @Operation(desc="Rollback a prepared transaction")
    public boolean rollbackPreparedTransaction(@Parameter(desc="the Base64 representation of a transaction", name="transactionAsBase64") String var1) throws Exception;

    @Operation(desc="List the client addresses", impact=0)
    public String[] listRemoteAddresses() throws Exception;

    @Operation(desc="List the client addresses which match the given IP Address", impact=0)
    public String[] listRemoteAddresses(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="Closes all the connections for the given IP Address", impact=0)
    public boolean closeConnectionsForAddress(@Parameter(desc="an IP address", name="ipAddress") String var1) throws Exception;

    @Operation(desc="Closes all the consumer connections for the given messaging address", impact=0)
    public boolean closeConsumerConnectionsForAddress(@Parameter(desc="a messaging address", name="address") String var1) throws Exception;

    @Operation(desc="Closes all the connections for sessions with the given user name", impact=0)
    public boolean closeConnectionsForUser(@Parameter(desc="a user name", name="userName") String var1) throws Exception;

    @Operation(desc="Closes all the connection with the id", impact=0)
    public boolean closeConnectionWithID(@Parameter(desc="The connection ID", name="ID") String var1) throws Exception;

    @Operation(desc="Closes the session with the id", impact=0)
    public boolean closeSessionWithID(@Parameter(desc="The connection ID", name="connectionID") String var1, @Parameter(desc="The session ID", name="ID") String var2) throws Exception;

    @Operation(desc="Closes the consumer with the id", impact=0)
    public boolean closeConsumerWithID(@Parameter(desc="The session ID", name="sessionID") String var1, @Parameter(desc="The consumer ID", name="ID") String var2) throws Exception;

    @Operation(desc="List all the connection IDs", impact=0)
    public String[] listConnectionIDs() throws Exception;

    @Operation(desc="List all producers", impact=0)
    public String listProducersInfoAsJSON() throws Exception;

    @Operation(desc="List all connections as a JSON string")
    public String listConnectionsAsJSON() throws Exception;

    @Operation(desc="List all consumers associated with a connection as a JSON string")
    public String listConsumersAsJSON(@Parameter(desc="a connection ID", name="connectionID") String var1) throws Exception;

    @Operation(desc="List all consumers as a JSON string")
    public String listAllConsumersAsJSON() throws Exception;

    @Operation(desc="List the sessions for the given connectionID as a JSON string", impact=0)
    public String listSessionsAsJSON(@Parameter(desc="a connection ID", name="connectionID") String var1) throws Exception;

    @Operation(desc="List all sessions as a JSON string", impact=0)
    public String listAllSessionsAsJSON() throws Exception;

    @Operation(desc="List the sessions for the given connectionID", impact=0)
    public String[] listSessions(@Parameter(desc="a connection ID", name="connectionID") String var1) throws Exception;

    @Operation(desc="Add security settings for addresses matching the addressMatch", impact=1)
    public void addSecuritySettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="a comma-separated list of roles allowed to send messages", name="send") String var2, @Parameter(desc="a comma-separated list of roles allowed to consume messages", name="consume") String var3, @Parameter(desc="a comma-separated list of roles allowed to create durable queues", name="createDurableQueueRoles") String var4, @Parameter(desc="a comma-separated list of roles allowed to delete durable queues", name="deleteDurableQueueRoles") String var5, @Parameter(desc="a comma-separated list of roles allowed to create non durable queues", name="createNonDurableQueueRoles") String var6, @Parameter(desc="a comma-separated list of roles allowed to delete non durable queues", name="deleteNonDurableQueueRoles") String var7, @Parameter(desc="a comma-separated list of roles allowed to send management messages messages", name="manage") String var8) throws Exception;

    @Operation(desc="Add security settings for addresses matching the addressMatch", impact=1)
    public void addSecuritySettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="a comma-separated list of roles allowed to send messages", name="send") String var2, @Parameter(desc="a comma-separated list of roles allowed to consume messages", name="consume") String var3, @Parameter(desc="a comma-separated list of roles allowed to create durable queues", name="createDurableQueueRoles") String var4, @Parameter(desc="a comma-separated list of roles allowed to delete durable queues", name="deleteDurableQueueRoles") String var5, @Parameter(desc="a comma-separated list of roles allowed to create non durable queues", name="createNonDurableQueueRoles") String var6, @Parameter(desc="a comma-separated list of roles allowed to delete non durable queues", name="deleteNonDurableQueueRoles") String var7, @Parameter(desc="a comma-separated list of roles allowed to send management messages messages", name="manage") String var8, @Parameter(desc="a comma-separated list of roles allowed to browse queues", name="browse") String var9) throws Exception;

    @Operation(desc="Add security settings for addresses matching the addressMatch", impact=1)
    public void addSecuritySettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="a comma-separated list of roles allowed to send messages", name="send") String var2, @Parameter(desc="a comma-separated list of roles allowed to consume messages", name="consume") String var3, @Parameter(desc="a comma-separated list of roles allowed to create durable queues", name="createDurableQueueRoles") String var4, @Parameter(desc="a comma-separated list of roles allowed to delete durable queues", name="deleteDurableQueueRoles") String var5, @Parameter(desc="a comma-separated list of roles allowed to create non durable queues", name="createNonDurableQueueRoles") String var6, @Parameter(desc="a comma-separated list of roles allowed to delete non durable queues", name="deleteNonDurableQueueRoles") String var7, @Parameter(desc="a comma-separated list of roles allowed to send management messages messages", name="manage") String var8, @Parameter(desc="a comma-separated list of roles allowed to browse queues", name="browse") String var9, @Parameter(desc="a comma-separated list of roles allowed to create addresses", name="createAddressRoles") String var10, @Parameter(desc="a comma-separated list of roles allowed to delete addresses", name="deleteAddressRoles") String var11) throws Exception;

    @Operation(desc="Remove security settings for an address", impact=1)
    public void removeSecuritySettings(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Operation(desc="Get roles for a specific address match", impact=0)
    public Object[] getRoles(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Operation(desc="Get roles (as a JSON string) for a specific address match", impact=0)
    public String getRolesAsJSON(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Operation(desc="Add address settings for addresses matching the addressMatch", impact=1)
    public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="the dead letter address setting", name="DLA") String var2, @Parameter(desc="the expiry address setting", name="expiryAddress") String var3, @Parameter(desc="the expiry delay setting", name="expiryDelay") long var4, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean var6, @Parameter(desc="the delivery attempts", name="deliveryAttempts") int var7, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long var8, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int var10, @Parameter(desc="the max number of pages in the soft memory cache", name="pageMaxCacheSize") int var11, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long var12, @Parameter(desc="the redelivery delay multiplier", name="redeliveryMultiplier") double var14, @Parameter(desc="the maximum redelivery delay", name="maxRedeliveryDelay") long var16, @Parameter(desc="the redistribution delay", name="redistributionDelay") long var18, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean var20, @Parameter(desc="the policy to use when the address is full", name="addressFullMessagePolicy") String var21, @Parameter(desc="when a consumer falls below this threshold in terms of messages consumed per second it will be considered 'slow'", name="slowConsumerThreshold") long var22, @Parameter(desc="how often (in seconds) to check for slow consumers", name="slowConsumerCheckPeriod") long var24, @Parameter(desc="the policy to use when a slow consumer is detected", name="slowConsumerPolicy") String var26, @Parameter(desc="allow queues to be created automatically", name="autoCreateJmsQueues") boolean var27, @Parameter(desc="allow auto-created queues to be deleted automatically", name="autoDeleteJmsQueues") boolean var28, @Parameter(desc="allow topics to be created automatically", name="autoCreateJmsTopics") boolean var29, @Parameter(desc="allow auto-created topics to be deleted automatically", name="autoDeleteJmsTopics") boolean var30) throws Exception;

    @Operation(desc="Add address settings for addresses matching the addressMatch", impact=1)
    public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="the dead letter address setting", name="DLA") String var2, @Parameter(desc="the expiry address setting", name="expiryAddress") String var3, @Parameter(desc="the expiry delay setting", name="expiryDelay") long var4, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean var6, @Parameter(desc="the delivery attempts", name="deliveryAttempts") int var7, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long var8, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int var10, @Parameter(desc="the max number of pages in the soft memory cache", name="pageMaxCacheSize") int var11, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long var12, @Parameter(desc="the redelivery delay multiplier", name="redeliveryMultiplier") double var14, @Parameter(desc="the maximum redelivery delay", name="maxRedeliveryDelay") long var16, @Parameter(desc="the redistribution delay", name="redistributionDelay") long var18, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean var20, @Parameter(desc="the policy to use when the address is full", name="addressFullMessagePolicy") String var21, @Parameter(desc="when a consumer falls below this threshold in terms of messages consumed per second it will be considered 'slow'", name="slowConsumerThreshold") long var22, @Parameter(desc="how often (in seconds) to check for slow consumers", name="slowConsumerCheckPeriod") long var24, @Parameter(desc="the policy to use when a slow consumer is detected", name="slowConsumerPolicy") String var26, @Parameter(desc="allow jms queues to be created automatically", name="autoCreateJmsQueues") boolean var27, @Parameter(desc="allow auto-created jms queues to be deleted automatically", name="autoDeleteJmsQueues") boolean var28, @Parameter(desc="allow jms topics to be created automatically", name="autoCreateJmsTopics") boolean var29, @Parameter(desc="allow auto-created jms topics to be deleted automatically", name="autoDeleteJmsTopics") boolean var30, @Parameter(desc="allow queues to be created automatically", name="autoCreateQueues") boolean var31, @Parameter(desc="allow auto-created queues to be deleted automatically", name="autoDeleteQueues") boolean var32, @Parameter(desc="allow addresses to be created automatically", name="autoCreateAddresses") boolean var33, @Parameter(desc="allow auto-created addresses to be deleted automatically", name="autoDeleteAddresses") boolean var34) throws Exception;

    @Operation(desc="Add address settings for addresses matching the addressMatch", impact=1)
    public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="the dead letter address setting", name="DLA") String var2, @Parameter(desc="the expiry address setting", name="expiryAddress") String var3, @Parameter(desc="the expiry delay setting", name="expiryDelay") long var4, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean var6, @Parameter(desc="the delivery attempts", name="deliveryAttempts") int var7, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long var8, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int var10, @Parameter(desc="the max number of pages in the soft memory cache", name="pageMaxCacheSize") int var11, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long var12, @Parameter(desc="the redelivery delay multiplier", name="redeliveryMultiplier") double var14, @Parameter(desc="the maximum redelivery delay", name="maxRedeliveryDelay") long var16, @Parameter(desc="the redistribution delay", name="redistributionDelay") long var18, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean var20, @Parameter(desc="the policy to use when the address is full", name="addressFullMessagePolicy") String var21, @Parameter(desc="when a consumer falls below this threshold in terms of messages consumed per second it will be considered 'slow'", name="slowConsumerThreshold") long var22, @Parameter(desc="how often (in seconds) to check for slow consumers", name="slowConsumerCheckPeriod") long var24, @Parameter(desc="the policy to use when a slow consumer is detected", name="slowConsumerPolicy") String var26, @Parameter(desc="allow jms queues to be created automatically", name="autoCreateJmsQueues") boolean var27, @Parameter(desc="allow auto-created jms queues to be deleted automatically", name="autoDeleteJmsQueues") boolean var28, @Parameter(desc="allow jms topics to be created automatically", name="autoCreateJmsTopics") boolean var29, @Parameter(desc="allow auto-created jms topics to be deleted automatically", name="autoDeleteJmsTopics") boolean var30, @Parameter(desc="allow queues to be created automatically", name="autoCreateQueues") boolean var31, @Parameter(desc="allow auto-created queues to be deleted automatically", name="autoDeleteQueues") boolean var32, @Parameter(desc="allow addresses to be created automatically", name="autoCreateAddresses") boolean var33, @Parameter(desc="allow auto-created addresses to be deleted automatically", name="autoDeleteAddresses") boolean var34, @Parameter(desc="how to deal with queues deleted from XML at runtime", name="configDeleteQueues") String var35, @Parameter(desc="how to deal with addresses deleted from XML at runtime", name="configDeleteAddresses") String var36, @Parameter(desc="used with `BLOCK`, the max size an address can reach before messages are rejected; works in combination with `max-size-bytes` for AMQP clients only", name="maxSizeBytesRejectThreshold") long var37, @Parameter(desc="last-value-key value if none is set on the queue", name="defaultLastValueKey") String var39, @Parameter(desc="non-destructive value if none is set on the queue", name="defaultNonDestructive") boolean var40, @Parameter(desc="exclusive value if none is set on the queue", name="defaultExclusiveQueue") boolean var41, @Parameter(desc="group-rebalance value if none is set on the queue", name="defaultGroupRebalance") boolean var42, @Parameter(desc="group-buckets value if none is set on the queue", name="defaultGroupBuckets") int var43, @Parameter(desc="group-first-key value if none is set on the queue", name="defaultGroupFirstKey") String var44, @Parameter(desc="max-consumers value if none is set on the queue", name="defaultMaxConsumers") int var45, @Parameter(desc="purge-on-no-consumers value if none is set on the queue", name="defaultPurgeOnNoConsumers") boolean var46, @Parameter(desc="consumers-before-dispatch value if none is set on the queue", name="defaultConsumersBeforeDispatch") int var47, @Parameter(desc="delay-before-dispatch value if none is set on the queue", name="defaultDelayBeforeDispatch") long var48, @Parameter(desc="routing-type value if none is set on the queue", name="defaultQueueRoutingType") String var50, @Parameter(desc="routing-type value if none is set on the address", name="defaultAddressRoutingType") String var51, @Parameter(desc="consumer-window-size value if none is set on the queue", name="defaultConsumerWindowSize") int var52, @Parameter(desc="ring-size value if none is set on the queue", name="defaultRingSize") long var53, @Parameter(desc="allow created queues to be deleted automatically", name="autoDeleteCreatedQueues") boolean var55, @Parameter(desc="delay for deleting auto-created queues", name="autoDeleteQueuesDelay") long var56, @Parameter(desc="the message count the queue must be at or below before it can be auto deleted", name="autoDeleteQueuesMessageCount") long var58, @Parameter(desc="delay for deleting auto-created addresses", name="autoDeleteAddressesDelay") long var60, @Parameter(desc="factor by which to modify the redelivery delay slightly to avoid collisions", name="redeliveryCollisionAvoidanceFactor") double var62, @Parameter(desc="the number of messages to preserve for future queues created on the matching address", name="retroactiveMessageCount") long var64) throws Exception;

    @Operation(desc="Add address settings for addresses matching the addressMatch", impact=1)
    public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="the dead letter address setting", name="DLA") String var2, @Parameter(desc="the expiry address setting", name="expiryAddress") String var3, @Parameter(desc="the expiry delay setting", name="expiryDelay") long var4, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean var6, @Parameter(desc="the delivery attempts", name="deliveryAttempts") int var7, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long var8, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int var10, @Parameter(desc="the max number of pages in the soft memory cache", name="pageMaxCacheSize") int var11, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long var12, @Parameter(desc="the redelivery delay multiplier", name="redeliveryMultiplier") double var14, @Parameter(desc="the maximum redelivery delay", name="maxRedeliveryDelay") long var16, @Parameter(desc="the redistribution delay", name="redistributionDelay") long var18, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean var20, @Parameter(desc="the policy to use when the address is full", name="addressFullMessagePolicy") String var21, @Parameter(desc="when a consumer falls below this threshold in terms of messages consumed per second it will be considered 'slow'", name="slowConsumerThreshold") long var22, @Parameter(desc="how often (in seconds) to check for slow consumers", name="slowConsumerCheckPeriod") long var24, @Parameter(desc="the policy to use when a slow consumer is detected", name="slowConsumerPolicy") String var26, @Parameter(desc="allow jms queues to be created automatically", name="autoCreateJmsQueues") boolean var27, @Parameter(desc="allow auto-created jms queues to be deleted automatically", name="autoDeleteJmsQueues") boolean var28, @Parameter(desc="allow jms topics to be created automatically", name="autoCreateJmsTopics") boolean var29, @Parameter(desc="allow auto-created jms topics to be deleted automatically", name="autoDeleteJmsTopics") boolean var30, @Parameter(desc="allow queues to be created automatically", name="autoCreateQueues") boolean var31, @Parameter(desc="allow auto-created queues to be deleted automatically", name="autoDeleteQueues") boolean var32, @Parameter(desc="allow addresses to be created automatically", name="autoCreateAddresses") boolean var33, @Parameter(desc="allow auto-created addresses to be deleted automatically", name="autoDeleteAddresses") boolean var34, @Parameter(desc="how to deal with queues deleted from XML at runtime", name="configDeleteQueues") String var35, @Parameter(desc="how to deal with addresses deleted from XML at runtime", name="configDeleteAddresses") String var36, @Parameter(desc="used with `BLOCK`, the max size an address can reach before messages are rejected; works in combination with `max-size-bytes` for AMQP clients only", name="maxSizeBytesRejectThreshold") long var37, @Parameter(desc="last-value-key value if none is set on the queue", name="defaultLastValueKey") String var39, @Parameter(desc="non-destructive value if none is set on the queue", name="defaultNonDestructive") boolean var40, @Parameter(desc="exclusive value if none is set on the queue", name="defaultExclusiveQueue") boolean var41, @Parameter(desc="group-rebalance value if none is set on the queue", name="defaultGroupRebalance") boolean var42, @Parameter(desc="group-buckets value if none is set on the queue", name="defaultGroupBuckets") int var43, @Parameter(desc="group-first-key value if none is set on the queue", name="defaultGroupFirstKey") String var44, @Parameter(desc="max-consumers value if none is set on the queue", name="defaultMaxConsumers") int var45, @Parameter(desc="purge-on-no-consumers value if none is set on the queue", name="defaultPurgeOnNoConsumers") boolean var46, @Parameter(desc="consumers-before-dispatch value if none is set on the queue", name="defaultConsumersBeforeDispatch") int var47, @Parameter(desc="delay-before-dispatch value if none is set on the queue", name="defaultDelayBeforeDispatch") long var48, @Parameter(desc="routing-type value if none is set on the queue", name="defaultQueueRoutingType") String var50, @Parameter(desc="routing-type value if none is set on the address", name="defaultAddressRoutingType") String var51, @Parameter(desc="consumer-window-size value if none is set on the queue", name="defaultConsumerWindowSize") int var52, @Parameter(desc="ring-size value if none is set on the queue", name="defaultRingSize") long var53, @Parameter(desc="allow created queues to be deleted automatically", name="autoDeleteCreatedQueues") boolean var55, @Parameter(desc="delay for deleting auto-created queues", name="autoDeleteQueuesDelay") long var56, @Parameter(desc="the message count the queue must be at or below before it can be auto deleted", name="autoDeleteQueuesMessageCount") long var58, @Parameter(desc="delay for deleting auto-created addresses", name="autoDeleteAddressesDelay") long var60, @Parameter(desc="factor by which to modify the redelivery delay slightly to avoid collisions", name="redeliveryCollisionAvoidanceFactor") double var62, @Parameter(desc="the number of messages to preserve for future queues created on the matching address", name="retroactiveMessageCount") long var64, @Parameter(desc="allow dead-letter address & queue to be created automatically", name="autoCreateDeadLetterResources") boolean var66, @Parameter(desc="prefix to use on auto-create dead-letter queue", name="deadLetterQueuePrefix") String var67, @Parameter(desc="suffix to use on auto-create dead-letter queue", name="deadLetterQueueSuffix") String var68, @Parameter(desc="allow expiry address & queue to be created automatically", name="autoCreateExpiryResources") boolean var69, @Parameter(desc="prefix to use on auto-create expiry queue", name="expiryQueuePrefix") String var70, @Parameter(desc="suffix to use on auto-create expiry queue", name="expiryQueueSuffix") String var71) throws Exception;

    @Operation(desc="Add address settings for addresses matching the addressMatch", impact=1)
    public void addAddressSettings(@Parameter(desc="an address match", name="addressMatch") String var1, @Parameter(desc="the dead letter address setting", name="DLA") String var2, @Parameter(desc="the expiry address setting", name="expiryAddress") String var3, @Parameter(desc="the expiry delay setting", name="expiryDelay") long var4, @Parameter(desc="are any queues created for this address a last value queue", name="lastValueQueue") boolean var6, @Parameter(desc="the delivery attempts", name="maxDeliveryAttempts") int var7, @Parameter(desc="the max size in bytes", name="maxSizeBytes") long var8, @Parameter(desc="the page size in bytes", name="pageSizeBytes") int var10, @Parameter(desc="the max number of pages in the soft memory cache", name="pageCacheMaxSize") int var11, @Parameter(desc="the redelivery delay", name="redeliveryDelay") long var12, @Parameter(desc="the redelivery delay multiplier", name="redeliveryMultiplier") double var14, @Parameter(desc="the maximum redelivery delay", name="maxRedeliveryDelay") long var16, @Parameter(desc="the redistribution delay", name="redistributionDelay") long var18, @Parameter(desc="do we send to the DLA when there is no where to route the message", name="sendToDLAOnNoRoute") boolean var20, @Parameter(desc="the policy to use when the address is full", name="addressFullMessagePolicy") String var21, @Parameter(desc="when a consumer falls below this threshold in terms of messages consumed per second it will be considered 'slow'", name="slowConsumerThreshold") long var22, @Parameter(desc="how often (in seconds) to check for slow consumers", name="slowConsumerCheckPeriod") long var24, @Parameter(desc="the policy to use when a slow consumer is detected", name="slowConsumerPolicy") String var26, @Parameter(desc="allow jms queues to be created automatically", name="autoCreateJmsQueues") boolean var27, @Parameter(desc="allow auto-created jms queues to be deleted automatically", name="autoDeleteJmsQueues") boolean var28, @Parameter(desc="allow jms topics to be created automatically", name="autoCreateJmsTopics") boolean var29, @Parameter(desc="allow auto-created jms topics to be deleted automatically", name="autoDeleteJmsTopics") boolean var30, @Parameter(desc="allow queues to be created automatically", name="autoCreateQueues") boolean var31, @Parameter(desc="allow auto-created queues to be deleted automatically", name="autoDeleteQueues") boolean var32, @Parameter(desc="allow addresses to be created automatically", name="autoCreateAddresses") boolean var33, @Parameter(desc="allow auto-created addresses to be deleted automatically", name="autoDeleteAddresses") boolean var34, @Parameter(desc="how to deal with queues deleted from XML at runtime", name="configDeleteQueues") String var35, @Parameter(desc="how to deal with addresses deleted from XML at runtime", name="configDeleteAddresses") String var36, @Parameter(desc="used with `BLOCK`, the max size an address can reach before messages are rejected; works in combination with `max-size-bytes` for AMQP clients only", name="maxSizeBytesRejectThreshold") long var37, @Parameter(desc="last-value-key value if none is set on the queue", name="defaultLastValueKey") String var39, @Parameter(desc="non-destructive value if none is set on the queue", name="defaultNonDestructive") boolean var40, @Parameter(desc="exclusive value if none is set on the queue", name="defaultExclusiveQueue") boolean var41, @Parameter(desc="group-rebalance value if none is set on the queue", name="defaultGroupRebalance") boolean var42, @Parameter(desc="group-buckets value if none is set on the queue", name="defaultGroupBuckets") int var43, @Parameter(desc="group-first-key value if none is set on the queue", name="defaultGroupFirstKey") String var44, @Parameter(desc="max-consumers value if none is set on the queue", name="defaultMaxConsumers") int var45, @Parameter(desc="purge-on-no-consumers value if none is set on the queue", name="defaultPurgeOnNoConsumers") boolean var46, @Parameter(desc="consumers-before-dispatch value if none is set on the queue", name="defaultConsumersBeforeDispatch") int var47, @Parameter(desc="delay-before-dispatch value if none is set on the queue", name="defaultDelayBeforeDispatch") long var48, @Parameter(desc="routing-type value if none is set on the queue", name="defaultQueueRoutingType") String var50, @Parameter(desc="routing-type value if none is set on the address", name="defaultAddressRoutingType") String var51, @Parameter(desc="consumer-window-size value if none is set on the queue", name="defaultConsumerWindowSize") int var52, @Parameter(desc="ring-size value if none is set on the queue", name="defaultRingSize") long var53, @Parameter(desc="allow created queues to be deleted automatically", name="autoDeleteCreatedQueues") boolean var55, @Parameter(desc="delay for deleting auto-created queues", name="autoDeleteQueuesDelay") long var56, @Parameter(desc="the message count the queue must be at or below before it can be auto deleted", name="autoDeleteQueuesMessageCount") long var58, @Parameter(desc="delay for deleting auto-created addresses", name="autoDeleteAddressesDelay") long var60, @Parameter(desc="factor by which to modify the redelivery delay slightly to avoid collisions", name="redeliveryCollisionAvoidanceFactor") double var62, @Parameter(desc="the number of messages to preserve for future queues created on the matching address", name="retroactiveMessageCount") long var64, @Parameter(desc="allow dead-letter address & queue to be created automatically", name="autoCreateDeadLetterResources") boolean var66, @Parameter(desc="prefix to use on auto-create dead-letter queue", name="deadLetterQueuePrefix") String var67, @Parameter(desc="suffix to use on auto-create dead-letter queue", name="deadLetterQueueSuffix") String var68, @Parameter(desc="allow expiry address & queue to be created automatically", name="autoCreateExpiryResources") boolean var69, @Parameter(desc="prefix to use on auto-create expiry queue", name="expiryQueuePrefix") String var70, @Parameter(desc="suffix to use on auto-create expiry queue", name="expiryQueueSuffix") String var71, @Parameter(desc="the minimum expiry delay setting", name="minExpiryDelay") long var72, @Parameter(desc="the maximum expiry delay setting", name="maxExpiryDelay") long var74, @Parameter(desc="whether or not to enable metrics", name="enableMetrics") boolean var76) throws Exception;

    @Operation(desc="Remove address settings", impact=1)
    public void removeAddressSettings(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Operation(desc="Returns the address settings as a JSON string for an address match", impact=0)
    public String getAddressSettingsAsJSON(@Parameter(desc="an address match", name="addressMatch") String var1) throws Exception;

    @Attribute(desc="Names of the diverts deployed on this server")
    public String[] getDivertNames();

    @Operation(desc="names of the diverts deployed on this server", impact=0)
    default public String[] listDivertNames() {
        return this.getDivertNames();
    }

    @Operation(desc="Create a Divert", impact=1)
    public void createDivert(@Parameter(name="name", desc="Name of the divert") String var1, @Parameter(name="routingName", desc="Routing name of the divert") String var2, @Parameter(name="address", desc="Address to divert from") String var3, @Parameter(name="forwardingAddress", desc="Address to divert to") String var4, @Parameter(name="exclusive", desc="Is the divert exclusive?") boolean var5, @Parameter(name="filterString", desc="Filter of the divert") String var6, @Parameter(name="transformerClassName", desc="Class name of the divert's transformer") String var7) throws Exception;

    @Operation(desc="Create a Divert", impact=1)
    public void createDivert(@Parameter(name="name", desc="Name of the divert") String var1, @Parameter(name="routingName", desc="Routing name of the divert") String var2, @Parameter(name="address", desc="Address to divert from") String var3, @Parameter(name="forwardingAddress", desc="Address to divert to") String var4, @Parameter(name="exclusive", desc="Is the divert exclusive?") boolean var5, @Parameter(name="filterString", desc="Filter of the divert") String var6, @Parameter(name="transformerClassName", desc="Class name of the divert's transformer") String var7, @Parameter(name="routingType", desc="How should the routing-type on the diverted messages be set?") String var8) throws Exception;

    @Operation(desc="Create a Divert", impact=1)
    public void createDivert(@Parameter(name="name", desc="Name of the divert") String var1, @Parameter(name="routingName", desc="Routing name of the divert") String var2, @Parameter(name="address", desc="Address to divert from") String var3, @Parameter(name="forwardingAddress", desc="Address to divert to") String var4, @Parameter(name="exclusive", desc="Is the divert exclusive?") boolean var5, @Parameter(name="filterString", desc="Filter of the divert") String var6, @Parameter(name="transformerClassName", desc="Class name of the divert's transformer") String var7, @Parameter(name="transformerProperties", desc="Configuration properties of the divert's transformer") Map<String, String> var8, @Parameter(name="routingType", desc="How should the routing-type on the diverted messages be set?") String var9) throws Exception;

    @Operation(desc="Create a Divert", impact=1)
    public void createDivert(@Parameter(name="name", desc="Name of the divert") String var1, @Parameter(name="routingName", desc="Routing name of the divert") String var2, @Parameter(name="address", desc="Address to divert from") String var3, @Parameter(name="forwardingAddress", desc="Address to divert to") String var4, @Parameter(name="exclusive", desc="Is the divert exclusive?") boolean var5, @Parameter(name="filterString", desc="Filter of the divert") String var6, @Parameter(name="transformerClassName", desc="Class name of the divert's transformer") String var7, @Parameter(name="transformerPropertiesAsJSON", desc="Configuration properties of the divert's transformer in JSON form") String var8, @Parameter(name="routingType", desc="How should the routing-type on the diverted messages be set?") String var9) throws Exception;

    @Operation(desc="Update a divert", impact=1)
    public void updateDivert(@Parameter(name="name", desc="Name of the queue") String var1, @Parameter(name="forwardingAddress", desc="Address to divert to") String var2, @Parameter(name="filterString", desc="Filter of the divert") String var3, @Parameter(name="transformerClassName", desc="Class name of the divert's transformer") String var4, @Parameter(name="transformerProperties", desc="Configuration properties of the divert's transformer") Map<String, String> var5, @Parameter(name="routingType", desc="How should the routing-type on the diverted messages be set?") String var6) throws Exception;

    @Operation(desc="Destroy a Divert", impact=1)
    public void destroyDivert(@Parameter(name="name", desc="Name of the divert") String var1) throws Exception;

    @Attribute(desc="Names of the bridges deployed on this server")
    public String[] getBridgeNames();

    @Deprecated
    @Operation(desc="Create a Bridge", impact=1)
    public void createBridge(@Parameter(name="name", desc="Name of the bridge") String var1, @Parameter(name="queueName", desc="Name of the source queue") String var2, @Parameter(name="forwardingAddress", desc="Forwarding address") String var3, @Parameter(name="filterString", desc="Filter of the bridge") String var4, @Parameter(name="transformerClassName", desc="Class name of the bridge transformer") String var5, @Parameter(name="retryInterval", desc="Connection retry interval") long var6, @Parameter(name="retryIntervalMultiplier", desc="Connection retry interval multiplier") double var8, @Parameter(name="initialConnectAttempts", desc="Number of initial connection attempts") int var10, @Parameter(name="reconnectAttempts", desc="Number of reconnection attempts") int var11, @Parameter(name="useDuplicateDetection", desc="Use duplicate detection") boolean var12, @Parameter(name="confirmationWindowSize", desc="Confirmation window size") int var13, @Parameter(name="producerWindowSize", desc="Producer window size") int var14, @Parameter(name="clientFailureCheckPeriod", desc="Period to check client failure") long var15, @Parameter(name="staticConnectorNames", desc="comma separated list of connector names or name of discovery group if 'useDiscoveryGroup' is set to true") String var17, @Parameter(name="useDiscoveryGroup", desc="use discovery  group") boolean var18, @Parameter(name="ha", desc="Is it using HA") boolean var19, @Parameter(name="user", desc="User name") String var20, @Parameter(name="password", desc="User password") String var21) throws Exception;

    @Deprecated
    @Operation(desc="Create a Bridge", impact=1)
    public void createBridge(@Parameter(name="name", desc="Name of the bridge") String var1, @Parameter(name="queueName", desc="Name of the source queue") String var2, @Parameter(name="forwardingAddress", desc="Forwarding address") String var3, @Parameter(name="filterString", desc="Filter of the bridge") String var4, @Parameter(name="transformerClassName", desc="Class name of the bridge transformer") String var5, @Parameter(name="transformerProperties", desc="Configuration properties of the bridge transformer") Map<String, String> var6, @Parameter(name="retryInterval", desc="Connection retry interval") long var7, @Parameter(name="retryIntervalMultiplier", desc="Connection retry interval multiplier") double var9, @Parameter(name="initialConnectAttempts", desc="Number of initial connection attempts") int var11, @Parameter(name="reconnectAttempts", desc="Number of reconnection attempts") int var12, @Parameter(name="useDuplicateDetection", desc="Use duplicate detection") boolean var13, @Parameter(name="confirmationWindowSize", desc="Confirmation window size") int var14, @Parameter(name="producerWindowSize", desc="Producer window size") int var15, @Parameter(name="clientFailureCheckPeriod", desc="Period to check client failure") long var16, @Parameter(name="staticConnectorNames", desc="comma separated list of connector names or name of discovery group if 'useDiscoveryGroup' is set to true") String var18, @Parameter(name="useDiscoveryGroup", desc="use discovery  group") boolean var19, @Parameter(name="ha", desc="Is it using HA") boolean var20, @Parameter(name="user", desc="User name") String var21, @Parameter(name="password", desc="User password") String var22) throws Exception;

    @Deprecated
    @Operation(desc="Create a Bridge", impact=1)
    public void createBridge(@Parameter(name="name", desc="Name of the bridge") String var1, @Parameter(name="queueName", desc="Name of the source queue") String var2, @Parameter(name="forwardingAddress", desc="Forwarding address") String var3, @Parameter(name="filterString", desc="Filter of the bridge") String var4, @Parameter(name="transformerClassName", desc="Class name of the bridge transformer") String var5, @Parameter(name="transformerPropertiesAsJSON", desc="Configuration properties of the bridge transformer in JSON form") String var6, @Parameter(name="retryInterval", desc="Connection retry interval") long var7, @Parameter(name="retryIntervalMultiplier", desc="Connection retry interval multiplier") double var9, @Parameter(name="initialConnectAttempts", desc="Number of initial connection attempts") int var11, @Parameter(name="reconnectAttempts", desc="Number of reconnection attempts") int var12, @Parameter(name="useDuplicateDetection", desc="Use duplicate detection") boolean var13, @Parameter(name="confirmationWindowSize", desc="Confirmation window size") int var14, @Parameter(name="producerWindowSize", desc="Producer window size") int var15, @Parameter(name="clientFailureCheckPeriod", desc="Period to check client failure") long var16, @Parameter(name="staticConnectorNames", desc="comma separated list of connector names or name of discovery group if 'useDiscoveryGroup' is set to true") String var18, @Parameter(name="useDiscoveryGroup", desc="use discovery  group") boolean var19, @Parameter(name="ha", desc="Is it using HA") boolean var20, @Parameter(name="user", desc="User name") String var21, @Parameter(name="password", desc="User password") String var22) throws Exception;

    @Deprecated
    @Operation(desc="Create a Bridge", impact=1)
    public void createBridge(@Parameter(name="name", desc="Name of the bridge") String var1, @Parameter(name="queueName", desc="Name of the source queue") String var2, @Parameter(name="forwardingAddress", desc="Forwarding address") String var3, @Parameter(name="filterString", desc="Filter of the bridge") String var4, @Parameter(name="transformerClassName", desc="Class name of the bridge transformer") String var5, @Parameter(name="retryInterval", desc="Connection retry interval") long var6, @Parameter(name="retryIntervalMultiplier", desc="Connection retry interval multiplier") double var8, @Parameter(name="initialConnectAttempts", desc="Number of initial connection attempts") int var10, @Parameter(name="reconnectAttempts", desc="Number of reconnection attempts") int var11, @Parameter(name="useDuplicateDetection", desc="Use duplicate detection") boolean var12, @Parameter(name="confirmationWindowSize", desc="Confirmation window size") int var13, @Parameter(name="clientFailureCheckPeriod", desc="Period to check client failure") long var14, @Parameter(name="staticConnectorNames", desc="comma separated list of connector names or name of discovery group if 'useDiscoveryGroup' is set to true") String var16, @Parameter(name="useDiscoveryGroup", desc="use discovery  group") boolean var17, @Parameter(name="ha", desc="Is it using HA") boolean var18, @Parameter(name="user", desc="User name") String var19, @Parameter(name="password", desc="User password") String var20) throws Exception;

    @Operation(desc="Create a bridge", impact=1)
    public void createBridge(@Parameter(name="bridgeConfiguration", desc="the configuration of the bridge in JSON format") String var1) throws Exception;

    @Operation(desc="Destroy a bridge", impact=1)
    public void destroyBridge(@Parameter(name="name", desc="Name of the bridge") String var1) throws Exception;

    @Operation(desc="List the existing broker connections", impact=0)
    public String listBrokerConnections();

    @Operation(desc="Activate a broker connection that is pre configured", impact=1)
    public void startBrokerConnection(@Parameter(name="name", desc="Name of the broker connection to be started") String var1) throws Exception;

    @Operation(desc="Stops a broker connection that is pre configured", impact=1)
    public void stopBrokerConnection(@Parameter(name="name", desc="Name of the broker connection to be stopped") String var1) throws Exception;

    @Operation(desc="Create a connector service", impact=1)
    public void createConnectorService(@Parameter(name="name", desc="Name of the connector service") String var1, @Parameter(name="factoryClass", desc="Class name of the connector service factory") String var2, @Parameter(name="parameters", desc="Parameter specific to the connector service") Map<String, Object> var3) throws Exception;

    @Operation(desc="Destroy a connector service", impact=1)
    public void destroyConnectorService(@Parameter(name="name", desc="Name of the connector service") String var1) throws Exception;

    @Attribute(desc="Names of the connector services on this server")
    public String[] getConnectorServices();

    @Operation(desc="Force the server to stop and notify clients to failover", impact=3)
    public void forceFailover() throws Exception;

    @Operation(desc="Force the server to stop and to scale down to another server", impact=3)
    public void scaleDown(@Parameter(name="name", desc="The connector to use to scale down, if not provided the first appropriate connector will be used") String var1) throws Exception;

    @Operation(desc="List the Network Topology", impact=0)
    public String listNetworkTopology() throws Exception;

    @Operation(desc="Get the selected address", impact=0)
    public String getAddressInfo(@Parameter(name="address", desc="The address") String var1) throws ActiveMQAddressDoesNotExistException;

    @Operation(desc="Get a list of bindings associated with an address", impact=0)
    public String listBindingsForAddress(@Parameter(name="address", desc="The address") String var1) throws Exception;

    @Operation(desc="List Addresses on the broker", impact=0)
    public String listAddresses(@Parameter(name="separator", desc="Separator used on the string listing") String var1) throws Exception;

    @Operation(desc="Search for Connections", impact=0)
    public String listConnections(@Parameter(name="options", desc="Options") String var1, @Parameter(name="pageNumber", desc="Page Number") int var2, @Parameter(name="pageSize", desc="Page Size") int var3) throws Exception;

    @Operation(desc="Search for Sessions", impact=0)
    public String listSessions(@Parameter(name="options", desc="Options") String var1, @Parameter(name="pageNumber", desc="Page Number") int var2, @Parameter(name="pageSize", desc="Page Size") int var3) throws Exception;

    @Operation(desc="Search for Consumers", impact=0)
    public String listConsumers(@Parameter(name="options", desc="Options") String var1, @Parameter(name="pageNumber", desc="Page Number") int var2, @Parameter(name="pageSize", desc="Page Size") int var3) throws Exception;

    @Operation(desc="Search for Consumers", impact=0)
    public String listProducers(@Parameter(name="options", desc="Options") String var1, @Parameter(name="pageNumber", desc="Page Number") int var2, @Parameter(name="pageSize", desc="Page Size") int var3) throws Exception;

    @Operation(desc="Search for Addresses", impact=0)
    public String listAddresses(@Parameter(name="options", desc="Options") String var1, @Parameter(name="pageNumber", desc="Page Number") int var2, @Parameter(name="pageSize", desc="Page Size") int var3) throws Exception;

    @Operation(desc="Search for Queues", impact=0)
    public String listQueues(@Parameter(name="options", desc="Options") String var1, @Parameter(name="pageNumber", desc="Page Number") int var2, @Parameter(name="pageSize", desc="Page Size") int var3) throws Exception;

    @Operation(desc="Names of the queues created on this server with the given routing-type (i.e. ANYCAST or MULTICAST)", impact=0)
    public String[] getQueueNames(@Parameter(name="routingType", desc="The routing type, MULTICAST or ANYCAST") String var1);

    @Operation(desc="Names of the cluster-connections deployed on this server", impact=0)
    public String[] getClusterConnectionNames();

    @Operation(desc="add a user (only applicable when using the JAAS PropertiesLoginModule or the ActiveMQBasicSecurityManager)", impact=1)
    public void addUser(@Parameter(name="username", desc="Name of the user") String var1, @Parameter(name="password", desc="User's password") String var2, @Parameter(name="roles", desc="User's role (comma separated)") String var3, @Parameter(name="plaintext", desc="whether or not to store the password in plaintext or hash it") boolean var4) throws Exception;

    @Operation(desc="list info about a user or all users if no username is supplied (only applicable when using the JAAS PropertiesLoginModule or the ActiveMQBasicSecurityManager)", impact=1)
    public String listUser(@Parameter(name="username", desc="Name of the user; leave null to list all known users") String var1) throws Exception;

    @Operation(desc="remove a user (only applicable when using the JAAS PropertiesLoginModule or the ActiveMQBasicSecurityManager)", impact=1)
    public void removeUser(@Parameter(name="username", desc="Name of the user") String var1) throws Exception;

    @Operation(desc="set new properties on an existing user (only applicable when using the JAAS PropertiesLoginModule or the ActiveMQBasicSecurityManager)", impact=1)
    public void resetUser(@Parameter(name="username", desc="Name of the user") String var1, @Parameter(name="password", desc="User's password") String var2, @Parameter(name="roles", desc="User's role (comma separated)") String var3) throws Exception;

    @Operation(desc="set new properties on an existing user (only applicable when using the JAAS PropertiesLoginModule or the ActiveMQBasicSecurityManager)", impact=1)
    public void resetUser(@Parameter(name="username", desc="Name of the user") String var1, @Parameter(name="password", desc="User's password") String var2, @Parameter(name="roles", desc="User's role (comma separated)") String var3, @Parameter(name="plaintext", desc="whether or not to store the password in plaintext or hash it") boolean var4) throws Exception;

    @Operation(desc="forces the broker to reload its configuration file", impact=1)
    public void reloadConfigurationFile() throws Exception;

    @Operation(desc="Makes the broker to read messages from the retention folder matching the address and filter.", impact=1)
    public void replay(@Parameter(name="address", desc="Name of the address to replay") String var1, @Parameter(name="target", desc="Where the replay data should be sent") String var2, @Parameter(name="filter", desc="Filter to apply on message selection. Null means everything matching the address") String var3) throws Exception;

    @Operation(desc="Makes the broker to read messages from the retention folder matching the address and filter.", impact=1)
    public void replay(@Parameter(name="startScanDate", desc="Start date where we will start scanning for journals to replay. Format YYYYMMDDHHMMSS") String var1, @Parameter(name="endScanDate", desc="Finish date where we will stop scannning for journals to replay. Format YYYYMMDDHHMMSS") String var2, @Parameter(name="address", desc="Name of the address to replay") String var3, @Parameter(name="target", desc="Where the replay data should be sent") String var4, @Parameter(name="filter", desc="Filter to apply on message selection. Null means everything matching the address") String var5) throws Exception;
}

