/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.util.TimeScheduler;

public class AgeOutCache<K> {
    private final TimeScheduler timer;
    private long timeout;
    private final ConcurrentMap<K, Future> map = new ConcurrentHashMap<K, Future>();
    private Handler handler;

    public AgeOutCache(TimeScheduler timer, long timeout) {
        this.timer = timer;
        this.timeout = timeout;
    }

    public AgeOutCache(TimeScheduler timer, long timeout, Handler handler) {
        this(timer, timeout);
        this.handler = handler;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void add(final K key) {
        Future<?> future = this.timer.schedule(new Runnable(){

            @Override
            public void run() {
                Future tmp;
                if (AgeOutCache.this.handler != null) {
                    try {
                        AgeOutCache.this.handler.expired(key);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if ((tmp = (Future)AgeOutCache.this.map.remove(key)) != null) {
                    tmp.cancel(true);
                }
            }

            public String toString() {
                return "AgeOutCache (timeout=" + AgeOutCache.this.timeout + ", handler=" + (AgeOutCache.this.handler != null ? AgeOutCache.this.handler.getClass().getSimpleName() : null) + ")";
            }
        }, this.timeout, TimeUnit.MILLISECONDS);
        Future<?> result = this.map.putIfAbsent(key, future);
        if (result != null) {
            future.cancel(true);
        }
    }

    public boolean contains(K key) {
        return key != null && this.map.containsKey(key);
    }

    public void remove(K key) {
        Future future = (Future)this.map.remove(key);
        if (future != null) {
            future.cancel(true);
        }
    }

    public void removeAll(Collection<K> keys) {
        if (keys != null) {
            for (K key : keys) {
                this.remove(key);
            }
        }
    }

    public void clear() {
        for (Future future : this.map.values()) {
            future.cancel(true);
        }
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.map.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static interface Handler<K> {
        public void expired(K var1);
    }
}

