/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ListeningMessageSearchIndex
implements MessageSearchIndex,
EventListener.ReactiveGroupEventListener {
    protected static final int UNLIMITED = -1;
    private final MailboxSessionMapperFactory factory;
    private final SessionProvider sessionProvider;
    private static final ImmutableList<Class<? extends Event>> INTERESTING_EVENTS = ImmutableList.of(MailboxEvents.Added.class, MailboxEvents.Expunged.class, MailboxEvents.FlagsUpdated.class, MailboxEvents.MailboxDeletion.class);

    public ListeningMessageSearchIndex(MailboxSessionMapperFactory factory, SessionProvider sessionProvider) {
        this.factory = factory;
        this.sessionProvider = sessionProvider;
    }

    public boolean isHandling(Event event) {
        return INTERESTING_EVENTS.contains(event.getClass());
    }

    public Mono<Void> reactiveEvent(Event event) {
        return this.handleMailboxEvent(event, this.sessionProvider.createSystemSession(event.getUsername()), (MailboxEvents.MailboxEvent)event);
    }

    private Mono<Void> handleMailboxEvent(Event event, MailboxSession session, MailboxEvents.MailboxEvent mailboxEvent) {
        MailboxId mailboxId = mailboxEvent.getMailboxId();
        if (event instanceof MailboxEvents.Added) {
            return this.factory.getMailboxMapper(session).findMailboxById(mailboxId).flatMap(mailbox -> this.handleAdded(session, (Mailbox)mailbox, (MailboxEvents.Added)event));
        }
        if (event instanceof MailboxEvents.Expunged) {
            MailboxEvents.Expunged expunged = (MailboxEvents.Expunged)event;
            return this.delete(session, mailboxId, expunged.getUids());
        }
        if (event instanceof MailboxEvents.FlagsUpdated) {
            MailboxEvents.FlagsUpdated flagsUpdated = (MailboxEvents.FlagsUpdated)event;
            return this.update(session, mailboxId, flagsUpdated.getUpdatedFlags());
        }
        if (event instanceof MailboxEvents.MailboxDeletion) {
            return this.deleteAll(session, mailboxId);
        }
        return Mono.empty();
    }

    private Mono<Void> handleAdded(MailboxSession session, Mailbox mailbox, MailboxEvents.Added added) {
        return Flux.fromIterable((Iterable)MessageRange.toRanges((Collection)added.getUids())).concatMap(range -> this.retrieveMailboxMessages(session, mailbox, (MessageRange)range)).concatMap(mailboxMessage -> this.add(session, mailbox, (MailboxMessage)mailboxMessage)).then();
    }

    private Flux<MailboxMessage> retrieveMailboxMessages(MailboxSession session, Mailbox mailbox, MessageRange range) {
        return this.factory.getMessageMapper(session).findInMailboxReactive(mailbox, range, MessageMapper.FetchType.FULL, -1);
    }

    public abstract Mono<Void> add(MailboxSession var1, Mailbox var2, MailboxMessage var3);

    public abstract Mono<Void> delete(MailboxSession var1, MailboxId var2, Collection<MessageUid> var3);

    public abstract Mono<Void> deleteAll(MailboxSession var1, MailboxId var2);

    public abstract Mono<Void> update(MailboxSession var1, MailboxId var2, List<UpdatedFlags> var3);

    public abstract Mono<Flags> retrieveIndexedFlags(Mailbox var1, MessageUid var2);
}

