/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.driver.core.Cluster;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.Callable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.james.backends.cassandra.init.ClusterFactory;
import org.apache.james.backends.cassandra.init.KeyspaceFactory;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.init.configuration.ClusterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

@Singleton
public class ResilientClusterProvider
implements Provider<Cluster> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResilientClusterProvider.class);
    private final Cluster cluster;

    @Inject
    @VisibleForTesting
    ResilientClusterProvider(ClusterConfiguration configuration, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        Duration waitDelay = Duration.ofMillis(configuration.getMinDelay());
        this.cluster = (Cluster)Mono.fromCallable(this.getClusterRetryCallable(configuration, consistenciesConfiguration)).doOnError(e -> LOGGER.warn("Error establishing Cassandra connection. Next retry scheduled in {} ms", (Object)waitDelay, e)).retryWhen((Retry)Retry.backoff((long)configuration.getMaxRetry(), (Duration)waitDelay).scheduler(Schedulers.elastic())).publishOn(Schedulers.elastic()).block();
    }

    private Callable<Cluster> getClusterRetryCallable(ClusterConfiguration configuration, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        LOGGER.info("Trying to connect to Cassandra service at {} (list {})", (Object)LocalDateTime.now(), (Object)ImmutableList.copyOf(configuration.getHosts()).toString());
        return () -> {
            Cluster cluster = ClusterFactory.create(configuration, consistenciesConfiguration);
            try {
                KeyspaceFactory.keyspaceExist(cluster, "any");
                return cluster;
            }
            catch (Exception e) {
                cluster.close();
                throw e;
            }
        };
    }

    public Cluster get() {
        return this.cluster;
    }

    @PreDestroy
    public void stop() {
        this.cluster.closeAsync();
    }
}

