/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.jsieve.ActionContext;
import org.apache.james.transport.mailets.jsieve.ActionUtils;
import org.apache.james.transport.mailets.jsieve.MailAction;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.ActionFileInto;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIntoAction
implements MailAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileIntoAction.class);
    private static final char HIERARCHY_DELIMITER = '.';

    @Override
    public void execute(Action action, Mail mail, ActionContext context) throws MessagingException {
        if (action instanceof ActionFileInto) {
            ActionFileInto fileIntoAction = (ActionFileInto)action;
            this.execute(fileIntoAction, mail, context);
        }
    }

    public void execute(ActionFileInto anAction, Mail aMail, ActionContext context) throws MessagingException {
        Object destinationMailbox = anAction.getDestination();
        MailAddress recipient = ActionUtils.getSoleRecipient(aMail);
        if (((String)destinationMailbox).length() <= 0 || ((String)destinationMailbox).charAt(0) != '.') {
            destinationMailbox = "." + (String)destinationMailbox;
        }
        String mailbox = ((String)destinationMailbox).replace('.', '/');
        String url = "mailbox://" + recipient.asString() + mailbox;
        context.post(url, aMail);
        LOGGER.debug("Filed Message ID: {} into destination: \"{}\"", (Object)aMail.getMessage().getMessageID(), destinationMailbox);
    }
}

