/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.incubator.quic;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.util.NetUtil;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Objects;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Operators;
import reactor.netty.ChannelBindException;
import reactor.netty.Connection;
import reactor.netty.ReactorNetty;
import reactor.netty.incubator.quic.QuicServer;
import reactor.netty.incubator.quic.QuicServerConfig;
import reactor.netty.transport.AddressUtils;
import reactor.netty.transport.TransportConfig;
import reactor.netty.transport.TransportConnector;
import reactor.util.context.Context;

final class QuicServerBind
extends QuicServer {
    static final QuicServerBind INSTANCE = new QuicServerBind();
    final QuicServerConfig config;

    QuicServerBind() {
        this.config = new QuicServerConfig(Collections.emptyMap(), Collections.singletonMap(ChannelOption.AUTO_READ, false), () -> new InetSocketAddress(NetUtil.LOCALHOST, 0));
    }

    QuicServerBind(QuicServerConfig config) {
        this.config = config;
    }

    @Override
    public Mono<? extends Connection> bind() {
        QuicServerConfig config = this.configuration();
        QuicServerBind.validate(config);
        Mono mono = Mono.create(sink -> {
            InetSocketAddress localInet;
            SocketAddress local = Objects.requireNonNull((SocketAddress)config.bindAddress().get(), "Bind Address supplier returned null");
            if (local instanceof InetSocketAddress && (localInet = (InetSocketAddress)local).isUnresolved()) {
                local = AddressUtils.createResolved((String)localInet.getHostName(), (int)localInet.getPort());
            }
            DisposableBind disposableBind = new DisposableBind(local, (MonoSink<Connection>)sink);
            TransportConnector.bind((TransportConfig)config, config.parentChannelInitializer(), (SocketAddress)local, (boolean)false).subscribe((CoreSubscriber)disposableBind);
        });
        if (config.doOnBind() != null) {
            mono = mono.doOnSubscribe(s -> config.doOnBind().accept(config));
        }
        return mono;
    }

    public QuicServerConfig configuration() {
        return this.config;
    }

    protected QuicServer duplicate() {
        return new QuicServerBind(new QuicServerConfig(this.config));
    }

    static void validate(QuicServerConfig config) {
        Objects.requireNonNull(config.bindAddress(), "bindAddress");
        Objects.requireNonNull(config.sslEngineProvider, "sslEngineProvider");
        Objects.requireNonNull(config.tokenHandler, "tokenHandler");
    }

    static final class DisposableBind
    implements CoreSubscriber<Channel>,
    Disposable {
        final SocketAddress bindAddress;
        final MonoSink<Connection> sink;
        Subscription subscription;

        DisposableBind(SocketAddress bindAddress, MonoSink<Connection> sink) {
            this.bindAddress = bindAddress;
            this.sink = sink;
        }

        public Context currentContext() {
            return this.sink.currentContext();
        }

        public void dispose() {
            this.subscription.cancel();
        }

        public void onComplete() {
        }

        public void onError(Throwable t) {
            if (t instanceof BindException || t instanceof IOException && t.getMessage() != null && t.getMessage().contains("bind(..)")) {
                this.sink.error((Throwable)ChannelBindException.fail((SocketAddress)this.bindAddress, null));
            } else {
                this.sink.error(t);
            }
        }

        public void onNext(Channel channel) {
            if (QuicServer.log.isDebugEnabled()) {
                QuicServer.log.debug(ReactorNetty.format((Channel)channel, (String)"Bound new channel"));
            }
            this.sink.success((Object)Connection.from((Channel)channel));
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.subscription, (Subscription)s)) {
                this.subscription = s;
                this.sink.onCancel((Disposable)this);
                s.request(Long.MAX_VALUE);
            }
        }
    }
}

