/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.flush;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FlushRequest
extends BroadcastRequest<FlushRequest> {
    private boolean force = false;
    private boolean waitIfOngoing = true;

    public FlushRequest(String ... indices) {
        super(indices);
    }

    public FlushRequest(StreamInput in) throws IOException {
        super(in);
        this.force = in.readBoolean();
        this.waitIfOngoing = in.readBoolean();
    }

    public boolean waitIfOngoing() {
        return this.waitIfOngoing;
    }

    public FlushRequest waitIfOngoing(boolean waitIfOngoing) {
        this.waitIfOngoing = waitIfOngoing;
        return this;
    }

    public boolean force() {
        return this.force;
    }

    public FlushRequest force(boolean force) {
        this.force = force;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationError = super.validate();
        if (this.force && !this.waitIfOngoing) {
            validationError = ValidateActions.addValidationError("wait_if_ongoing must be true for a force flush", validationError);
        }
        return validationError;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.force);
        out.writeBoolean(this.waitIfOngoing);
    }

    public String toString() {
        return "FlushRequest{waitIfOngoing=" + this.waitIfOngoing + ", force=" + this.force + "}";
    }
}

