/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.monitor.Probes;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.process.ProcessInfo;
import org.elasticsearch.monitor.process.ProcessStats;

public class ProcessProbe {
    private static final OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
    private static final Method getMaxFileDescriptorCountField = ProcessProbe.getUnixMethod("getMaxFileDescriptorCount");
    private static final Method getOpenFileDescriptorCountField = ProcessProbe.getUnixMethod("getOpenFileDescriptorCount");
    private static final Method getProcessCpuLoad = ProcessProbe.getMethod("getProcessCpuLoad");
    private static final Method getProcessCpuTime = ProcessProbe.getMethod("getProcessCpuTime");
    private static final Method getCommittedVirtualMemorySize = ProcessProbe.getMethod("getCommittedVirtualMemorySize");

    public static ProcessProbe getInstance() {
        return ProcessProbeHolder.INSTANCE;
    }

    private ProcessProbe() {
    }

    public long getMaxFileDescriptorCount() {
        if (getMaxFileDescriptorCountField == null) {
            return -1L;
        }
        try {
            return (Long)getMaxFileDescriptorCountField.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception t) {
            return -1L;
        }
    }

    public long getOpenFileDescriptorCount() {
        if (getOpenFileDescriptorCountField == null) {
            return -1L;
        }
        try {
            return (Long)getOpenFileDescriptorCountField.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception t) {
            return -1L;
        }
    }

    public short getProcessCpuPercent() {
        return Probes.getLoadAndScaleToPercent(getProcessCpuLoad, osMxBean);
    }

    public long getProcessCpuTotalTime() {
        if (getProcessCpuTime != null) {
            try {
                long time = (Long)getProcessCpuTime.invoke((Object)osMxBean, new Object[0]);
                if (time >= 0L) {
                    return time / 1000000L;
                }
            }
            catch (Exception t) {
                return -1L;
            }
        }
        return -1L;
    }

    public long getTotalVirtualMemorySize() {
        if (getCommittedVirtualMemorySize != null) {
            try {
                long virtual = (Long)getCommittedVirtualMemorySize.invoke((Object)osMxBean, new Object[0]);
                if (virtual >= 0L) {
                    return virtual;
                }
            }
            catch (Exception t) {
                return -1L;
            }
        }
        return -1L;
    }

    public ProcessInfo processInfo(long refreshInterval) {
        return new ProcessInfo(JvmInfo.jvmInfo().pid(), BootstrapInfo.isMemoryLocked(), refreshInterval);
    }

    public ProcessStats processStats() {
        ProcessStats.Cpu cpu = new ProcessStats.Cpu(this.getProcessCpuPercent(), this.getProcessCpuTotalTime());
        ProcessStats.Mem mem = new ProcessStats.Mem(this.getTotalVirtualMemorySize());
        return new ProcessStats(System.currentTimeMillis(), this.getOpenFileDescriptorCount(), this.getMaxFileDescriptorCount(), cpu, mem);
    }

    private static Method getMethod(String methodName) {
        try {
            return Class.forName("com.sun.management.OperatingSystemMXBean").getMethod(methodName, new Class[0]);
        }
        catch (Exception t) {
            return null;
        }
    }

    private static Method getUnixMethod(String methodName) {
        try {
            return Class.forName("com.sun.management.UnixOperatingSystemMXBean").getMethod(methodName, new Class[0]);
        }
        catch (Exception t) {
            return null;
        }
    }

    private static class ProcessProbeHolder {
        private static final ProcessProbe INSTANCE = new ProcessProbe();

        private ProcessProbeHolder() {
        }
    }
}

