/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum ChangeType {
    ADD("add"),
    DELETE("delete"),
    MODIFY("modify"),
    MODIFY_DN("moddn");

    @NotNull
    private final String name;

    private ChangeType(String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public static ChangeType forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "add": {
                return ADD;
            }
            case "delete": 
            case "del": {
                return DELETE;
            }
            case "modify": 
            case "mod": {
                return MODIFY;
            }
            case "modifydn": 
            case "modify-dn": 
            case "modify_dn": 
            case "moddn": 
            case "mod-dn": 
            case "mod_dn": 
            case "modifyrdn": 
            case "modify-rdn": 
            case "modify_rdn": 
            case "modrdn": 
            case "mod-rdn": 
            case "mod_rdn": {
                return MODIFY_DN;
            }
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.name;
    }
}

